/*     */ package org.jboss.security.plugins;
/*     */ 
/*     */ import com.sun.xacml.Policy;
/*     */ import java.io.InputStream;
/*     */ import java.net.URL;
/*     */ import java.security.Principal;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.acl.Group;
/*     */ import java.util.Enumeration;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.auth.callback.CallbackHandler;
/*     */ import javax.security.jacc.PolicyContext;
/*     */ import javax.security.jacc.PolicyContextException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.AnybodyPrincipal;
/*     */ import org.jboss.security.AuthorizationManager;
/*     */ import org.jboss.security.NobodyPrincipal;
/*     */ import org.jboss.security.SecurityContext;
/*     */ import org.jboss.security.SecurityRolesAssociation;
/*     */ import org.jboss.security.SimpleGroup;
/*     */ import org.jboss.security.authorization.AuthorizationContext;
/*     */ import org.jboss.security.authorization.AuthorizationException;
/*     */ import org.jboss.security.authorization.EntitlementHolder;
/*     */ import org.jboss.security.authorization.PolicyRegistration;
/*     */ import org.jboss.security.authorization.Resource;
/*     */ import org.jboss.security.identity.Identity;
/*     */ import org.jboss.security.mapping.MappingContext;
/*     */ import org.jboss.security.mapping.MappingManager;
/*     */ import org.jboss.security.mapping.MappingResult;
/*     */ import org.jboss.security.plugins.authorization.JBossAuthorizationContext;
/*     */ import org.jboss.util.xml.DOMUtils;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class JBossAuthorizationManager
/*     */   implements AuthorizationManager, PolicyRegistration
/*     */ {
/*     */   private String securityDomain;
/*  78 */   private Map contextIdToPolicy = new HashMap();
/*     */ 
/*  80 */   private static Logger log = Logger.getLogger(JBossAuthorizationManager.class);
/*     */ 
/*  82 */   protected boolean trace = log.isTraceEnabled();
/*     */ 
/*  84 */   private CallbackHandler callbackHandler = null;
/*     */ 
/*  86 */   private AuthorizationContext authorizationContext = null;
/*     */ 
/*     */   public JBossAuthorizationManager(String securityDomainName)
/*     */   {
/*  90 */     this.securityDomain = securityDomainName;
/*     */   }
/*     */ 
/*     */   public JBossAuthorizationManager(String securityDomainName, CallbackHandler cbh)
/*     */   {
/*  95 */     this(securityDomainName);
/*  96 */     this.callbackHandler = cbh;
/*     */   }
/*     */ 
/*     */   public int authorize(Resource resource)
/*     */     throws AuthorizationException
/*     */   {
/* 104 */     String SUBJECT_CONTEXT_KEY = "javax.security.auth.Subject.container";
/* 105 */     Subject subject = null;
/*     */     try
/*     */     {
/* 108 */       subject = (Subject)PolicyContext.getContext(SUBJECT_CONTEXT_KEY);
/*     */     }
/*     */     catch (PolicyContextException e)
/*     */     {
/* 112 */       log.error("Error obtaining AuthenticatedSubject:", e);
/*     */     }
/* 114 */     if (this.authorizationContext == null) {
/* 115 */       this.authorizationContext = new JBossAuthorizationContext(this.securityDomain, subject, this.callbackHandler);
/*     */     }
/* 117 */     return this.authorizationContext.authorize(resource);
/*     */   }
/*     */ 
/*     */   public boolean doesUserHaveRole(Principal principal, Set<Principal> rolePrincipals)
/*     */   {
/* 139 */     boolean hasRole = false;
/* 140 */     Group roles = getCurrentRoles(principal);
/* 141 */     if (this.trace)
/* 142 */       log.trace("doesUserHaveRole(Set), roles: " + roles);
/* 143 */     if (roles != null)
/*     */     {
/* 145 */       Iterator iter = rolePrincipals.iterator();
/* 146 */       while ((!hasRole) && (iter.hasNext()))
/*     */       {
/* 148 */         Principal role = (Principal)iter.next();
/* 149 */         hasRole = doesRoleGroupHaveRole(role, roles);
/* 150 */         if (this.trace)
/* 151 */           log.trace("hasRole(" + role + ")=" + hasRole);
/*     */       }
/* 153 */       if (this.trace)
/* 154 */         log.trace("hasRole=" + hasRole);
/*     */     }
/* 156 */     return hasRole;
/*     */   }
/*     */ 
/*     */   public boolean doesUserHaveRole(Principal principal, Principal role)
/*     */   {
/* 172 */     boolean hasRole = false;
/* 173 */     Group roles = getCurrentRoles(principal);
/* 174 */     hasRole = doesRoleGroupHaveRole(role, roles);
/* 175 */     return hasRole;
/*     */   }
/*     */ 
/*     */   public Set<Principal> getUserRoles(Principal principal)
/*     */   {
/* 188 */     Group userRoles = getCurrentRoles(principal);
/* 189 */     return getRolesAsSet(userRoles);
/*     */   }
/*     */ 
/*     */   protected boolean doesRoleGroupHaveRole(Principal role, Group userRoles)
/*     */   {
/* 205 */     if ((role instanceof NobodyPrincipal)) {
/* 206 */       return false;
/*     */     }
/*     */ 
/* 209 */     boolean isMember = userRoles.isMember(role);
/* 210 */     if (!isMember)
/*     */     {
/* 212 */       isMember = role instanceof AnybodyPrincipal;
/*     */     }
/*     */ 
/* 215 */     return isMember;
/*     */   }
/*     */ 
/*     */   public void registerPolicy(String contextID, URL location)
/*     */   {
/*     */     try
/*     */     {
/* 225 */       if (this.trace) {
/* 226 */         log.trace("Registering policy for contextId:" + contextID + " and location:" + location.getPath());
/*     */       }
/* 228 */       registerPolicy(contextID, location.openStream());
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 232 */       log.debug("Error in registering xacml policy:", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void registerPolicy(String contextID, InputStream stream)
/*     */   {
/*     */     try
/*     */     {
/* 243 */       Element elm = DOMUtils.parse(stream);
/* 244 */       Policy policy = Policy.getInstance(elm);
/* 245 */       this.contextIdToPolicy.put(contextID, policy);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 249 */       log.debug("Error in registering xacml policy:", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void deRegisterPolicy(String contextID)
/*     */   {
/* 258 */     this.contextIdToPolicy.remove(contextID);
/* 259 */     if (this.trace)
/* 260 */       log.trace("DeRegistered policy for contextId:" + contextID);
/*     */   }
/*     */ 
/*     */   public Object getPolicy(String contextID, Map contextMap)
/*     */   {
/* 268 */     return this.contextIdToPolicy.get(contextID);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 276 */     StringBuffer buf = new StringBuffer();
/* 277 */     buf.append("[AuthorizationManager:class=").append(getClass().getName());
/* 278 */     buf.append(":").append(this.securityDomain).append(":");
/* 279 */     buf.append("]");
/* 280 */     return buf.toString();
/*     */   }
/*     */ 
/*     */   public void setAuthorizationContext(AuthorizationContext ac)
/*     */   {
/* 289 */     if (ac == null)
/* 290 */       throw new IllegalArgumentException("AuthorizationContext is null");
/* 291 */     this.authorizationContext = ac;
/*     */   }
/*     */ 
/*     */   public String getSecurityDomain()
/*     */   {
/* 296 */     return this.securityDomain;
/*     */   }
/*     */ 
/*     */   private HashSet getRolesAsSet(Group roles)
/*     */   {
/* 302 */     HashSet userRoles = null;
/* 303 */     if (roles != null)
/*     */     {
/* 305 */       userRoles = new HashSet();
/* 306 */       Enumeration members = roles.members();
/* 307 */       while (members.hasMoreElements())
/*     */       {
/* 309 */         Principal role = (Principal)members.nextElement();
/* 310 */         userRoles.add(role);
/*     */       }
/*     */     }
/* 313 */     return userRoles;
/*     */   }
/*     */ 
/*     */   private Group getCurrentRoles(Principal principal)
/*     */   {
/* 323 */     boolean emptyContextRoles = false;
/*     */ 
/* 325 */     Subject subject = null;
/*     */     try
/*     */     {
/* 328 */       subject = SubjectActions.getActiveSubject();
/*     */     }
/*     */     catch (PrivilegedActionException e)
/*     */     {
/* 332 */       throw new IllegalStateException(e);
/*     */     }
/* 334 */     Group subjectRoles = getSubjectRoles(subject);
/*     */ 
/* 337 */     SecurityContext sc = SubjectActions.getSecurityContext();
/* 338 */     if (sc == null)
/*     */     {
/* 340 */       sc = new JBossSecurityContext(this.securityDomain);
/* 341 */       SubjectActions.setSecurityContext(sc);
/*     */     }
/*     */ 
/* 344 */     Group userRoles = (Group)sc.getData().get("Roles");
/* 345 */     if ((userRoles == null) || ("true".equalsIgnoreCase(SubjectActions.getRefreshSecurityContextRoles())))
/* 346 */       emptyContextRoles = true;
/* 347 */     userRoles = copyGroups(userRoles, subjectRoles);
/*     */ 
/* 354 */     if ((subjectRoles != userRoles) || (emptyContextRoles))
/*     */     {
/* 356 */       MappingManager mm = sc.getMappingManager();
/* 357 */       MappingContext mc = mm.getMappingContext(Group.class);
/* 358 */       Group mappedUserRoles = userRoles;
/* 359 */       if (mc != null)
/*     */       {
/* 361 */         Map contextMap = new HashMap();
/* 362 */         contextMap.put("Roles", userRoles);
/* 363 */         contextMap.put("Principal", principal);
/*     */ 
/* 365 */         contextMap.put("deploymentPrincipalRolesMap", SecurityRolesAssociation.getSecurityRoles());
/*     */ 
/* 369 */         contextMap.put("PrincipalsSet", subject.getPrincipals());
/* 370 */         if (this.trace)
/* 371 */           log.trace("Roles before mapping:" + userRoles);
/* 372 */         mc.performMapping(contextMap, userRoles);
/* 373 */         mappedUserRoles = (Group)mc.getMappingResult().getMappedObject();
/* 374 */         if (this.trace)
/* 375 */           log.trace("Roles after mapping:" + userRoles);
/*     */       }
/* 377 */       sc.getData().put("Roles", mappedUserRoles);
/*     */     }
/*     */ 
/* 381 */     return userRoles;
/*     */   }
/*     */ 
/*     */   private Group copyGroups(Group source, Group toCopy)
/*     */   {
/* 393 */     if (toCopy == null)
/* 394 */       return source;
/* 395 */     if ((source == null) && (toCopy != null))
/* 396 */       source = new SimpleGroup("Roles");
/* 397 */     Enumeration en = toCopy.members();
/* 398 */     while (en.hasMoreElements())
/*     */     {
/* 400 */       source.addMember((Principal)en.nextElement());
/*     */     }
/*     */ 
/* 403 */     return source;
/*     */   }
/*     */ 
/*     */   public Group getTargetRoles(Principal targetPrincipal, Map contextMap)
/*     */   {
/* 411 */     throw new RuntimeException("Not implemented");
/*     */   }
/*     */ 
/*     */   private Group getSubjectRoles(Subject theSubject)
/*     */   {
/* 421 */     if (theSubject == null)
/* 422 */       throw new IllegalArgumentException("Subject is null");
/* 423 */     Set subjectGroups = theSubject.getPrincipals(Group.class);
/* 424 */     Iterator iter = subjectGroups.iterator();
/* 425 */     Group roles = null;
/* 426 */     while (iter.hasNext())
/*     */     {
/* 428 */       Group grp = (Group)iter.next();
/* 429 */       String name = grp.getName();
/* 430 */       if (name.equals("Roles"))
/* 431 */         roles = grp;
/*     */     }
/* 433 */     return roles;
/*     */   }
/*     */ 
/*     */   public EntitlementHolder<?> entitlements(Resource resource, Identity identity)
/*     */     throws AuthorizationException
/*     */   {
/* 439 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.plugins.JBossAuthorizationManager
 * JD-Core Version:    0.6.0
 */