/*     */ package org.jboss.security.plugins;
/*     */ 
/*     */ import java.io.BufferedReader;
/*     */ import java.io.File;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.InputStreamReader;
/*     */ import java.io.PrintStream;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Method;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.security.KeyStore;
/*     */ import java.util.Arrays;
/*     */ import java.util.StringTokenizer;
/*     */ import javax.crypto.Cipher;
/*     */ import javax.crypto.SecretKey;
/*     */ import javax.crypto.SecretKeyFactory;
/*     */ import javax.crypto.spec.PBEKeySpec;
/*     */ import javax.crypto.spec.PBEParameterSpec;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import javax.net.ssl.KeyManagerFactory;
/*     */ import javax.net.ssl.TrustManagerFactory;
/*     */ import javax.security.auth.callback.CallbackHandler;
/*     */ import org.jboss.crypto.CryptoUtil;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.util.MBeanServerLocator;
/*     */ import org.jboss.security.ISecurityManagement;
/*     */ import org.jboss.security.SecurityDomain;
/*     */ import org.jboss.security.auth.callback.SecurityAssociationHandler;
/*     */ import org.jboss.security.integration.JNDIBasedSecurityManagement;
/*     */ 
/*     */ public class JaasSecurityDomain extends JaasSecurityManager
/*     */   implements SecurityDomain, JaasSecurityDomainMBean
/*     */ {
/* 120 */   private static final RuntimePermission encodePermission = new RuntimePermission("org.jboss.security.plugins.JaasSecurityDomain.encode");
/*     */ 
/* 124 */   private static final RuntimePermission decodePermission = new RuntimePermission("org.jboss.security.plugins.JaasSecurityDomain.decode");
/*     */   private KeyStore keyStore;
/*     */   private KeyManagerFactory keyMgr;
/* 133 */   private String keyStoreType = "JKS";
/*     */   private URL keyStoreURL;
/*     */   private char[] keyStorePassword;
/*     */   private SecretKey cipherKey;
/* 145 */   private String cipherAlgorithm = "PBEwithMD5andDES";
/*     */ 
/* 147 */   private byte[] salt = { 1, 2, 3, 4, 5, 6, 7, 8 };
/*     */ 
/* 149 */   private int iterationCount = 103;
/*     */   private PBEParameterSpec cipherSpec;
/* 154 */   private ObjectName managerServiceName = JaasSecurityManagerServiceMBean.OBJECT_NAME;
/*     */   private KeyStore trustStore;
/* 158 */   private String trustStoreType = "JKS";
/*     */   private char[] trustStorePassword;
/*     */   private URL trustStoreURL;
/*     */   private TrustManagerFactory trustMgr;
/* 167 */   private ISecurityManagement securityManagement = new JNDIBasedSecurityManagement();
/*     */ 
/*     */   public JaasSecurityDomain()
/*     */   {
/*     */   }
/*     */ 
/*     */   public JaasSecurityDomain(String securityDomain)
/*     */   {
/* 183 */     this(securityDomain, new SecurityAssociationHandler());
/*     */   }
/*     */ 
/*     */   public JaasSecurityDomain(String securityDomain, CallbackHandler handler)
/*     */   {
/* 193 */     super(securityDomain, handler);
/*     */   }
/*     */ 
/*     */   public KeyStore getKeyStore() throws SecurityException
/*     */   {
/* 198 */     return this.keyStore;
/*     */   }
/*     */ 
/*     */   public KeyManagerFactory getKeyManagerFactory() throws SecurityException
/*     */   {
/* 203 */     return this.keyMgr;
/*     */   }
/*     */ 
/*     */   public KeyStore getTrustStore() throws SecurityException
/*     */   {
/* 208 */     return this.trustStore;
/*     */   }
/*     */ 
/*     */   public TrustManagerFactory getTrustManagerFactory() throws SecurityException
/*     */   {
/* 213 */     return this.trustMgr;
/*     */   }
/*     */ 
/*     */   public ObjectName getManagerServiceName()
/*     */   {
/* 221 */     return this.managerServiceName;
/*     */   }
/*     */ 
/*     */   public void setManagerServiceName(ObjectName managerServiceName)
/*     */   {
/* 228 */     this.managerServiceName = managerServiceName;
/*     */   }
/*     */ 
/*     */   public String getKeyStoreType()
/*     */   {
/* 233 */     return this.keyStoreType;
/*     */   }
/*     */ 
/*     */   public void setKeyStoreType(String type)
/*     */   {
/* 238 */     this.keyStoreType = type;
/*     */   }
/*     */ 
/*     */   public String getKeyStoreURL()
/*     */   {
/* 243 */     String url = null;
/* 244 */     if (this.keyStoreURL != null)
/* 245 */       url = this.keyStoreURL.toExternalForm();
/* 246 */     return url;
/*     */   }
/*     */ 
/*     */   public void setKeyStoreURL(String storeURL) throws IOException
/*     */   {
/* 251 */     this.keyStoreURL = validateStoreURL(storeURL);
/* 252 */     this.log.debug("Using KeyStore=" + this.keyStoreURL.toExternalForm());
/*     */   }
/*     */ 
/*     */   public void setKeyStorePass(String password) throws Exception
/*     */   {
/* 257 */     this.keyStorePassword = loadPassword(password);
/*     */   }
/*     */ 
/*     */   public String getTrustStoreType()
/*     */   {
/* 262 */     return this.trustStoreType;
/*     */   }
/*     */ 
/*     */   public void setTrustStoreType(String type)
/*     */   {
/* 267 */     this.trustStoreType = type;
/*     */   }
/*     */ 
/*     */   public void setTrustStorePass(String password) throws Exception
/*     */   {
/* 272 */     this.trustStorePassword = loadPassword(password);
/*     */   }
/*     */ 
/*     */   public String getTrustStoreURL()
/*     */   {
/* 277 */     String url = null;
/* 278 */     if (this.trustStoreURL != null)
/* 279 */       url = this.trustStoreURL.toExternalForm();
/* 280 */     return url;
/*     */   }
/*     */ 
/*     */   public void setTrustStoreURL(String storeURL) throws IOException
/*     */   {
/* 285 */     this.trustStoreURL = validateStoreURL(storeURL);
/*     */   }
/*     */ 
/*     */   public void setSalt(String salt)
/*     */   {
/* 290 */     this.salt = salt.getBytes();
/*     */   }
/*     */ 
/*     */   public void setIterationCount(int iterationCount)
/*     */   {
/* 295 */     this.iterationCount = iterationCount;
/*     */   }
/*     */ 
/*     */   public String getCipherAlgorithm()
/*     */   {
/* 300 */     return this.cipherAlgorithm;
/*     */   }
/*     */ 
/*     */   public void setCipherAlgorithm(String cipherAlgorithm)
/*     */   {
/* 305 */     this.cipherAlgorithm = cipherAlgorithm;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 310 */     return "JaasSecurityDomain(" + getSecurityDomain() + ")";
/*     */   }
/*     */ 
/*     */   public ISecurityManagement getSecurityManagement()
/*     */   {
/* 315 */     return this.securityManagement;
/*     */   }
/*     */ 
/*     */   public void setSecurityManagement(ISecurityManagement securityManagement)
/*     */   {
/* 320 */     this.securityManagement = securityManagement;
/*     */   }
/*     */ 
/*     */   public byte[] encode(byte[] secret)
/*     */     throws Exception
/*     */   {
/* 330 */     SecurityManager sm = System.getSecurityManager();
/* 331 */     if (sm != null)
/*     */     {
/* 333 */       System.out.println("Checking: " + encodePermission);
/* 334 */       sm.checkPermission(encodePermission);
/*     */     }
/*     */ 
/* 337 */     Cipher cipher = Cipher.getInstance(this.cipherAlgorithm);
/* 338 */     cipher.init(1, this.cipherKey, this.cipherSpec);
/* 339 */     byte[] encoding = cipher.doFinal(secret);
/* 340 */     return encoding;
/*     */   }
/*     */ 
/*     */   public byte[] decode(byte[] secret)
/*     */     throws Exception
/*     */   {
/* 351 */     SecurityManager sm = System.getSecurityManager();
/* 352 */     if (sm != null) {
/* 353 */       sm.checkPermission(decodePermission);
/*     */     }
/* 355 */     Cipher cipher = Cipher.getInstance(this.cipherAlgorithm);
/* 356 */     cipher.init(2, this.cipherKey, this.cipherSpec);
/* 357 */     byte[] decode = cipher.doFinal(secret);
/* 358 */     return decode;
/*     */   }
/*     */ 
/*     */   public String encode64(byte[] secret)
/*     */     throws Exception
/*     */   {
/* 368 */     byte[] encoding = encode(secret);
/* 369 */     String b64 = CryptoUtil.tob64(encoding);
/* 370 */     return b64;
/*     */   }
/*     */ 
/*     */   public byte[] decode64(String secret)
/*     */     throws Exception
/*     */   {
/* 381 */     byte[] encoding = CryptoUtil.fromb64(secret);
/* 382 */     byte[] decode = decode(encoding);
/* 383 */     return decode;
/*     */   }
/*     */ 
/*     */   public void reloadKeyAndTrustStore()
/*     */     throws Exception
/*     */   {
/* 391 */     loadKeyAndTrustStore();
/*     */   }
/*     */ 
/*     */   protected void startService()
/*     */     throws Exception
/*     */   {
/* 397 */     loadPBESecretKey();
/*     */ 
/* 400 */     loadKeyAndTrustStore();
/*     */ 
/* 403 */     if (this.managerServiceName != null)
/*     */     {
/* 409 */       MBeanServer server = MBeanServerLocator.locateJBoss();
/* 410 */       Object[] params = { getSecurityDomain(), this };
/*     */ 
/* 412 */       String[] signature = { "java.lang.String", "org.jboss.security.SecurityDomain" };
/*     */ 
/* 414 */       server.invoke(this.managerServiceName, "registerSecurityDomain", params, signature);
/*     */     }
/*     */ 
/* 417 */     if ((this.securityManagement instanceof JNDIBasedSecurityManagement))
/*     */     {
/* 419 */       JNDIBasedSecurityManagement jbs = (JNDIBasedSecurityManagement)this.securityManagement;
/* 420 */       jbs.registerJaasSecurityDomainInstance(getSecurityDomain(), this);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void stopService()
/*     */   {
/* 426 */     if (this.keyStorePassword != null)
/*     */     {
/* 428 */       Arrays.fill(this.keyStorePassword, '\000');
/* 429 */       this.keyStorePassword = null;
/*     */     }
/* 431 */     this.cipherKey = null;
/*     */   }
/*     */ 
/*     */   private void loadPBESecretKey()
/*     */     throws Exception
/*     */   {
/* 444 */     this.cipherSpec = new PBEParameterSpec(this.salt, this.iterationCount);
/* 445 */     PBEKeySpec keySpec = new PBEKeySpec(this.keyStorePassword);
/* 446 */     SecretKeyFactory factory = SecretKeyFactory.getInstance("PBEwithMD5andDES");
/* 447 */     this.cipherKey = factory.generateSecret(keySpec);
/*     */   }
/*     */ 
/*     */   private void loadKeyAndTrustStore() throws Exception
/*     */   {
/* 452 */     if (this.keyStoreURL != null)
/*     */     {
/* 454 */       this.keyStore = KeyStore.getInstance(this.keyStoreType);
/* 455 */       InputStream is = this.keyStoreURL.openStream();
/* 456 */       this.keyStore.load(is, this.keyStorePassword);
/* 457 */       String algorithm = KeyManagerFactory.getDefaultAlgorithm();
/* 458 */       this.keyMgr = KeyManagerFactory.getInstance(algorithm);
/* 459 */       this.keyMgr.init(this.keyStore, this.keyStorePassword);
/*     */     }
/* 461 */     if (this.trustStoreURL != null)
/*     */     {
/* 463 */       this.trustStore = KeyStore.getInstance(this.trustStoreType);
/* 464 */       InputStream is = this.trustStoreURL.openStream();
/* 465 */       this.trustStore.load(is, this.trustStorePassword);
/* 466 */       String algorithm = TrustManagerFactory.getDefaultAlgorithm();
/* 467 */       this.trustMgr = TrustManagerFactory.getInstance(algorithm);
/* 468 */       this.trustMgr.init(this.trustStore);
/*     */     }
/* 470 */     else if (this.keyStore != null)
/*     */     {
/* 472 */       this.trustStore = this.keyStore;
/* 473 */       String algorithm = TrustManagerFactory.getDefaultAlgorithm();
/* 474 */       this.trustMgr = TrustManagerFactory.getInstance(algorithm);
/* 475 */       this.trustMgr.init(this.trustStore);
/*     */     }
/*     */   }
/*     */ 
/*     */   private char[] loadPassword(String passwordString)
/*     */     throws Exception
/*     */   {
/* 491 */     char[] password = null;
/* 492 */     String commandType = null;
/* 493 */     String command = null;
/*     */ 
/* 495 */     if (passwordString.charAt(0) != '{')
/*     */     {
/* 498 */       password = passwordString.toCharArray();
/*     */     }
/*     */     else
/*     */     {
/* 503 */       StringTokenizer tokenizer = new StringTokenizer(passwordString, "{}");
/* 504 */       commandType = tokenizer.nextToken();
/* 505 */       command = tokenizer.nextToken();
/* 506 */       if (commandType.equals("EXT"))
/* 507 */         password = execPasswordCmd(command);
/* 508 */       else if (commandType.equals("CLASS"))
/* 509 */         password = invokePasswordClass(command);
/*     */       else {
/* 511 */         throw new IllegalArgumentException("Unknown keyStorePasswordCmdType: " + commandType);
/*     */       }
/*     */     }
/* 514 */     return password;
/*     */   }
/*     */ 
/*     */   private char[] execPasswordCmd(String command)
/*     */     throws Exception
/*     */   {
/* 529 */     this.log.debug("Executing command: " + command);
/* 530 */     Runtime rt = Runtime.getRuntime();
/* 531 */     Process p = rt.exec(command);
/* 532 */     InputStream stdin = p.getInputStream();
/* 533 */     BufferedReader reader = new BufferedReader(new InputStreamReader(stdin));
/* 534 */     String password = reader.readLine();
/* 535 */     stdin.close();
/* 536 */     int exitCode = p.waitFor();
/* 537 */     this.log.debug("Command exited with: " + exitCode);
/* 538 */     return password.toCharArray();
/*     */   }
/*     */ 
/*     */   private char[] invokePasswordClass(String classdef)
/*     */     throws Exception
/*     */   {
/* 558 */     this.keyStorePassword = null;
/*     */ 
/* 561 */     String classname = classdef;
/* 562 */     String ctorArg = null;
/* 563 */     int colon = classdef.indexOf(':');
/* 564 */     if (colon > 0)
/*     */     {
/* 566 */       classname = classdef.substring(0, colon);
/* 567 */       ctorArg = classdef.substring(colon + 1);
/*     */     }
/* 569 */     this.log.debug("Loading class: " + classname + ", ctorArg=" + ctorArg);
/* 570 */     ClassLoader loader = SubjectActions.getContextClassLoader();
/* 571 */     Class c = loader.loadClass(classname);
/* 572 */     Object instance = null;
/*     */ 
/* 574 */     if (ctorArg != null)
/*     */     {
/* 576 */       Class[] sig = { String.class };
/* 577 */       Constructor ctor = c.getConstructor(sig);
/* 578 */       Object[] args = { ctorArg };
/* 579 */       instance = ctor.newInstance(args);
/*     */     }
/*     */     else
/*     */     {
/* 584 */       instance = c.newInstance();
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 590 */       this.log.debug("Checking for toCharArray");
/* 591 */       Class[] sig = new Class[0];
/* 592 */       Method toCharArray = c.getMethod("toCharArray", sig);
/* 593 */       Object[] args = new Object[0];
/* 594 */       this.log.debug("Invoking toCharArray");
/* 595 */       return (char[])(char[])toCharArray.invoke(instance, args);
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/* 599 */       this.log.debug("No toCharArray found, invoking toString");
/* 600 */       String tmp = instance.toString();
/* 601 */       if (tmp != null)
/* 602 */         return tmp.toCharArray();
/*     */     }
/* 604 */     return null;
/*     */   }
/*     */ 
/*     */   private URL validateStoreURL(String storeURL) throws IOException
/*     */   {
/* 609 */     URL url = null;
/*     */     try
/*     */     {
/* 613 */       url = new URL(storeURL);
/*     */     }
/*     */     catch (MalformedURLException e)
/*     */     {
/*     */     }
/*     */ 
/* 621 */     if (url == null)
/*     */     {
/* 623 */       File tst = new File(storeURL);
/* 624 */       if (tst.exists() == true) {
/* 625 */         url = tst.toURL();
/*     */       }
/*     */     }
/*     */ 
/* 629 */     if (url == null)
/*     */     {
/* 631 */       ClassLoader loader = SubjectActions.getContextClassLoader();
/* 632 */       url = loader.getResource(storeURL);
/*     */     }
/*     */ 
/* 636 */     if (url == null)
/*     */     {
/* 638 */       String msg = "Failed to find url=" + storeURL + " as a URL, file or resource";
/* 639 */       throw new MalformedURLException(msg);
/*     */     }
/* 641 */     return url;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.plugins.JaasSecurityDomain
 * JD-Core Version:    0.6.0
 */