/*     */ package org.jboss.security.plugins;
/*     */ 
/*     */ import java.beans.PropertyEditorManager;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.InvocationHandler;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Proxy;
/*     */ import java.security.Principal;
/*     */ import java.util.Enumeration;
/*     */ import java.util.Hashtable;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import javax.naming.CommunicationException;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.Name;
/*     */ import javax.naming.NameClassPair;
/*     */ import javax.naming.NameParser;
/*     */ import javax.naming.NamingEnumeration;
/*     */ import javax.naming.NamingException;
/*     */ import javax.naming.OperationNotSupportedException;
/*     */ import javax.naming.RefAddr;
/*     */ import javax.naming.Reference;
/*     */ import javax.naming.StringRefAddr;
/*     */ import javax.naming.spi.ObjectFactory;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.auth.callback.CallbackHandler;
/*     */ import javax.security.jacc.PolicyContext;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.AuthenticationManager;
/*     */ import org.jboss.security.AuthorizationManager;
/*     */ import org.jboss.security.RealmMapping;
/*     */ import org.jboss.security.SecurityAssociation;
/*     */ import org.jboss.security.SecurityDomain;
/*     */ import org.jboss.security.SecurityProxyFactory;
/*     */ import org.jboss.security.SubjectSecurityProxyFactory;
/*     */ import org.jboss.security.auth.callback.CallbackHandlerPolicyContextHandler;
/*     */ import org.jboss.security.auth.callback.SecurityAssociationHandler;
/*     */ import org.jboss.security.config.SecurityConfiguration;
/*     */ import org.jboss.security.integration.JNDIBasedSecurityManagement;
/*     */ import org.jboss.security.jacc.SubjectPolicyContextHandler;
/*     */ import org.jboss.security.propertyeditor.PrincipalEditor;
/*     */ import org.jboss.security.propertyeditor.SecurityDomainEditor;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ import org.jboss.util.CachePolicy;
/*     */ import org.jboss.util.TimedCachePolicy;
/*     */ 
/*     */ public class JaasSecurityManagerService extends ServiceMBeanSupport
/*     */   implements JaasSecurityManagerServiceMBean
/*     */ {
/*     */   private static final String SECURITY_MGR_PATH = "java:/jaas";
/*     */   private static final String DEFAULT_CACHE_POLICY_PATH = "java:/timedCacheFactory";
/*     */   private static Logger log;
/*  97 */   private static String securityMgrClassName = "org.jboss.security.plugins.JaasSecurityManager";
/*     */ 
/*  99 */   private static Class securityMgrClass = JaasSecurityManager.class;
/*     */ 
/* 101 */   private static String callbackHandlerClassName = "org.jboss.security.auth.callback.SecurityAssociationHandler";
/* 102 */   private static Class callbackHandlerClass = SecurityAssociationHandler.class;
/*     */ 
/* 110 */   private static String cacheJndiName = "java:/timedCacheFactory";
/* 111 */   private static int defaultCacheTimeout = 1800;
/* 112 */   private static int defaultCacheResolution = 60;
/*     */ 
/* 114 */   private static String securityProxyFactoryClassName = "org.jboss.security.SubjectSecurityProxyFactory";
/* 115 */   private static Class securityProxyFactoryClass = SubjectSecurityProxyFactory.class;
/*     */ 
/* 117 */   private static ConcurrentHashMap securityDomainCtxMap = new ConcurrentHashMap();
/*     */   private static NameParser parser;
/* 120 */   private boolean serverMode = true;
/*     */ 
/* 122 */   private static boolean deepCopySubjectMode = false;
/*     */ 
/* 125 */   private static String defaultUnauthenticatedPrincipal = "Unauthenticated Principal";
/*     */ 
/*     */   public boolean getServerMode()
/*     */   {
/* 145 */     return this.serverMode;
/*     */   }
/*     */ 
/*     */   public void setServerMode(boolean mode) {
/* 149 */     this.serverMode = mode;
/*     */   }
/*     */ 
/*     */   public String getSecurityManagerClassName()
/*     */   {
/* 154 */     return securityMgrClassName;
/*     */   }
/*     */ 
/*     */   public void setSecurityManagerClassName(String className) throws ClassNotFoundException, ClassCastException
/*     */   {
/* 159 */     securityMgrClassName = className;
/* 160 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 161 */     securityMgrClass = loader.loadClass(securityMgrClassName);
/* 162 */     if (!AuthenticationManager.class.isAssignableFrom(securityMgrClass))
/* 163 */       throw new ClassCastException(securityMgrClass + " does not implement " + AuthenticationManager.class);
/*     */   }
/*     */ 
/*     */   public String getSecurityProxyFactoryClassName() {
/* 167 */     return securityProxyFactoryClassName;
/*     */   }
/*     */ 
/*     */   public void setSecurityProxyFactoryClassName(String className) throws ClassNotFoundException
/*     */   {
/* 172 */     securityProxyFactoryClassName = className;
/* 173 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 174 */     securityProxyFactoryClass = loader.loadClass(securityProxyFactoryClassName);
/*     */   }
/*     */ 
/*     */   public String getCallbackHandlerClassName()
/*     */   {
/* 183 */     return callbackHandlerClassName;
/*     */   }
/*     */ 
/*     */   public void setCallbackHandlerClassName(String className)
/*     */     throws ClassNotFoundException
/*     */   {
/* 191 */     callbackHandlerClassName = className;
/* 192 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 193 */     callbackHandlerClass = loader.loadClass(callbackHandlerClassName);
/*     */   }
/*     */ 
/*     */   public String getAuthenticationCacheJndiName()
/*     */   {
/* 200 */     return cacheJndiName;
/*     */   }
/*     */ 
/*     */   public void setAuthenticationCacheJndiName(String jndiName)
/*     */   {
/* 206 */     cacheJndiName = jndiName;
/*     */   }
/*     */ 
/*     */   public int getDefaultCacheTimeout()
/*     */   {
/* 213 */     return defaultCacheTimeout;
/*     */   }
/*     */ 
/*     */   public void setDefaultCacheTimeout(int timeoutInSecs)
/*     */   {
/* 221 */     defaultCacheTimeout = timeoutInSecs;
/* 222 */     org.jboss.security.integration.SecurityConstantsBridge.defaultCacheTimeout = timeoutInSecs;
/*     */   }
/*     */ 
/*     */   public int getDefaultCacheResolution()
/*     */   {
/* 228 */     return defaultCacheResolution;
/*     */   }
/*     */ 
/*     */   public void setDefaultCacheResolution(int resInSecs)
/*     */   {
/* 236 */     defaultCacheResolution = resInSecs;
/* 237 */     org.jboss.security.integration.SecurityConstantsBridge.defaultCacheResolution = resInSecs;
/*     */   }
/*     */ 
/*     */   public boolean getDeepCopySubjectMode()
/*     */   {
/* 245 */     return deepCopySubjectMode;
/*     */   }
/*     */ 
/*     */   public void setDeepCopySubjectMode(boolean flag)
/*     */   {
/* 253 */     log.debug("setDeepCopySubjectMode=" + flag);
/* 254 */     deepCopySubjectMode = flag;
/*     */ 
/* 256 */     if (!securityDomainCtxMap.isEmpty())
/*     */     {
/* 258 */       Iterator iter = securityDomainCtxMap.keySet().iterator();
/* 259 */       while (iter.hasNext())
/*     */       {
/* 261 */         String securityDomainName = (String)iter.next();
/* 262 */         SecurityDomainContext sdc = (SecurityDomainContext)securityDomainCtxMap.get(securityDomainName);
/* 263 */         setDeepCopySubjectOption(sdc.securityMgr, flag);
/*     */       }
/*     */     }
/* 266 */     SecurityConfiguration.setDeepCopySubjectMode(flag);
/*     */   }
/*     */ 
/*     */   public void setCacheTimeout(String securityDomain, int timeoutInSecs, int resInSecs)
/*     */   {
/* 279 */     CachePolicy cache = getCachePolicy(securityDomain);
/* 280 */     if ((cache != null) && ((cache instanceof TimedCachePolicy)))
/*     */     {
/* 282 */       TimedCachePolicy tcp = (TimedCachePolicy)cache;
/* 283 */       synchronized (tcp)
/*     */       {
/* 285 */         tcp.setDefaultLifetime(timeoutInSecs);
/* 286 */         tcp.setResolution(resInSecs);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 291 */       log.warn("Failed to find cache policy for securityDomain='" + securityDomain + "'");
/*     */     }
/*     */ 
/* 296 */     JNDIBasedSecurityManagement.setCacheTimeout(securityDomain, timeoutInSecs, resInSecs);
/*     */   }
/*     */ 
/*     */   public void flushAuthenticationCache(String securityDomain)
/*     */   {
/* 304 */     CachePolicy cache = getCachePolicy(securityDomain);
/* 305 */     if (cache != null)
/*     */     {
/* 307 */       cache.flush();
/*     */     }
/*     */     else
/*     */     {
/* 311 */       log.warn("Failed to find cache policy for securityDomain='" + securityDomain + "'");
/*     */     }
/*     */   }
/*     */ 
/*     */   public void flushAuthenticationCache(String securityDomain, Principal user)
/*     */   {
/* 324 */     CachePolicy cache = getCachePolicy(securityDomain);
/* 325 */     if (cache != null)
/*     */     {
/* 327 */       cache.remove(user);
/*     */     }
/*     */     else
/*     */     {
/* 331 */       log.warn("Failed to find cache policy for securityDomain='" + securityDomain + "'");
/*     */     }
/*     */   }
/*     */ 
/*     */   public List getAuthenticationCachePrincipals(String securityDomain)
/*     */   {
/* 343 */     CachePolicy cache = getCachePolicy(securityDomain);
/* 344 */     List validPrincipals = null;
/* 345 */     if ((cache instanceof TimedCachePolicy))
/*     */     {
/* 347 */       TimedCachePolicy tcache = (TimedCachePolicy)cache;
/* 348 */       validPrincipals = tcache.getValidKeys();
/*     */     }
/* 350 */     return validPrincipals;
/*     */   }
/*     */ 
/*     */   public boolean isValid(String securityDomain, Principal principal, Object credential)
/*     */   {
/* 356 */     boolean isValid = false;
/*     */     try
/*     */     {
/* 359 */       SecurityDomainContext sdc = lookupSecurityDomain(securityDomain);
/* 360 */       isValid = sdc.getSecurityManager().isValid(principal, credential, null);
/*     */     }
/*     */     catch (NamingException e)
/*     */     {
/* 364 */       log.debug("isValid(" + securityDomain + ") failed", e);
/*     */     }
/* 366 */     return isValid;
/*     */   }
/*     */ 
/*     */   public Principal getPrincipal(String securityDomain, Principal principal)
/*     */   {
/* 371 */     Principal realmPrincipal = null;
/*     */     try
/*     */     {
/* 374 */       SecurityDomainContext sdc = lookupSecurityDomain(securityDomain);
/* 375 */       realmPrincipal = sdc.getRealmMapping().getPrincipal(principal);
/*     */     }
/*     */     catch (NamingException e)
/*     */     {
/* 379 */       log.debug("getPrincipal(" + securityDomain + ") failed", e);
/*     */     }
/* 381 */     return realmPrincipal;
/*     */   }
/*     */ 
/*     */   public boolean doesUserHaveRole(String securityDomain, Principal principal, Object credential, Set roles)
/*     */   {
/* 387 */     boolean doesUserHaveRole = false;
/*     */     try
/*     */     {
/* 390 */       SecurityDomainContext sdc = lookupSecurityDomain(securityDomain);
/*     */ 
/* 392 */       Subject subject = new Subject();
/* 393 */       boolean isValid = sdc.getSecurityManager().isValid(principal, credential, subject);
/* 394 */       if (isValid)
/*     */       {
/* 397 */         SubjectActions.pushSubjectContext(principal, credential, subject, sdc.getSecurityManager().getSecurityDomain());
/*     */ 
/* 399 */         doesUserHaveRole = sdc.getRealmMapping().doesUserHaveRole(principal, roles);
/* 400 */         SubjectActions.popSubjectContext();
/*     */       }
/*     */     }
/*     */     catch (NamingException e)
/*     */     {
/* 405 */       log.debug("doesUserHaveRole(" + securityDomain + ") failed", e);
/*     */     }
/* 407 */     return doesUserHaveRole;
/*     */   }
/*     */ 
/*     */   public Set getUserRoles(String securityDomain, Principal principal, Object credential)
/*     */   {
/* 412 */     Set userRoles = null;
/*     */     try
/*     */     {
/* 415 */       SecurityDomainContext sdc = lookupSecurityDomain(securityDomain);
/*     */ 
/* 417 */       Subject subject = new Subject();
/* 418 */       boolean isValid = sdc.getSecurityManager().isValid(principal, credential, subject);
/*     */ 
/* 420 */       if (isValid)
/*     */       {
/* 422 */         SubjectActions.pushSubjectContext(principal, credential, subject, sdc.getSecurityManager().getSecurityDomain());
/*     */ 
/* 424 */         userRoles = sdc.getRealmMapping().getUserRoles(principal);
/* 425 */         SubjectActions.popSubjectContext();
/*     */       }
/*     */     }
/*     */     catch (NamingException e)
/*     */     {
/* 430 */       log.debug("getUserRoles(" + securityDomain + ") failed", e);
/*     */     }
/* 432 */     return userRoles;
/*     */   }
/*     */ 
/*     */   protected void startService()
/*     */     throws Exception
/*     */   {
/* 439 */     if (this.serverMode) {
/* 440 */       SecurityAssociation.setServer();
/*     */     }
/*     */ 
/* 443 */     SubjectPolicyContextHandler handler = new SubjectPolicyContextHandler();
/* 444 */     PolicyContext.registerHandler("javax.security.auth.Subject.container", handler, true);
/*     */ 
/* 447 */     CallbackHandlerPolicyContextHandler chandler = new CallbackHandlerPolicyContextHandler();
/* 448 */     PolicyContext.registerHandler("org.jboss.security.auth.spi.CallbackHandler", chandler, false);
/*     */ 
/* 451 */     Context ctx = new InitialContext();
/* 452 */     parser = ctx.getNameParser("");
/*     */ 
/* 458 */     RefAddr refAddr = new StringRefAddr("nns", "JSM");
/* 459 */     String factoryName = SecurityDomainObjectFactory.class.getName();
/* 460 */     Reference ref = new Reference("javax.naming.Context", refAddr, factoryName, null);
/*     */ 
/* 463 */     log.debug("securityMgrCtxPath=java:/jaas");
/*     */ 
/* 465 */     refAddr = new StringRefAddr("nns", "JSMCachePolicy");
/* 466 */     factoryName = DefaultCacheObjectFactory.class.getName();
/* 467 */     ref = new Reference("javax.naming.Context", refAddr, factoryName, null);
/* 468 */     ctx.rebind("java:/timedCacheFactory", ref);
/* 469 */     log.debug("cachePolicyCtxPath=" + cacheJndiName);
/*     */ 
/* 472 */     SecurityProxyFactory proxyFactory = (SecurityProxyFactory)securityProxyFactoryClass.newInstance();
/* 473 */     ctx.bind("java:/SecurityProxyFactory", proxyFactory);
/* 474 */     log.debug("SecurityProxyFactory=" + proxyFactory);
/*     */ 
/* 477 */     PropertyEditorManager.registerEditor(Principal.class, PrincipalEditor.class);
/* 478 */     PropertyEditorManager.registerEditor(SecurityDomain.class, SecurityDomainEditor.class);
/* 479 */     log.debug("Registered PrincipalEditor, SecurityDomainEditor");
/*     */ 
/* 481 */     log.debug("ServerMode=" + this.serverMode);
/* 482 */     log.debug("SecurityMgrClass=" + securityMgrClass);
/* 483 */     log.debug("CallbackHandlerClass=" + callbackHandlerClass);
/*     */   }
/*     */ 
/*     */   protected void stopService() throws Exception
/*     */   {
/* 488 */     InitialContext ic = new InitialContext();
/*     */     try
/*     */     {
/* 492 */       ic.unbind("java:/jaas");
/*     */     }
/*     */     catch (CommunicationException e)
/*     */     {
/*     */     }
/*     */     finally
/*     */     {
/* 500 */       ic.close();
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void registerSecurityDomain(String securityDomain, SecurityDomain instance)
/*     */   {
/* 511 */     log.debug("Added " + securityDomain + ", " + instance + " to map");
/* 512 */     CachePolicy authCache = lookupCachePolicy(securityDomain);
/*     */ 
/* 514 */     SecurityDomainContext sdc = new SecurityDomainContext(instance, authCache);
/* 515 */     sdc.setAuthorizationManager(AuthorizationManagerService.newAuthorizationManager(securityDomain));
/* 516 */     securityDomainCtxMap.put(securityDomain, sdc);
/*     */ 
/* 518 */     setSecurityDomainCache(instance, authCache);
/*     */   }
/*     */ 
/*     */   private static CachePolicy getCachePolicy(String securityDomain)
/*     */   {
/* 527 */     if (securityDomain.startsWith("java:/jaas"))
/* 528 */       securityDomain = securityDomain.substring("java:/jaas".length() + 1);
/* 529 */     CachePolicy cache = null;
/*     */     try
/*     */     {
/* 532 */       SecurityDomainContext sdc = lookupSecurityDomain(securityDomain);
/* 533 */       if (sdc != null)
/* 534 */         cache = sdc.getAuthenticationCache();
/*     */     }
/*     */     catch (NamingException e)
/*     */     {
/* 538 */       log.debug("getCachePolicy(" + securityDomain + ") failure", e);
/*     */     }
/* 540 */     return cache;
/*     */   }
/*     */ 
/*     */   static CachePolicy lookupCachePolicy(String securityDomain)
/*     */   {
/* 552 */     CachePolicy authCache = null;
/* 553 */     String domainCachePath = cacheJndiName + '/' + securityDomain;
/*     */     try
/*     */     {
/* 556 */       InitialContext iniCtx = new InitialContext();
/* 557 */       authCache = (CachePolicy)iniCtx.lookup(domainCachePath);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */       try
/*     */       {
/* 564 */         InitialContext iniCtx = new InitialContext();
/* 565 */         authCache = (CachePolicy)iniCtx.lookup(cacheJndiName);
/*     */       }
/*     */       catch (Exception e2)
/*     */       {
/* 569 */         log.warn("Failed to locate auth CachePolicy at: " + cacheJndiName + " for securityDomain=" + securityDomain);
/*     */       }
/*     */     }
/*     */ 
/* 573 */     return authCache;
/*     */   }
/*     */ 
/*     */   private static void setSecurityDomainCache(AuthenticationManager securityMgr, CachePolicy cachePolicy)
/*     */   {
/*     */     try
/*     */     {
/* 586 */       Class[] setCachePolicyTypes = { CachePolicy.class };
/* 587 */       Method m = securityMgrClass.getMethod("setCachePolicy", setCachePolicyTypes);
/* 588 */       Object[] setCachePolicyArgs = { cachePolicy };
/* 589 */       m.invoke(securityMgr, setCachePolicyArgs);
/* 590 */       log.debug("setCachePolicy, c=" + setCachePolicyArgs[0]);
/*     */     }
/*     */     catch (Exception e2)
/*     */     {
/* 594 */       if (log.isTraceEnabled())
/* 595 */         log.trace("Optional setCachePolicy failed" + e2.getLocalizedMessage());
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void setDeepCopySubjectOption(AuthenticationManager securityMgr, boolean flag)
/*     */   {
/* 607 */     Boolean bValue = flag ? Boolean.TRUE : Boolean.FALSE;
/*     */     try
/*     */     {
/* 610 */       Class[] setDeepCopySubjTypes = { Boolean.class };
/* 611 */       Method m = securityMgrClass.getMethod("setDeepCopySubjectOption", setDeepCopySubjTypes);
/* 612 */       Object[] setDeepCopySubjectOptionArgs = { bValue };
/* 613 */       m.invoke(securityMgr, setDeepCopySubjectOptionArgs);
/* 614 */       log.debug("setDeepCopySubjectOption, c=" + setDeepCopySubjectOptionArgs[0]);
/*     */     }
/*     */     catch (Exception e2)
/*     */     {
/* 618 */       log.debug("setDeepCopySubjectOption failed", e2);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static synchronized SecurityDomainContext lookupSecurityDomain(String securityDomain)
/*     */     throws NamingException
/*     */   {
/* 630 */     SecurityDomainContext securityDomainCtx = (SecurityDomainContext)securityDomainCtxMap.get(securityDomain);
/* 631 */     if (securityDomainCtx == null)
/*     */     {
/* 633 */       securityDomainCtx = newSecurityDomainCtx(securityDomain);
/* 634 */       securityDomainCtxMap.put(securityDomain, securityDomainCtx);
/* 635 */       log.debug("Added " + securityDomain + ", " + securityDomainCtx + " to map");
/*     */     }
/* 637 */     return securityDomainCtx;
/*     */   }
/*     */ 
/*     */   private static synchronized SecurityDomainContext newSecurityDomainCtx(String securityDomain)
/*     */     throws NamingException
/*     */   {
/* 650 */     SecurityDomainContext sdc = null;
/*     */     try
/*     */     {
/* 654 */       Class[] parameterTypes = { String.class, CallbackHandler.class };
/* 655 */       Constructor ctor = securityMgrClass.getConstructor(parameterTypes);
/* 656 */       CallbackHandler handler = (CallbackHandler)callbackHandlerClass.newInstance();
/* 657 */       Object[] args = { securityDomain, handler };
/* 658 */       AuthenticationManager securityMgr = (AuthenticationManager)ctor.newInstance(args);
/* 659 */       log.debug("Created securityMgr=" + securityMgr);
/* 660 */       CachePolicy cachePolicy = lookupCachePolicy(securityDomain);
/* 661 */       sdc = new SecurityDomainContext(securityMgr, cachePolicy);
/*     */ 
/* 663 */       setSecurityDomainCache(securityMgr, cachePolicy);
/* 664 */       if (deepCopySubjectMode) {
/* 665 */         setDeepCopySubjectOption(securityMgr, true);
/*     */       }
/* 667 */       AuthorizationManager am = AuthorizationManagerService.newAuthorizationManager(securityDomain);
/* 668 */       sdc.setAuthorizationManager(am);
/*     */     }
/*     */     catch (Exception e2)
/*     */     {
/* 672 */       String msg = "Failed to create sec mgr('" + securityDomain + "'), securityMgrClass=" + securityMgrClass + ", callbackHandlerClass=" + callbackHandlerClass;
/*     */ 
/* 675 */       NamingException ne = new NamingException(msg);
/* 676 */       ne.setRootCause(e2);
/* 677 */       throw ne;
/*     */     }
/* 679 */     return sdc;
/*     */   }
/*     */ 
/*     */   public String getDefaultUnauthenticatedPrincipal()
/*     */   {
/* 688 */     return defaultUnauthenticatedPrincipal;
/*     */   }
/*     */ 
/*     */   public void setDefaultUnauthenticatedPrincipal(String principal)
/*     */   {
/* 697 */     defaultUnauthenticatedPrincipal = principal;
/*     */   }
/*     */ 
/*     */   public String displayJCAInformation()
/*     */   {
/* 705 */     String[] sarr = { "Cipher", "Signature", "KeyFactory", "SecretKeyFactory", "AlgorithmParameters", "MessageDigest", "Mac" };
/*     */ 
/* 708 */     StringBuilder sb = new StringBuilder();
/* 709 */     JCASecurityInfo jsi = new JCASecurityInfo();
/* 710 */     sb.append("JCA Providers=").append(jsi.getJCAProviderInfo());
/* 711 */     sb.append("JCA Service/Algorithms=");
/* 712 */     for (String serviceName : sarr)
/*     */     {
/* 714 */       sb.append(jsi.getJCAAlgorithms(serviceName));
/*     */     }
/* 716 */     return sb.toString();
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/* 131 */     log = Logger.getLogger(JaasSecurityManagerService.class);
/*     */   }
/*     */ 
/*     */   public static class DefaultCacheObjectFactory
/*     */     implements InvocationHandler, ObjectFactory
/*     */   {
/*     */     public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment)
/*     */       throws Exception
/*     */     {
/* 819 */       ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 820 */       Class[] interfaces = { Context.class };
/* 821 */       Context ctx = (Context)Proxy.newProxyInstance(loader, interfaces, this);
/* 822 */       return ctx;
/*     */     }
/*     */ 
/*     */     public Object invoke(Object obj, Method method, Object[] args)
/*     */       throws Throwable
/*     */     {
/* 830 */       TimedCachePolicy cachePolicy = new TimedCachePolicy(JaasSecurityManagerService.defaultCacheTimeout, true, JaasSecurityManagerService.defaultCacheResolution);
/*     */ 
/* 832 */       cachePolicy.create();
/* 833 */       cachePolicy.start();
/* 834 */       return cachePolicy;
/*     */     }
/*     */   }
/*     */ 
/*     */   static class DomainEnumeration
/*     */     implements NamingEnumeration
/*     */   {
/*     */     Enumeration domains;
/*     */     Map ctxMap;
/*     */ 
/*     */     DomainEnumeration(Enumeration domains, Map ctxMap)
/*     */     {
/* 779 */       this.domains = domains;
/* 780 */       this.ctxMap = ctxMap;
/*     */     }
/*     */ 
/*     */     public void close()
/*     */     {
/*     */     }
/*     */ 
/*     */     public boolean hasMoreElements() {
/* 788 */       return this.domains.hasMoreElements();
/*     */     }
/*     */ 
/*     */     public boolean hasMore() {
/* 792 */       return this.domains.hasMoreElements();
/*     */     }
/*     */ 
/*     */     public Object next() {
/* 796 */       String name = (String)this.domains.nextElement();
/* 797 */       Object value = this.ctxMap.get(name);
/* 798 */       String className = value.getClass().getName();
/* 799 */       NameClassPair pair = new NameClassPair(name, className);
/* 800 */       return pair;
/*     */     }
/*     */ 
/*     */     public Object nextElement() {
/* 804 */       return this.domains.nextElement();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class SecurityDomainObjectFactory
/*     */     implements InvocationHandler, ObjectFactory
/*     */   {
/*     */     public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment)
/*     */       throws Exception
/*     */     {
/* 734 */       ClassLoader loader = SubjectActions.getContextClassLoader();
/* 735 */       Class[] interfaces = { Context.class };
/* 736 */       Context ctx = (Context)Proxy.newProxyInstance(loader, interfaces, this);
/* 737 */       return ctx;
/*     */     }
/*     */ 
/*     */     public Object invoke(Object obj, Method method, Object[] args)
/*     */       throws Throwable
/*     */     {
/* 747 */       String methodName = method.getName();
/* 748 */       if (methodName.equals("toString") == true)
/* 749 */         return "java:/jaas Context proxy";
/* 750 */       if (methodName.equals("list") == true) {
/* 751 */         return new JaasSecurityManagerService.DomainEnumeration(JaasSecurityManagerService.securityDomainCtxMap.keys(), JaasSecurityManagerService.securityDomainCtxMap);
/*     */       }
/* 753 */       if (!methodName.equals("lookup"))
/* 754 */         throw new OperationNotSupportedException("Only lookup is supported, op=" + method);
/* 755 */       String securityDomain = null;
/* 756 */       Name name = null;
/* 757 */       if ((args[0] instanceof String))
/* 758 */         name = JaasSecurityManagerService.parser.parse((String)args[0]);
/*     */       else
/* 760 */         name = (Name)args[0];
/* 761 */       securityDomain = name.get(0);
/* 762 */       SecurityDomainContext securityDomainCtx = JaasSecurityManagerService.access$200(securityDomain);
/* 763 */       Object binding = securityDomainCtx.getSecurityManager();
/*     */ 
/* 765 */       if (name.size() == 2)
/*     */       {
/* 767 */         String request = name.get(1);
/* 768 */         binding = securityDomainCtx.lookup(request);
/*     */       }
/* 770 */       return binding;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.plugins.JaasSecurityManagerService
 * JD-Core Version:    0.6.0
 */