/*     */ package org.jboss.security.plugins;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.security.AccessController;
/*     */ import java.security.Principal;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.auth.callback.CallbackHandler;
/*     */ import javax.security.auth.login.LoginContext;
/*     */ import javax.security.auth.login.LoginException;
/*     */ import javax.security.jacc.PolicyContext;
/*     */ import javax.security.jacc.PolicyContextException;
/*     */ import org.jboss.security.SecurityAssociation;
/*     */ import org.jboss.security.SecurityContext;
/*     */ import org.jboss.security.SecurityContextFactory;
/*     */ import org.jboss.security.SecurityContextUtil;
/*     */ 
/*     */ class SubjectActions
/*     */ {
/*     */   static Subject getActiveSubject()
/*     */     throws PrivilegedActionException
/*     */   {
/* 289 */     Subject subject = (Subject)AccessController.doPrivileged(GetSubjectAction.ACTION);
/* 290 */     return subject;
/*     */   }
/*     */ 
/*     */   static void copySubject(Subject fromSubject, Subject toSubject) {
/* 294 */     copySubject(fromSubject, toSubject, false);
/*     */   }
/*     */ 
/*     */   static void copySubject(Subject fromSubject, Subject toSubject, boolean setReadOnly) {
/* 298 */     CopySubjectAction action = new CopySubjectAction(fromSubject, toSubject, setReadOnly);
/* 299 */     if (System.getSecurityManager() != null)
/* 300 */       AccessController.doPrivileged(action);
/*     */     else
/* 302 */       action.run();
/*     */   }
/*     */ 
/*     */   static void copySubject(Subject fromSubject, Subject toSubject, boolean setReadOnly, boolean deepCopy)
/*     */   {
/* 308 */     CopySubjectAction action = new CopySubjectAction(fromSubject, toSubject, setReadOnly);
/* 309 */     action.setDeepCopy(deepCopy);
/* 310 */     if (System.getSecurityManager() != null)
/* 311 */       AccessController.doPrivileged(action);
/*     */     else
/* 313 */       action.run();
/*     */   }
/*     */ 
/*     */   static LoginContext createLoginContext(String securityDomain, Subject subject, CallbackHandler handler) throws LoginException {
/* 320 */     LoginContextAction action = new LoginContextAction(securityDomain, subject, handler);
/*     */     Exception ex;
/*     */     try {
/* 323 */       LoginContext lc = (LoginContext)AccessController.doPrivileged(action);
/* 324 */       return lc;
/*     */     }
/*     */     catch (PrivilegedActionException e)
/*     */     {
/* 328 */       ex = e.getException();
/* 329 */       if ((ex instanceof LoginException))
/* 330 */         throw ((LoginException)ex);
/*     */     }
/* 332 */     throw new LoginException(ex.getMessage());
/*     */   }
/*     */ 
/*     */   static ClassLoader getContextClassLoader()
/*     */   {
/* 338 */     ClassLoader loader = (ClassLoader)AccessController.doPrivileged(GetTCLAction.ACTION);
/* 339 */     return loader;
/*     */   }
/*     */ 
/*     */   static Object setContextInfo(Object key, Object value)
/*     */   {
/* 344 */     SetContextInfoAction action = new SetContextInfoAction(key, value);
/* 345 */     Object prevInfo = AccessController.doPrivileged(action);
/* 346 */     return prevInfo;
/*     */   }
/*     */ 
/*     */   static void pushSubjectContext(Principal principal, Object credential, Subject subject, String securityDomain)
/*     */   {
/* 352 */     if (System.getSecurityManager() == null)
/*     */     {
/* 354 */       PrincipalInfoAction.NON_PRIVILEGED.push(principal, credential, subject, securityDomain);
/*     */     }
/*     */     else
/*     */     {
/* 358 */       PrincipalInfoAction.PRIVILEGED.push(principal, credential, subject, securityDomain);
/*     */     }
/*     */   }
/*     */ 
/*     */   static void popSubjectContext() {
/* 363 */     if (System.getSecurityManager() == null)
/*     */     {
/* 365 */       PrincipalInfoAction.NON_PRIVILEGED.pop();
/*     */     }
/*     */     else
/*     */     {
/* 369 */       PrincipalInfoAction.PRIVILEGED.pop();
/*     */     }
/*     */   }
/*     */ 
/*     */   static String toString(Subject subject)
/*     */   {
/* 376 */     ToStringSubjectAction action = new ToStringSubjectAction(subject);
/* 377 */     String info = (String)AccessController.doPrivileged(action);
/* 378 */     return info;
/*     */   }
/*     */ 
/*     */   static SecurityContext getSecurityContext()
/*     */   {
/* 383 */     return (SecurityContext)AccessController.doPrivileged(new PrivilegedAction()
/*     */     {
/*     */       public Object run()
/*     */       {
/* 387 */         return SecurityContextAssociation.getSecurityContext();
/*     */       } } );
/*     */   }
/*     */ 
/*     */   static void setSecurityContext(SecurityContext sc) {
/* 393 */     AccessController.doPrivileged(new PrivilegedAction(sc)
/*     */     {
/*     */       public Object run()
/*     */       {
/* 397 */         SecurityContextAssociation.setSecurityContext(this.val$sc);
/* 398 */         return null;
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   static String getRefreshSecurityContextRoles()
/*     */   {
/* 413 */     return (String)AccessController.doPrivileged(new PrivilegedAction()
/*     */     {
/*     */       public Object run()
/*     */       {
/* 417 */         return System.getProperty("jbosssx.context.roles.refresh", "false");
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   static String getSystemProperty(String key, String defaultValue) {
/* 424 */     return (String)AccessController.doPrivileged(new PrivilegedAction(key, defaultValue)
/*     */     {
/*     */       public Object run()
/*     */       {
/* 428 */         return System.getProperty(this.val$key, this.val$defaultValue);
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   static abstract interface PrincipalInfoAction
/*     */   {
/* 205 */     public static final PrincipalInfoAction PRIVILEGED = new PrincipalInfoAction()
/*     */     {
/*     */       public void push(Principal principal, Object credential, Subject subject, String securityDomain)
/*     */       {
/* 210 */         AccessController.doPrivileged(new PrivilegedAction(principal, credential, subject, securityDomain)
/*     */         {
/*     */           public Object run()
/*     */           {
/* 216 */             SecurityContext sc = SecurityContextAssociation.getSecurityContext();
/* 217 */             if (sc == null)
/*     */             {
/*     */               try
/*     */               {
/* 221 */                 sc = SecurityContextFactory.createSecurityContext(this.val$principal, this.val$credential, this.val$subject, this.val$securityDomain);
/*     */               }
/*     */               catch (Exception e)
/*     */               {
/* 226 */                 throw new RuntimeException(e);
/*     */               }
/*     */             }
/* 229 */             SecurityContextAssociation.setSecurityContext(sc);
/* 230 */             return null;
/*     */           }
/*     */         });
/*     */       }
/*     */ 
/*     */       public void pop() {
/* 237 */         AccessController.doPrivileged(new PrivilegedAction()
/*     */         {
/*     */           public Object run()
/*     */           {
/* 243 */             SecurityContextAssociation.clearSecurityContext();
/* 244 */             return null;
/*     */           }
/*     */         });
/*     */       }
/* 205 */     };
/*     */ 
/* 251 */     public static final PrincipalInfoAction NON_PRIVILEGED = new PrincipalInfoAction()
/*     */     {
/*     */       public void push(Principal principal, Object credential, Subject subject, String securityDomain)
/*     */       {
/* 257 */         SecurityContext sc = SecurityContextAssociation.getSecurityContext();
/* 258 */         if (sc == null)
/*     */         {
/*     */           try
/*     */           {
/* 262 */             sc = SecurityContextFactory.createSecurityContext(principal, credential, subject, securityDomain);
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/* 267 */             throw new RuntimeException(e);
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 272 */           sc.getUtil().createSubjectInfo(principal, credential, subject);
/*     */         }
/* 274 */         SecurityContextAssociation.setSecurityContext(sc);
/*     */       }
/*     */ 
/*     */       public void pop()
/*     */       {
/* 279 */         SecurityContextAssociation.clearSecurityContext();
/*     */       }
/* 251 */     };
/*     */ 
/*     */     public abstract void push(Principal paramPrincipal, Object paramObject, Subject paramSubject, String paramString);
/*     */ 
/*     */     public abstract void pop();
/*     */   }
/*     */ 
/*     */   private static class SetContextInfoAction
/*     */     implements PrivilegedAction
/*     */   {
/*     */     Object key;
/*     */     Object value;
/*     */ 
/*     */     SetContextInfoAction(Object key, Object value)
/*     */     {
/* 188 */       this.key = key;
/* 189 */       this.value = value;
/*     */     }
/*     */ 
/*     */     public Object run()
/*     */     {
/* 194 */       SecurityContext sc = SecurityContextAssociation.getSecurityContext();
/* 195 */       if (sc != null)
/*     */       {
/* 197 */         sc.getData().put(this.key.toString(), this.value);
/*     */       }
/* 199 */       return SecurityAssociation.setContextInfo(this.key, this.value);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class GetTCLAction
/*     */     implements PrivilegedAction
/*     */   {
/* 174 */     static PrivilegedAction ACTION = new GetTCLAction();
/*     */ 
/*     */     public Object run() {
/* 177 */       ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 178 */       return loader;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class LoginContextAction
/*     */     implements PrivilegedExceptionAction
/*     */   {
/*     */     String securityDomain;
/*     */     Subject subject;
/*     */     CallbackHandler handler;
/*     */ 
/*     */     LoginContextAction(String securityDomain, Subject subject, CallbackHandler handler)
/*     */     {
/* 161 */       this.securityDomain = securityDomain;
/* 162 */       this.subject = subject;
/* 163 */       this.handler = handler;
/*     */     }
/*     */ 
/*     */     public Object run() throws Exception {
/* 167 */       LoginContext lc = new LoginContext(this.securityDomain, this.subject, this.handler);
/* 168 */       return lc;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class CopySubjectAction
/*     */     implements PrivilegedAction
/*     */   {
/*     */     Subject fromSubject;
/*     */     Subject toSubject;
/*     */     boolean setReadOnly;
/*     */     boolean deepCopy;
/*     */ 
/*     */     CopySubjectAction(Subject fromSubject, Subject toSubject, boolean setReadOnly)
/*     */     {
/*  99 */       this.fromSubject = fromSubject;
/* 100 */       this.toSubject = toSubject;
/* 101 */       this.setReadOnly = setReadOnly;
/*     */     }
/*     */ 
/*     */     public void setDeepCopy(boolean flag) {
/* 105 */       this.deepCopy = flag;
/*     */     }
/*     */ 
/*     */     public Object run()
/*     */     {
/* 110 */       Set principals = this.fromSubject.getPrincipals();
/* 111 */       Set principals2 = this.toSubject.getPrincipals();
/* 112 */       Iterator iter = principals.iterator();
/* 113 */       while (iter.hasNext())
/* 114 */         principals2.add(getCloneIfNeeded(iter.next()));
/* 115 */       Set privateCreds = this.fromSubject.getPrivateCredentials();
/* 116 */       Set privateCreds2 = this.toSubject.getPrivateCredentials();
/* 117 */       iter = privateCreds.iterator();
/* 118 */       while (iter.hasNext())
/* 119 */         privateCreds2.add(getCloneIfNeeded(iter.next()));
/* 120 */       Set publicCreds = this.fromSubject.getPublicCredentials();
/* 121 */       Set publicCreds2 = this.toSubject.getPublicCredentials();
/* 122 */       iter = publicCreds.iterator();
/* 123 */       while (iter.hasNext())
/* 124 */         publicCreds2.add(getCloneIfNeeded(iter.next()));
/* 125 */       if (this.setReadOnly == true)
/* 126 */         this.toSubject.setReadOnly();
/* 127 */       return null;
/*     */     }
/*     */ 
/*     */     private Object getCloneIfNeeded(Object obj)
/*     */     {
/* 134 */       Object clonedObject = null;
/* 135 */       if ((this.deepCopy) && ((obj instanceof Cloneable)))
/*     */       {
/* 137 */         Class clazz = obj.getClass();
/*     */         try
/*     */         {
/* 140 */           Method cloneMethod = clazz.getMethod("clone", null);
/* 141 */           clonedObject = cloneMethod.invoke(obj, null);
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/*     */         }
/*     */       }
/* 147 */       if (clonedObject == null)
/* 148 */         clonedObject = obj;
/* 149 */       return clonedObject;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class GetSubjectAction
/*     */     implements PrivilegedExceptionAction
/*     */   {
/*  83 */     static PrivilegedExceptionAction ACTION = new GetSubjectAction();
/*     */ 
/*     */     public Object run() throws PolicyContextException {
/*  86 */       return (Subject)PolicyContext.getContext("javax.security.auth.Subject.container");
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class ToStringSubjectAction
/*     */     implements PrivilegedAction
/*     */   {
/*     */     Subject subject;
/*     */ 
/*     */     ToStringSubjectAction(Subject subject)
/*     */     {
/*  57 */       this.subject = subject;
/*     */     }
/*     */ 
/*     */     public Object run() {
/*  61 */       StringBuffer tmp = new StringBuffer();
/*  62 */       tmp.append("Subject(");
/*  63 */       tmp.append(System.identityHashCode(this.subject));
/*  64 */       tmp.append(").principals=");
/*  65 */       Iterator principals = this.subject.getPrincipals().iterator();
/*  66 */       while (principals.hasNext())
/*     */       {
/*  68 */         Object p = principals.next();
/*  69 */         Class c = p.getClass();
/*  70 */         tmp.append(c.getName());
/*  71 */         tmp.append('@');
/*  72 */         tmp.append(System.identityHashCode(c));
/*  73 */         tmp.append('(');
/*  74 */         tmp.append(p);
/*  75 */         tmp.append(')');
/*     */       }
/*  77 */       return tmp.toString();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.plugins.SubjectActions
 * JD-Core Version:    0.6.0
 */