/*     */ package org.jboss.security.ssl;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.Serializable;
/*     */ import java.net.InetAddress;
/*     */ import java.net.Socket;
/*     */ import java.net.UnknownHostException;
/*     */ import java.util.Hashtable;
/*     */ import javax.net.SocketFactory;
/*     */ import javax.net.ssl.HandshakeCompletedEvent;
/*     */ import javax.net.ssl.HandshakeCompletedListener;
/*     */ import javax.net.ssl.SSLSession;
/*     */ import javax.net.ssl.SSLSocket;
/*     */ import javax.net.ssl.SSLSocketFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ClientSocketFactory extends SocketFactory
/*     */   implements HandshakeCompletedListener, Serializable
/*     */ {
/*     */   public static final String HANDSHAKE_COMPLETE_LISTENER = "org.jboss.security.ssl.HandshakeCompletedListener";
/*     */   static final long serialVersionUID = -2762336418317218104L;
/*  51 */   private static Logger log = Logger.getLogger(ClientSocketFactory.class);
/*  52 */   private boolean wantsClientAuth = true;
/*  53 */   private boolean needsClientAuth = false;
/*     */ 
/*     */   public boolean isWantsClientAuth()
/*     */   {
/*  62 */     return this.wantsClientAuth;
/*     */   }
/*     */ 
/*     */   public void setWantsClientAuth(boolean wantsClientAuth) {
/*  66 */     this.wantsClientAuth = wantsClientAuth;
/*     */   }
/*     */ 
/*     */   public boolean isNeedsClientAuth()
/*     */   {
/*  71 */     return this.needsClientAuth;
/*     */   }
/*     */ 
/*     */   public void setNeedsClientAuth(boolean needsClientAuth) {
/*  75 */     this.needsClientAuth = needsClientAuth;
/*     */   }
/*     */ 
/*     */   public Socket createSocket(String serverHost, int serverPort)
/*     */     throws IOException, UnknownHostException
/*     */   {
/*  87 */     InetAddress serverAddr = InetAddress.getByName(serverHost);
/*  88 */     return createSocket(serverAddr, serverPort);
/*     */   }
/*     */ 
/*     */   public Socket createSocket(String serverHost, int serverPort, InetAddress clientAddr, int clientPort)
/*     */     throws IOException, UnknownHostException
/*     */   {
/*  95 */     InetAddress serverAddr = InetAddress.getByName(serverHost);
/*  96 */     return createSocket(serverAddr, serverPort, clientAddr, clientPort);
/*     */   }
/*     */ 
/*     */   public Socket createSocket(InetAddress serverAddr, int serverPort) throws IOException
/*     */   {
/* 101 */     return createSocket(serverAddr, serverPort, null, 0);
/*     */   }
/*     */ 
/*     */   public Socket createSocket(InetAddress serverAddr, int serverPort, InetAddress clientAddr, int clientPort)
/*     */     throws IOException
/*     */   {
/* 107 */     SSLSocketFactory factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
/* 108 */     SSLSocket socket = (SSLSocket)factory.createSocket(serverAddr, serverPort, clientAddr, clientPort);
/* 109 */     socket.addHandshakeCompletedListener(this);
/* 110 */     socket.setNeedClientAuth(this.needsClientAuth);
/* 111 */     socket.setWantClientAuth(this.wantsClientAuth);
/* 112 */     return socket;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 117 */     return obj instanceof ClientSocketFactory;
/*     */   }
/*     */ 
/*     */   public int hashCode() {
/* 121 */     return getClass().getName().hashCode();
/*     */   }
/*     */ 
/*     */   public void handshakeCompleted(HandshakeCompletedEvent event)
/*     */   {
/* 126 */     if (log.isTraceEnabled())
/*     */     {
/* 128 */       String cipher = event.getCipherSuite();
/* 129 */       SSLSession session = event.getSession();
/* 130 */       String peerHost = session.getPeerHost();
/* 131 */       log.debug("SSL handshakeCompleted, cipher=" + cipher + ", peerHost=" + peerHost);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 141 */       Hashtable env = System.getProperties();
/* 142 */       HandshakeCompletedListener listener = (Serializable)env.get("org.jboss.security.ssl.HandshakeCompletedListener");
/*     */ 
/* 144 */       if (listener != null)
/* 145 */         listener.handshakeCompleted(event);
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 149 */       log.debug("Failed to forward handshakeCompleted", e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.ssl.ClientSocketFactory
 * JD-Core Version:    0.6.0
 */