/*     */ package org.jboss.serial.classmetamodel;
/*     */ 
/*     */ import java.io.Externalizable;
/*     */ import java.io.IOException;
/*     */ import java.io.Serializable;
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Proxy;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import org.apache.log4j.Logger;
/*     */ import org.jboss.serial.exception.SerializationException;
/*     */ import org.jboss.serial.references.MethodPersistentReference;
/*     */ import org.jboss.serial.references.PersistentReference;
/*     */ import org.jboss.serial.util.ClassMetaConsts;
/*     */ import org.jboss.serial.util.HashStringUtil;
/*     */ 
/*     */ public class ClassMetaData
/*     */   implements ClassMetaConsts
/*     */ {
/*  50 */   private static final Logger log = Logger.getLogger(ClassMetaData.class);
/*  51 */   private static final boolean isDebug = log.isDebugEnabled();
/*     */ 
/*  53 */   static ConstructorManager[] constructorManagers = { new SunConstructorManager(), new DefaultConstructorManager() };
/*     */ 
/* 143 */   PersistentReference constructor = emptyReference;
/*     */   WeakReference clazz;
/*     */   WeakReference arrayRep;
/*     */   String className;
/*     */   boolean isArray;
/*     */   int arrayDepth;
/*     */   boolean isProxy;
/*     */   boolean isExternalizable;
/*     */   boolean isSerializable;
/*     */   long shaHash;
/* 162 */   PersistentReference readResolveMethod = emptyReference;
/* 163 */   PersistentReference writeReplaceMethod = emptyReference;
/*     */   ClassMetaDataSlot[] slots;
/*     */ 
/*     */   private Method lookupMethodOnHierarchy(Class clazz, String methodName, Class[] reflectionArguments)
/*     */   {
/*  86 */     if (isDebug)
/*     */     {
/*  88 */       if (clazz.isPrimitive())
/*     */       {
/*  90 */         log.debug("lookupMethodOnHierarchy::Loookup made on a primitive class");
/*     */       }
/*  92 */       log.debug("lookupMethodOnHierarchy::class=" + clazz.getName() + " looking for " + methodName);
/*     */     }
/*  94 */     Class currentClass = clazz;
/*  95 */     while ((currentClass != Object.class) && (currentClass != null))
/*     */     {
/*  97 */       if (isDebug)
/*     */       {
/*  99 */         log.debug("lookupMethodOnHierarchy::currentClass=" + currentClass);
/*     */       }
/*     */       try {
/* 102 */         Method method = currentClass.getDeclaredMethod(methodName, reflectionArguments);
/* 103 */         if (method.getReturnType() == Object.class)
/*     */         {
/* 105 */           return method;
/*     */         }
/*     */       }
/*     */       catch (Exception ignored) {
/*     */       }
/* 110 */       currentClass = currentClass.getSuperclass();
/*     */     }
/*     */ 
/* 113 */     return null;
/*     */   }
/*     */ 
/*     */   public ClassMetaData(Class clazz)
/*     */   {
/* 118 */     setClassName(clazz.getName());
/* 119 */     setClazz(clazz);
/* 120 */     setShaHash(HashStringUtil.hashName(clazz.getName()));
/* 121 */     setProxy(Proxy.isProxyClass(clazz));
/* 122 */     lookupInternalMethods(clazz);
/*     */     try
/*     */     {
/* 128 */       setConstructor(findConstructor(clazz));
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/* 132 */       setConstructor(null);
/*     */     }
/*     */ 
/* 135 */     setExternalizable(Externalizable.class.isAssignableFrom(clazz));
/* 136 */     setSerializable(Serializable.class.isAssignableFrom(clazz));
/*     */ 
/* 138 */     exploreSlots(clazz);
/*     */   }
/*     */ 
/*     */   public ClassMetaDataSlot[] getSlots()
/*     */   {
/* 169 */     return this.slots;
/*     */   }
/*     */ 
/*     */   public String getClassName()
/*     */   {
/* 177 */     return this.className;
/*     */   }
/*     */ 
/*     */   public void setClassName(String className)
/*     */   {
/* 186 */     this.className = className;
/*     */   }
/*     */ 
/*     */   private void calculateDepthAndName(Class clazz)
/*     */   {
/* 191 */     this.arrayDepth = 0;
/* 192 */     while (clazz.isArray())
/*     */     {
/* 194 */       this.arrayDepth += 1;
/* 195 */       clazz = clazz.getComponentType();
/*     */     }
/* 197 */     this.clazz = new WeakReference(clazz);
/*     */   }
/*     */ 
/*     */   public Class getClazz()
/*     */   {
/* 205 */     if (this.clazz == null) return null;
/*     */ 
/* 207 */     return (Class)this.clazz.get();
/*     */   }
/*     */ 
/*     */   public Class getArrayRepresentation()
/*     */   {
/* 212 */     if (this.arrayRep == null) return null;
/*     */ 
/* 214 */     return (Class)this.arrayRep.get();
/*     */   }
/*     */ 
/*     */   private void constructArrayRepresentationClass(Class clazz)
/*     */   {
/* 219 */     this.arrayRep = new WeakReference(clazz);
/*     */   }
/*     */ 
/*     */   public void setClazz(Class clazz)
/*     */   {
/* 228 */     if (clazz == null)
/*     */     {
/* 230 */       this.clazz = null;
/*     */     }
/*     */     else
/*     */     {
/* 234 */       this.clazz = new WeakReference(clazz);
/* 235 */       if (clazz.isArray())
/*     */       {
/* 237 */         setArray(true);
/* 238 */         calculateDepthAndName(clazz);
/* 239 */         constructArrayRepresentationClass(clazz);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public Constructor getConstructor()
/*     */   {
/* 250 */     return (Constructor)this.constructor.get();
/*     */   }
/*     */ 
/*     */   public void setConstructor(Constructor constructor)
/*     */   {
/* 259 */     if (constructor != null)
/*     */     {
/* 261 */       constructor.setAccessible(true);
/*     */     }
/* 263 */     this.constructor = new GhostConstructorPersistentReference(getClazz(), constructor);
/*     */   }
/*     */ 
/*     */   public boolean isExternalizable()
/*     */   {
/* 271 */     return this.isExternalizable;
/*     */   }
/*     */ 
/*     */   public void setExternalizable(boolean isExternalizable)
/*     */   {
/* 278 */     this.isExternalizable = isExternalizable;
/*     */   }
/*     */ 
/*     */   public boolean isSerializable() {
/* 282 */     return this.isSerializable;
/*     */   }
/*     */ 
/*     */   public void setSerializable(boolean isSerializable) {
/* 286 */     this.isSerializable = isSerializable;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 291 */     return this.className.hashCode();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 296 */     return this.className.equals(((ClassMetaData)obj).className);
/*     */   }
/*     */ 
/*     */   public boolean isArray()
/*     */   {
/* 305 */     return this.isArray;
/*     */   }
/*     */ 
/*     */   public void setArray(boolean isArray)
/*     */   {
/* 312 */     this.isArray = isArray;
/*     */   }
/*     */ 
/*     */   public int getArrayDepth()
/*     */   {
/* 321 */     return this.arrayDepth;
/*     */   }
/*     */ 
/*     */   public Object newInstance()
/*     */     throws IOException
/*     */   {
/* 329 */     Constructor localConstructor = getConstructor();
/*     */     try
/*     */     {
/* 332 */       if (localConstructor == null)
/*     */       {
/* 334 */         return getClazz().newInstance();
/*     */       }
/*     */ 
/* 337 */       return localConstructor.newInstance(EMPTY_OBJECT_ARRAY);
/*     */     }
/*     */     catch (InstantiationException e)
/*     */     {
/* 342 */       throw new SerializationException("Could not create instance of " + this.className + " - " + e.getMessage(), e);
/*     */     }
/*     */     catch (IllegalAccessException e)
/*     */     {
/* 346 */       throw new SerializationException("Could not create instance of " + this.className + " - " + e.getMessage(), e);
/*     */     }
/*     */     catch (InvocationTargetException e) {
/*     */     }
/* 350 */     throw new SerializationException("Could not create instance of " + this.className + " - " + e.getMessage(), e);
/*     */   }
/*     */ 
/*     */   public Method getReadResolveMethod()
/*     */   {
/* 355 */     return (Method)this.readResolveMethod.get();
/*     */   }
/*     */ 
/*     */   public void setReadResolveMethod(Method readResolveMethod) {
/* 359 */     this.readResolveMethod = new MethodPersistentReference(readResolveMethod, 2);
/*     */   }
/*     */ 
/*     */   public boolean isProxy() {
/* 363 */     return this.isProxy;
/*     */   }
/*     */ 
/*     */   public void setProxy(boolean proxy) {
/* 367 */     this.isProxy = proxy;
/*     */   }
/*     */ 
/*     */   public Method getWriteReplaceMethod() {
/* 371 */     return (Method)this.writeReplaceMethod.get();
/*     */   }
/*     */ 
/*     */   public void setWriteReplaceMethod(Method writeReplaceMethod) {
/* 375 */     this.writeReplaceMethod = new MethodPersistentReference(writeReplaceMethod, 2);
/*     */   }
/*     */ 
/*     */   public long getShaHash() {
/* 379 */     return this.shaHash;
/*     */   }
/*     */ 
/*     */   public void setShaHash(long shaHash) {
/* 383 */     this.shaHash = shaHash;
/*     */   }
/*     */ 
/*     */   private static Constructor findConstructor(Class clazz) throws NoSuchMethodException
/*     */   {
/* 388 */     if (clazz.isInterface())
/*     */     {
/* 390 */       return null;
/*     */     }
/* 392 */     for (int i = 0; i < constructorManagers.length; i++)
/*     */     {
/* 394 */       if (constructorManagers[i].isSupported())
/*     */       {
/* 396 */         return constructorManagers[i].getConstructor(clazz);
/*     */       }
/*     */     }
/*     */ 
/* 400 */     throw new NoSuchMethodException("Constructor not found as having difficulties in reflection");
/*     */   }
/*     */ 
/*     */   private void exploreSlots(Class clazz)
/*     */   {
/* 405 */     ArrayList slots = new ArrayList();
/*     */ 
/* 407 */     if ((!isExternalizable()) && (!this.isArray) && (isSerializable()))
/*     */     {
/* 409 */       for (Class classIteration = clazz; (classIteration != null) && (Serializable.class.isAssignableFrom(classIteration)); classIteration = classIteration.getSuperclass())
/*     */       {
/* 411 */         ClassMetaDataSlot slot = new ClassMetaDataSlot(classIteration);
/* 412 */         slots.add(slot);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 417 */       ClassMetaDataSlot slot = new ClassMetaDataSlot(clazz);
/* 418 */       slots.add(slot);
/*     */     }
/*     */ 
/* 421 */     Collections.reverse(slots);
/* 422 */     this.slots = ((ClassMetaDataSlot[])(ClassMetaDataSlot[])slots.toArray(new ClassMetaDataSlot[slots.size()]));
/*     */   }
/*     */ 
/*     */   private void lookupInternalMethods(Class clazz)
/*     */   {
/* 427 */     if (clazz.isInterface())
/*     */     {
/* 429 */       return;
/*     */     }
/*     */ 
/* 432 */     Method method = lookupMethodOnHierarchy(clazz, "readResolve", EMPTY_CLASS_ARRY);
/* 433 */     if (method != null)
/*     */     {
/* 435 */       method.setAccessible(true);
/* 436 */       setReadResolveMethod(method);
/*     */     }
/*     */ 
/* 439 */     method = lookupMethodOnHierarchy(clazz, "writeReplace", EMPTY_CLASS_ARRY);
/* 440 */     if (method != null)
/*     */     {
/* 442 */       method.setAccessible(true);
/* 443 */       setWriteReplaceMethod(method);
/*     */     }
/*     */   }
/*     */ 
/*     */   static class GhostConstructorPersistentReference extends PersistentReference
/*     */   {
/*     */     GhostConstructorPersistentReference(Class clazz, Constructor constructor)
/*     */     {
/*  61 */       super(constructor, 2);
/*     */     }
/*     */ 
/*     */     public synchronized Object rebuildReference() throws Exception
/*     */     {
/*  66 */       Object returnValue = null;
/*  67 */       if ((returnValue = internalGet()) != null) return returnValue;
/*     */ 
/*  69 */       if (ClassMetaData.isDebug)
/*     */       {
/*  71 */         ClassMetaData.log.debug("Constructor being rebuilt for " + getMappedClass());
/*     */       }
/*  73 */       Constructor constructorUsed = ClassMetaData.access$200(getMappedClass());
/*  74 */       buildReference(constructorUsed);
/*  75 */       return constructorUsed;
/*     */     }
/*     */ 
/*     */     public Constructor getConstructor()
/*     */     {
/*  80 */       return (Constructor)get();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.serial.classmetamodel.ClassMetaData
 * JD-Core Version:    0.6.0
 */