/*     */ package org.jboss.serial.classmetamodel;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.NotSerializableException;
/*     */ import java.io.ObjectStreamClass;
/*     */ import java.io.ObjectStreamField;
/*     */ import java.io.Serializable;
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import org.apache.log4j.Logger;
/*     */ import org.jboss.serial.util.ClassMetaConsts;
/*     */ import org.jboss.serial.util.FastHashMap;
/*     */ import org.jboss.serial.util.PartitionedWeakHashMap;
/*     */ 
/*     */ public class ClassMetamodelFactory
/*     */   implements ClassMetaConsts
/*     */ {
/*  49 */   private static final Logger log = Logger.getLogger(ClassMetamodelFactory.class);
/*  50 */   private static final boolean isDebug = log.isDebugEnabled();
/*     */ 
/*  55 */   private static final HashMap primClasses = new HashMap(8, 1.0F);
/*     */   static Method methodLookup;
/*     */   static Method methodGetField;
/*     */   private static Map systemClassLoaderMap;
/*     */   static ThreadLocal cacheLoader;
/*     */   static PartitionedWeakHashMap cache;
/*     */   static ClassMetaData proxyMetaData;
/*     */ 
/*     */   private static ObjectStreamClass lookup(Class clazz)
/*     */     throws IllegalAccessException, InvocationTargetException
/*     */   {
/* 123 */     return (ObjectStreamClass)methodLookup.invoke(null, new Object[] { clazz, Boolean.TRUE });
/*     */   }
/*     */ 
/*     */   private static Field getField(Object source) throws IllegalAccessException, InvocationTargetException
/*     */   {
/* 128 */     return (Field)methodGetField.invoke(source, EMPTY_OBJECT_ARRAY);
/*     */   }
/*     */ 
/*     */   public static void clear(boolean elimiteClassLoadersCached)
/*     */   {
/* 159 */     Iterator iter = cache.values().iterator();
/* 160 */     while (iter.hasNext())
/*     */     {
/* 162 */       Map map = (Map)iter.next();
/* 163 */       map.clear();
/*     */     }
/* 165 */     if (elimiteClassLoadersCached) cache.clear();
/* 166 */     systemClassLoaderMap.clear();
/*     */   }
/*     */ 
/*     */   public static void clear()
/*     */   {
/* 171 */     clear(true);
/*     */   }
/*     */ 
/*     */   public static Map getCache()
/*     */   {
/* 176 */     return cache;
/*     */   }
/*     */ 
/*     */   public static void printCacheDebug()
/*     */   {
/* 181 */     Iterator iter = getCache().keySet().iterator();
/*     */ 
/* 183 */     while (iter.hasNext())
/*     */     {
/* 185 */       Object loader = iter.next();
/* 186 */       log.debug("ClassLoader = " + loader);
/* 187 */       Map classesMap = (Map)getCache().get(loader);
/* 188 */       Iterator classesIterator = classesMap.keySet().iterator();
/* 189 */       while (classesIterator.hasNext())
/*     */       {
/* 191 */         log.debug("Class = " + classesIterator.next());
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private static Map getLoaderMap(ClassLoader loader)
/*     */   {
/* 220 */     if (loader == null)
/*     */     {
/* 222 */       return systemClassLoaderMap;
/*     */     }
/*     */ 
/* 225 */     CacheLoaderReference loaderReference = (CacheLoaderReference)cacheLoader.get();
/* 226 */     if (loaderReference == null)
/*     */     {
/* 228 */       loaderReference = new CacheLoaderReference(null);
/* 229 */       cacheLoader.set(loaderReference);
/*     */     }
/*     */ 
/* 232 */     if (loaderReference.getCurrentClassLoader() == loader)
/*     */     {
/* 234 */       return loaderReference.getCurrentMap();
/*     */     }
/*     */ 
/* 238 */     Map hashMap = (Map)cache.get(loader);
/*     */ 
/* 240 */     ClassLoader returnLoader = null;
/* 241 */     if (hashMap == null)
/*     */     {
/* 243 */       hashMap = new FastHashMap();
/* 244 */       cache.put(loader, hashMap);
/* 245 */       hashMap = (Map)cache.get(loader);
/*     */     }
/*     */ 
/* 248 */     loaderReference.setCurrentClassLoader(loader);
/* 249 */     loaderReference.setCurrentMap(hashMap);
/* 250 */     return hashMap;
/*     */   }
/*     */ 
/*     */   private static ClassMetaData getClassMetaData(String clazzName, ClassLoader loader, boolean checkSerializable) throws IOException {
/* 254 */     return getClassMetaData(clazzName, null, loader, checkSerializable);
/*     */   }
/*     */ 
/*     */   private static Class resolveClassByName(String clazzName, ClassResolver resolver, ClassLoader loader)
/*     */     throws ClassNotFoundException
/*     */   {
/* 260 */     Class clazz = (Class)primClasses.get(clazzName);
/*     */ 
/* 262 */     if (clazz == null)
/*     */     {
/* 264 */       if (resolver != null)
/*     */       {
/* 266 */         clazz = resolver.resolveClass(clazzName);
/* 267 */         if (clazz == null)
/*     */         {
/* 269 */           clazz = Class.forName(clazzName, false, loader);
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 274 */         clazz = Class.forName(clazzName, false, loader);
/*     */       }
/*     */     }
/* 277 */     return clazz;
/*     */   }
/*     */ 
/*     */   public static ClassMetaData getClassMetaData(String clazzName, ClassResolver resolver, ClassLoader loader, boolean checkSerializable) throws IOException {
/*     */     IOException ex;
/*     */     try {
/* 284 */       Map loaderMap = getLoaderMap(loader);
/* 285 */       ClassMetaData classMetadata = (ClassMetaData)loaderMap.get(clazzName);
/* 286 */       if (classMetadata == null)
/*     */       {
/* 289 */         Class clazz = resolveClassByName(clazzName, resolver, loader);
/*     */ 
/* 291 */         if ((checkSerializable) && (!Serializable.class.isAssignableFrom(clazz)))
/*     */         {
/* 293 */           throw new NotSerializableException(clazz.getName());
/*     */         }
/* 295 */         classMetadata = new ClassMetaData(clazz);
/*     */ 
/* 297 */         loaderMap = getLoaderMap(loader);
/* 298 */         loaderMap.put(clazzName, classMetadata);
/* 299 */         classMetadata = (ClassMetaData)loaderMap.get(clazzName);
/*     */       }
/*     */ 
/* 302 */       if (classMetadata.getClazz() == null)
/*     */       {
/* 308 */         if (isDebug)
/*     */         {
/* 310 */           log.debug("Rebuilding clazz due to cross Loader GC (getClassMetaData(String class, ClassLoader loader)");
/*     */         }
/* 312 */         Class clazz = resolveClassByName(clazzName, resolver, loader);
/* 313 */         loaderMap.remove(clazzName);
/* 314 */         classMetadata = new ClassMetaData(clazz);
/* 315 */         loaderMap.put(clazz.getName(), classMetadata);
/* 316 */         classMetadata = (ClassMetaData)loaderMap.get(clazzName);
/*     */       }
/*     */ 
/* 321 */       if (classMetadata.isProxy())
/*     */       {
/* 323 */         return proxyMetaData;
/*     */       }
/*     */ 
/* 326 */       return classMetadata;
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/* 332 */       ex = new IOException(e.getMessage());
/* 333 */       ex.initCause(e);
/* 334 */     }throw ex;
/*     */   }
/*     */ 
/*     */   public static ClassMetaData getClassMetaData(Class clazz, boolean checkSerializable)
/*     */     throws IOException
/*     */   {
/* 342 */     if ((checkSerializable) && (!Serializable.class.isAssignableFrom(clazz)) && (!clazz.isPrimitive()))
/*     */     {
/* 344 */       throw new NotSerializableException(clazz.getName());
/*     */     }
/* 346 */     Map loaderMap = getLoaderMap(clazz.getClassLoader());
/* 347 */     ClassMetaData classMetadata = (ClassMetaData)loaderMap.get(clazz.getName());
/* 348 */     if (classMetadata == null)
/*     */     {
/* 350 */       classMetadata = new ClassMetaData(clazz);
/* 351 */       loaderMap.put(clazz.getName(), classMetadata);
/* 352 */       classMetadata = (ClassMetaData)loaderMap.get(clazz.getName());
/*     */     }
/* 354 */     if (classMetadata.getClazz() == null)
/*     */     {
/* 360 */       if (isDebug)
/*     */       {
/* 362 */         log.debug("Rebuilding clazz due to cross Loader GC (getClassMetaData(Class clazz, ClassLoader loader)");
/*     */       }
/* 364 */       loaderMap.remove(clazz.getName());
/* 365 */       classMetadata = new ClassMetaData(clazz);
/* 366 */       loaderMap.put(clazz.getName(), classMetadata);
/* 367 */       classMetadata = (ClassMetaData)loaderMap.get(clazz.getName());
/*     */     }
/*     */ 
/* 371 */     if (classMetadata.isProxy())
/*     */     {
/* 373 */       return proxyMetaData;
/*     */     }
/*     */ 
/* 376 */     return classMetadata;
/*     */   }
/*     */ 
/*     */   public static boolean isImmutable(Class clazz)
/*     */   {
/* 383 */     return (clazz == Character.class) || (clazz == String.class) || (clazz == Long.class) || (clazz == Byte.class) || (clazz == Double.class) || (clazz == Float.class) || (clazz == Integer.class) || (clazz == Short.class) || (clazz == Boolean.class) || (clazz.isPrimitive());
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  57 */     primClasses.put("boolean", Boolean.TYPE);
/*  58 */     primClasses.put("byte", Byte.TYPE);
/*  59 */     primClasses.put("char", Character.TYPE);
/*  60 */     primClasses.put("short", Short.TYPE);
/*  61 */     primClasses.put("int", Integer.TYPE);
/*  62 */     primClasses.put("long", Long.TYPE);
/*  63 */     primClasses.put("float", Float.TYPE);
/*  64 */     primClasses.put("double", Double.TYPE);
/*  65 */     primClasses.put("void", Void.TYPE);
/*  66 */     primClasses.put("[Z", new boolean[0].getClass());
/*  67 */     primClasses.put("[B", new byte[0].getClass());
/*  68 */     primClasses.put("[C", new char[0].getClass());
/*  69 */     primClasses.put("[S", new short[0].getClass());
/*  70 */     primClasses.put("[I", new int[0].getClass());
/*  71 */     primClasses.put("[J", new long[0].getClass());
/*  72 */     primClasses.put("[F", new float[0].getClass());
/*  73 */     primClasses.put("[D", new double[0].getClass());
/*     */ 
/* 119 */     systemClassLoaderMap = new FastHashMap();
/*     */ 
/* 131 */     cacheLoader = new ThreadLocal();
/*     */     try
/*     */     {
/* 137 */       methodLookup = class$java$io$ObjectStreamClass.getDeclaredMethod("lookup", new Class[] { Class.class, Boolean.TYPE });
/* 138 */       methodLookup.setAccessible(true);
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 142 */       e.printStackTrace();
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 147 */       methodGetField = ObjectStreamField.class.getDeclaredMethod("getField", new Class[0]);
/* 148 */       methodGetField.setAccessible(true);
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 152 */       e.printStackTrace();
/*     */     }
/*     */ 
/* 201 */     cache = new PartitionedWeakHashMap();
/*     */ 
/* 203 */     proxyMetaData = null;
/*     */     try
/*     */     {
/* 209 */       proxyMetaData = getClassMetaData("java.lang.reflect.Proxy", Thread.currentThread().getContextClassLoader(), true);
/* 210 */       proxyMetaData.setProxy(true);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 214 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class CacheLoaderReference
/*     */   {
/*     */     WeakReference currentClassLoader;
/*     */     Map currentHashMap;
/*     */ 
/*     */     private CacheLoaderReference()
/*     */     {
/*     */     }
/*     */ 
/*     */     public ClassLoader getCurrentClassLoader()
/*     */     {
/*  84 */       if (this.currentClassLoader == null) {
/*  85 */         return null;
/*     */       }
/*  87 */       return (ClassLoader)this.currentClassLoader.get();
/*     */     }
/*     */ 
/*     */     public void setCurrentClassLoader(ClassLoader loader)
/*     */     {
/*  92 */       this.currentClassLoader = new WeakReference(loader);
/*     */     }
/*     */ 
/*     */     public Map getCurrentMap()
/*     */     {
/*  97 */       return this.currentHashMap;
/*     */     }
/*     */ 
/*     */     public void setCurrentMap(Map currentMap)
/*     */     {
/* 102 */       this.currentHashMap = currentMap;
/*     */     }
/*     */ 
/*     */     CacheLoaderReference(ClassMetamodelFactory.1 x0)
/*     */     {
/*  77 */       this();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.serial.classmetamodel.ClassMetamodelFactory
 * JD-Core Version:    0.6.0
 */