/*    */ package org.jboss.serial.classmetamodel;
/*    */ 
/*    */ import java.lang.reflect.Field;
/*    */ import org.apache.log4j.Logger;
/*    */ 
/*    */ public abstract class FieldsManager
/*    */ {
/* 40 */   private static final Logger log = Logger.getLogger(FieldsManager.class);
/* 41 */   private static final boolean isDebug = log.isDebugEnabled();
/*    */   private static FieldsManager fieldsManager;
/*    */ 
/*    */   public static FieldsManager getFieldsManager()
/*    */   {
/* 86 */     return fieldsManager;
/*    */   }
/*    */ 
/*    */   public abstract void fillMetadata(ClassMetadataField paramClassMetadataField);
/*    */ 
/*    */   public abstract void setInt(Object paramObject, ClassMetadataField paramClassMetadataField, int paramInt);
/*    */ 
/*    */   public abstract int getInt(Object paramObject, ClassMetadataField paramClassMetadataField);
/*    */ 
/*    */   public abstract void setByte(Object paramObject, ClassMetadataField paramClassMetadataField, byte paramByte);
/*    */ 
/*    */   public abstract byte getByte(Object paramObject, ClassMetadataField paramClassMetadataField);
/*    */ 
/*    */   public abstract void setLong(Object paramObject, ClassMetadataField paramClassMetadataField, long paramLong);
/*    */ 
/*    */   public abstract long getLong(Object paramObject, ClassMetadataField paramClassMetadataField);
/*    */ 
/*    */   public abstract void setFloat(Object paramObject, ClassMetadataField paramClassMetadataField, float paramFloat);
/*    */ 
/*    */   public abstract float getFloat(Object paramObject, ClassMetadataField paramClassMetadataField);
/*    */ 
/*    */   public abstract void setDouble(Object paramObject, ClassMetadataField paramClassMetadataField, double paramDouble);
/*    */ 
/*    */   public abstract double getDouble(Object paramObject, ClassMetadataField paramClassMetadataField);
/*    */ 
/*    */   public abstract void setShort(Object paramObject, ClassMetadataField paramClassMetadataField, short paramShort);
/*    */ 
/*    */   public abstract short getShort(Object paramObject, ClassMetadataField paramClassMetadataField);
/*    */ 
/*    */   public abstract void setCharacter(Object paramObject, ClassMetadataField paramClassMetadataField, char paramChar);
/*    */ 
/*    */   public abstract char getCharacter(Object paramObject, ClassMetadataField paramClassMetadataField);
/*    */ 
/*    */   public abstract void setBoolean(Object paramObject, ClassMetadataField paramClassMetadataField, boolean paramBoolean);
/*    */ 
/*    */   public abstract boolean getBoolean(Object paramObject, ClassMetadataField paramClassMetadataField);
/*    */ 
/*    */   public abstract void setObject(Object paramObject1, ClassMetadataField paramClassMetadataField, Object paramObject2);
/*    */ 
/*    */   public abstract Object getObject(Object paramObject, ClassMetadataField paramClassMetadataField);
/*    */ 
/*    */   static
/*    */   {
/* 54 */     if (UnsafeFieldsManager.isSupported())
/*    */     {
/* 56 */       fieldsManager = new UnsafeFieldsManager();
/*    */     }
/*    */     else
/*    */     {
/*    */       try
/*    */       {
/* 62 */         Field fieldX = InternalFinalFieldTestClass.class.getDeclaredField("x");
/* 63 */         fieldX.setAccessible(true);
/*    */ 
/* 65 */         InternalFinalFieldTestClass fieldTest = new InternalFinalFieldTestClass(null);
/* 66 */         fieldX.setInt(fieldTest, 33);
/*    */ 
/* 69 */         fieldsManager = new ReflectionFieldsManager();
/*    */       }
/*    */       catch (Throwable e)
/*    */       {
/*    */       }
/*    */     }
/*    */ 
/* 76 */     if (fieldsManager == null)
/*    */     {
/* 78 */       log.error("Couldn't set FieldsManager, JBoss Serialization can't work properly on this VM");
/*    */     }
/*    */ 
/* 81 */     log.debug("FieldsManager in use = " + fieldsManager.getClass().getName());
/*    */   }
/*    */ 
/*    */   private static class InternalFinalFieldTestClass
/*    */   {
/* 47 */     final int x = 0;
/*    */ 
/*    */     private InternalFinalFieldTestClass()
/*    */     {
/*    */     }
/*    */ 
/*    */     InternalFinalFieldTestClass(FieldsManager.1 x0)
/*    */     {
/* 45 */       this();
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.serial.classmetamodel.FieldsManager
 * JD-Core Version:    0.6.0
 */