/*     */ package org.jboss.serial.classmetamodel;
/*     */ 
/*     */ import java.io.ObjectStreamClass;
/*     */ import java.lang.reflect.Field;
/*     */ import sun.misc.Unsafe;
/*     */ 
/*     */ public class UnsafeFieldsManager extends FieldsManager
/*     */ {
/*     */   static Unsafe unsafe;
/*     */ 
/*     */   public static boolean isSupported()
/*     */   {
/*  48 */     return unsafe != null;
/*     */   }
/*     */ 
/*     */   public void fillMetadata(ClassMetadataField field)
/*     */   {
/*  75 */     if (field.getField() != null)
/*     */     {
/*  77 */       field.setUnsafeKey(unsafe.objectFieldOffset(field.getField()));
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setInt(Object obj, ClassMetadataField field, int value) {
/*  82 */     unsafe.putInt(obj, field.getUnsafeKey(), value);
/*     */   }
/*     */ 
/*     */   public int getInt(Object obj, ClassMetadataField field) {
/*  86 */     return unsafe.getInt(obj, field.getUnsafeKey());
/*     */   }
/*     */ 
/*     */   public void setByte(Object obj, ClassMetadataField field, byte value) {
/*  90 */     unsafe.putByte(obj, field.getUnsafeKey(), value);
/*     */   }
/*     */ 
/*     */   public byte getByte(Object obj, ClassMetadataField field) {
/*  94 */     return unsafe.getByte(obj, field.getUnsafeKey());
/*     */   }
/*     */ 
/*     */   public void setLong(Object obj, ClassMetadataField field, long value) {
/*  98 */     unsafe.putLong(obj, field.getUnsafeKey(), value);
/*     */   }
/*     */ 
/*     */   public long getLong(Object obj, ClassMetadataField field) {
/* 102 */     return unsafe.getLong(obj, field.getUnsafeKey());
/*     */   }
/*     */ 
/*     */   public void setFloat(Object obj, ClassMetadataField field, float value) {
/* 106 */     unsafe.putFloat(obj, field.getUnsafeKey(), value);
/*     */   }
/*     */ 
/*     */   public float getFloat(Object obj, ClassMetadataField field) {
/* 110 */     return unsafe.getFloat(obj, field.getUnsafeKey());
/*     */   }
/*     */ 
/*     */   public void setDouble(Object obj, ClassMetadataField field, double value) {
/* 114 */     unsafe.putDouble(obj, field.getUnsafeKey(), value);
/*     */   }
/*     */ 
/*     */   public double getDouble(Object obj, ClassMetadataField field) {
/* 118 */     return unsafe.getDouble(obj, field.getUnsafeKey());
/*     */   }
/*     */ 
/*     */   public void setShort(Object obj, ClassMetadataField field, short value) {
/* 122 */     unsafe.putShort(obj, field.getUnsafeKey(), value);
/*     */   }
/*     */ 
/*     */   public short getShort(Object obj, ClassMetadataField field) {
/* 126 */     return unsafe.getShort(obj, field.getUnsafeKey());
/*     */   }
/*     */ 
/*     */   public void setCharacter(Object obj, ClassMetadataField field, char value) {
/* 130 */     unsafe.putChar(obj, field.getUnsafeKey(), value);
/*     */   }
/*     */ 
/*     */   public char getCharacter(Object obj, ClassMetadataField field) {
/* 134 */     return unsafe.getChar(obj, field.getUnsafeKey());
/*     */   }
/*     */ 
/*     */   public void setBoolean(Object obj, ClassMetadataField field, boolean value) {
/* 138 */     unsafe.putBoolean(obj, field.getUnsafeKey(), value);
/*     */   }
/*     */ 
/*     */   public boolean getBoolean(Object obj, ClassMetadataField field) {
/* 142 */     return unsafe.getBoolean(obj, field.getUnsafeKey());
/*     */   }
/*     */ 
/*     */   public void setObject(Object obj, ClassMetadataField field, Object value) {
/* 146 */     unsafe.putObject(obj, field.getUnsafeKey(), value);
/*     */   }
/*     */ 
/*     */   public Object getObject(Object obj, ClassMetadataField field) {
/* 150 */     return unsafe.getObject(obj, field.getUnsafeKey());
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  55 */       Class[] classes = ObjectStreamClass.class.getDeclaredClasses();
/*  56 */       for (int i = 0; i < classes.length; i++)
/*     */       {
/*  58 */         if (!classes[i].getName().equals("java.io.ObjectStreamClass$FieldReflector"))
/*     */           continue;
/*  60 */         Field unsafeField = classes[i].getDeclaredField("unsafe");
/*  61 */         unsafeField.setAccessible(true);
/*     */ 
/*  63 */         unsafe = (Unsafe)unsafeField.get(null);
/*  64 */         break;
/*     */       }
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.serial.classmetamodel.UnsafeFieldsManager
 * JD-Core Version:    0.6.0
 */