/*    */ package org.jboss.serial.finalcontainers;
/*    */ 
/*    */ import java.io.DataInput;
/*    */ import java.io.DataOutput;
/*    */ import java.io.IOException;
/*    */ import java.lang.reflect.Field;
/*    */ 
/*    */ public class DoubleContainer extends FinalContainer
/*    */ {
/*    */   double value;
/*    */ 
/*    */   public DoubleContainer(double value)
/*    */   {
/* 39 */     this.value = value;
/*    */   }
/*    */ 
/*    */   public DoubleContainer() {
/*    */   }
/*    */ 
/*    */   public double getValue() {
/* 46 */     return this.value;
/*    */   }
/*    */ 
/*    */   public boolean equals(Object o) {
/* 50 */     if (this == o) return true;
/* 51 */     if ((o == null) || (getClass() != o.getClass())) return false;
/*    */ 
/* 53 */     DoubleContainer that = (DoubleContainer)o;
/*    */ 
/* 55 */     return Double.compare(that.value, this.value) == 0;
/*    */   }
/*    */ 
/*    */   public int hashCode()
/*    */   {
/* 61 */     long temp = this.value != 0.0D ? Double.doubleToLongBits(this.value) : 0L;
/* 62 */     return (int)(temp ^ temp >>> 32);
/*    */   }
/*    */ 
/*    */   public void writeMyself(DataOutput output) throws IOException
/*    */   {
/* 67 */     output.writeDouble(this.value);
/*    */   }
/*    */ 
/*    */   public void readMyself(DataInput input) throws IOException
/*    */   {
/* 72 */     this.value = input.readDouble();
/*    */   }
/*    */ 
/*    */   public void setPrimitive(Object obj, Field field) throws IllegalAccessException {
/* 76 */     field.setDouble(obj, this.value);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.serial.finalcontainers.DoubleContainer
 * JD-Core Version:    0.6.0
 */