/*     */ package org.jboss.serial.io;
/*     */ 
/*     */ import java.io.DataInputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.InvalidObjectException;
/*     */ import java.io.NotActiveException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectInputValidation;
/*     */ import java.io.ObjectStreamClass;
/*     */ import java.io.StreamCorruptedException;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Field;
/*     */ import java.util.Arrays;
/*     */ import org.jboss.serial.classmetamodel.ClassResolver;
/*     */ import org.jboss.serial.objectmetamodel.DataContainer;
/*     */ import org.jboss.serial.objectmetamodel.DataContainerConstants;
/*     */ import org.jboss.serial.util.ClassMetaConsts;
/*     */ import org.jboss.serial.util.StringUtil;
/*     */ import org.jboss.serial.util.StringUtilBuffer;
/*     */ 
/*     */ public class JBossObjectInputStream extends ObjectInputStream
/*     */   implements DataContainerConstants
/*     */ {
/*     */   InputStream is;
/*     */   DataInputStream dis;
/*     */   DataContainer container;
/*     */   ClassLoader classLoader;
/*     */   StringUtilBuffer buffer;
/*     */   private static Constructor constructorObjectStreamClass;
/*     */   private static Field setNameField;
/* 117 */   ClassResolver resolver = new ClassResolver()
/*     */   {
/*     */     public Class resolveClass(String name) throws ClassNotFoundException
/*     */     {
/* 121 */       if (JBossObjectInputStream.constructorObjectStreamClass != null)
/*     */       {
/*     */         try
/*     */         {
/* 125 */           ObjectStreamClass streamClass = (ObjectStreamClass)JBossObjectInputStream.constructorObjectStreamClass.newInstance(ClassMetaConsts.EMPTY_OBJECT_ARRAY);
/* 126 */           JBossObjectInputStream.setNameField.set(streamClass, name);
/* 127 */           return JBossObjectInputStream.this.resolveClass(streamClass);
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 131 */           e.printStackTrace();
/* 132 */           return null;
/*     */         }
/*     */       }
/* 135 */       return null;
/*     */     }
/* 117 */   };
/*     */ 
/*     */   public JBossObjectInputStream(InputStream is)
/*     */     throws IOException
/*     */   {
/*  73 */     this(is, Thread.currentThread().getContextClassLoader());
/*     */   }
/*     */ 
/*     */   public JBossObjectInputStream(InputStream is, StringUtilBuffer buffer) throws IOException
/*     */   {
/*  78 */     this(is, Thread.currentThread().getContextClassLoader(), buffer);
/*     */   }
/*     */ 
/*     */   public JBossObjectInputStream(InputStream is, ClassLoader loader) throws IOException
/*     */   {
/*  83 */     this(is, loader, null);
/*     */   }
/*     */ 
/*     */   public JBossObjectInputStream(InputStream is, ClassLoader loader, StringUtilBuffer buffer)
/*     */     throws IOException
/*     */   {
/*  90 */     this.buffer = buffer;
/*     */ 
/*  92 */     if (is != null)
/*     */     {
/*  94 */       checkSignature(is);
/*  95 */       this.is = is;
/*  96 */       if ((is instanceof DataInputStream))
/*     */       {
/*  98 */         this.dis = ((DataInputStream)is);
/*     */       }
/*     */       else {
/* 101 */         this.dis = new DataInputStream(is);
/*     */       }
/*     */     }
/*     */ 
/* 105 */     this.classLoader = loader;
/*     */   }
/*     */ 
/*     */   private void checkSignature(InputStream is) throws IOException {
/* 109 */     byte[] signature = new byte[openSign.length];
/* 110 */     is.read(signature);
/* 111 */     if (!Arrays.equals(signature, openSign))
/*     */     {
/* 113 */       throw new IOException("Mismatch version of JBossSerialization signature");
/*     */     }
/*     */   }
/*     */ 
/*     */   protected Class resolveClass(ObjectStreamClass desc)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 141 */     return Class.forName(desc.getName(), false, getClassLoader());
/*     */   }
/*     */ 
/*     */   public Object readObjectUsingDataContainer()
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 148 */     DataContainer container = new DataContainer(this.classLoader, false, this.buffer);
/* 149 */     container.setClassResolver(this.resolver);
/* 150 */     container.loadData(this.dis);
/* 151 */     ObjectInput input = container.getInput();
/* 152 */     return input.readObject();
/*     */   }
/*     */ 
/*     */   public Object readObjectOverride()
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 158 */     DataContainer container = new DataContainer(this.classLoader, false, this.buffer);
/* 159 */     container.setClassResolver(this.resolver);
/*     */ 
/* 162 */     ObjectInput input = container.getDirectInput(this.dis);
/* 163 */     return input.readObject();
/*     */   }
/*     */ 
/*     */   public Object readUnshared() throws IOException, ClassNotFoundException
/*     */   {
/* 168 */     return readObjectOverride();
/*     */   }
/*     */ 
/*     */   public void defaultReadObject()
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void registerValidation(ObjectInputValidation obj, int prio)
/*     */     throws NotActiveException, InvalidObjectException
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void readStreamHeader()
/*     */     throws IOException, StreamCorruptedException
/*     */   {
/*     */   }
/*     */ 
/*     */   protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException
/*     */   {
/* 188 */     return null;
/*     */   }
/*     */ 
/*     */   public int read() throws IOException
/*     */   {
/* 193 */     return this.dis.read();
/*     */   }
/*     */ 
/*     */   public int read(byte[] buf, int off, int len) throws IOException
/*     */   {
/* 198 */     return this.dis.read(buf, off, len);
/*     */   }
/*     */ 
/*     */   public int available()
/*     */     throws IOException
/*     */   {
/* 211 */     return 1;
/*     */   }
/*     */ 
/*     */   public void close() throws IOException
/*     */   {
/*     */   }
/*     */ 
/*     */   public boolean readBoolean() throws IOException
/*     */   {
/* 220 */     return this.dis.readBoolean();
/*     */   }
/*     */ 
/*     */   public byte readByte() throws IOException
/*     */   {
/* 225 */     return this.dis.readByte();
/*     */   }
/*     */ 
/*     */   public int readUnsignedByte() throws IOException
/*     */   {
/* 230 */     return this.dis.readUnsignedByte();
/*     */   }
/*     */ 
/*     */   public char readChar() throws IOException
/*     */   {
/* 235 */     return this.dis.readChar();
/*     */   }
/*     */ 
/*     */   public short readShort() throws IOException
/*     */   {
/* 240 */     return this.dis.readShort();
/*     */   }
/*     */ 
/*     */   public int readUnsignedShort() throws IOException
/*     */   {
/* 245 */     return this.dis.readUnsignedShort();
/*     */   }
/*     */ 
/*     */   public int readInt() throws IOException
/*     */   {
/* 250 */     return this.dis.readInt();
/*     */   }
/*     */ 
/*     */   public long readLong() throws IOException
/*     */   {
/* 255 */     return this.dis.readLong();
/*     */   }
/*     */ 
/*     */   public float readFloat() throws IOException
/*     */   {
/* 260 */     return this.dis.readFloat();
/*     */   }
/*     */ 
/*     */   public double readDouble() throws IOException
/*     */   {
/* 265 */     return this.dis.readDouble();
/*     */   }
/*     */ 
/*     */   public void readFully(byte[] buf) throws IOException
/*     */   {
/* 270 */     this.dis.readFully(buf);
/*     */   }
/*     */ 
/*     */   public void readFully(byte[] buf, int off, int len) throws IOException
/*     */   {
/* 275 */     this.dis.readFully(buf, off, len);
/*     */   }
/*     */ 
/*     */   public int skipBytes(int len) throws IOException
/*     */   {
/* 280 */     return this.dis.skipBytes(len);
/*     */   }
/*     */ 
/*     */   public String readLine() throws IOException
/*     */   {
/* 285 */     return this.dis.readLine();
/*     */   }
/*     */ 
/*     */   public String readUTF() throws IOException
/*     */   {
/* 290 */     return StringUtil.readString(this.dis, this.buffer);
/*     */   }
/*     */ 
/*     */   public int read(byte[] b)
/*     */     throws IOException
/*     */   {
/* 300 */     return this.dis.read(b);
/*     */   }
/*     */ 
/*     */   public long skip(long n)
/*     */     throws IOException
/*     */   {
/* 310 */     return this.dis.skip(n);
/*     */   }
/*     */ 
/*     */   public ClassLoader getClassLoader() {
/* 314 */     if (this.classLoader == null) {
/* 315 */       return Thread.currentThread().getContextClassLoader();
/*     */     }
/*     */ 
/* 319 */     return this.classLoader;
/*     */   }
/*     */ 
/*     */   public void setClassLoader(ClassLoader classLoader)
/*     */   {
/* 324 */     this.classLoader = classLoader;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  56 */       constructorObjectStreamClass = ObjectStreamClass.class.getDeclaredConstructor(ClassMetaConsts.EMPTY_CLASS_ARRY);
/*  57 */       constructorObjectStreamClass.setAccessible(true);
/*  58 */       setNameField = ObjectStreamClass.class.getDeclaredField("name");
/*  59 */       setNameField.setAccessible(true);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  63 */       constructorObjectStreamClass = null;
/*  64 */       setNameField = null;
/*  65 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.serial.io.JBossObjectInputStream
 * JD-Core Version:    0.6.0
 */