/*    */ package org.jboss.serial.io;
/*    */ 
/*    */ import java.io.Externalizable;
/*    */ import java.io.IOException;
/*    */ import java.io.ObjectInput;
/*    */ import java.io.ObjectOutput;
/*    */ import org.apache.log4j.Logger;
/*    */ import org.jboss.serial.classmetamodel.ClassMetaData;
/*    */ import org.jboss.serial.objectmetamodel.DataContainer;
/*    */ import org.jboss.serial.objectmetamodel.ObjectsCache;
/*    */ import org.jboss.serial.objectmetamodel.safecloning.SafeCloningRepository;
/*    */ 
/*    */ public class MarshalledObjectForLocalCalls
/*    */   implements Externalizable
/*    */ {
/*    */   private static final long serialVersionUID = 785809358605094514L;
/* 24 */   private static final Logger log = Logger.getLogger(ClassMetaData.class);
/* 25 */   private static final boolean isDebug = log.isDebugEnabled();
/*    */   DataContainer container;
/*    */ 
/*    */   public MarshalledObjectForLocalCalls()
/*    */   {
/*    */   }
/*    */ 
/*    */   public MarshalledObjectForLocalCalls(Object obj)
/*    */     throws IOException
/*    */   {
/* 36 */     this.container = new DataContainer(false);
/* 37 */     ObjectOutput output = this.container.getOutput();
/* 38 */     output.writeObject(obj);
/* 39 */     output.flush();
/* 40 */     this.container.flush();
/*    */   }
/*    */ 
/*    */   public MarshalledObjectForLocalCalls(Object obj, SafeCloningRepository safeToReuse) throws IOException
/*    */   {
/* 45 */     this.container = new DataContainer(null, null, safeToReuse, false, null);
/* 46 */     ObjectOutput output = this.container.getOutput();
/* 47 */     output.writeObject(obj);
/* 48 */     output.flush();
/* 49 */     this.container.flush();
/*    */   }
/*    */ 
/*    */   public Object get()
/*    */     throws IOException, ClassNotFoundException
/*    */   {
/*    */     try
/*    */     {
/* 59 */       this.container.getCache().setLoader(Thread.currentThread().getContextClassLoader());
/* 60 */       return this.container.getInput().readObject();
/*    */     }
/*    */     catch (RuntimeException e)
/*    */     {
/* 64 */       log.error(e, e);
/* 65 */     }throw e;
/*    */   }
/*    */ 
/*    */   public void writeExternal(ObjectOutput out)
/*    */     throws IOException
/*    */   {
/* 71 */     if (isDebug)
/*    */     {
/* 73 */       log.debug("writeExternal");
/*    */     }
/* 75 */     this.container.saveData(out);
/*    */   }
/*    */ 
/*    */   public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
/*    */   {
/* 80 */     if (isDebug)
/*    */     {
/* 82 */       log.debug("readExternal");
/*    */     }
/* 84 */     this.container = new DataContainer(false);
/* 85 */     this.container.loadData(in);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.serial.io.MarshalledObjectForLocalCalls
 * JD-Core Version:    0.6.0
 */