/*     */ package org.jboss.serial.objectmetamodel;
/*     */ 
/*     */ import gnu.trove.TIntObjectHashMap;
/*     */ import gnu.trove.TObjectIntHashMap;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import org.jboss.serial.classmetamodel.ClassResolver;
/*     */ import org.jboss.serial.objectmetamodel.safecloning.SafeCloningRepository;
/*     */ import org.jboss.serial.util.ClassMetaConsts;
/*     */ import org.jboss.serial.util.StringUtilBuffer;
/*     */ 
/*     */ public class ObjectsCache extends DataExport
/*     */   implements ClassMetaConsts
/*     */ {
/*  44 */   final TObjectIntHashMap objectsCacheOnWrite = new TObjectIntHashMap(identityHashStrategy);
/*  45 */   final TIntObjectHashMap objectsCacheOnRead = new TIntObjectHashMap();
/*     */   ObjectSubstitutionInterface substitution;
/*  48 */   ClassLoader loader = null;
/*  49 */   boolean checkSerializableClass = true;
/*     */   SafeCloningRepository safeToReuse;
/*     */   JBossSeralizationOutputInterface output;
/*     */   JBossSeralizationInputInterface input;
/*     */   StringUtilBuffer stringBuffer;
/*     */   ClassResolver resolver;
/*     */ 
/*     */   public ObjectsCache cloneCache()
/*     */   {
/*  61 */     ObjectsCache newCache = new ObjectsCache();
/*  62 */     newCache.substitution = this.substitution;
/*  63 */     newCache.loader = this.loader;
/*  64 */     newCache.checkSerializableClass = this.checkSerializableClass;
/*  65 */     newCache.safeToReuse = this.safeToReuse;
/*  66 */     newCache.resolver = this.resolver;
/*  67 */     newCache.stringBuffer = null;
/*     */ 
/*  70 */     return newCache;
/*     */   }
/*     */ 
/*     */   private ObjectsCache()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ObjectsCache(ObjectSubstitutionInterface substitution, ClassLoader loader, SafeCloningRepository safeToReuse, boolean checkSerializableClass, StringUtilBuffer stringBuffer) {
/*  78 */     this.loader = loader;
/*  79 */     this.substitution = substitution;
/*  80 */     this.checkSerializableClass = checkSerializableClass;
/*  81 */     this.safeToReuse = safeToReuse;
/*  82 */     this.stringBuffer = stringBuffer;
/*     */   }
/*     */ 
/*     */   public void reset()
/*     */   {
/*  87 */     if (this.safeToReuse != null)
/*     */     {
/*  89 */       this.safeToReuse.clear();
/*     */     }
/*  91 */     this.objectsCacheOnWrite.clear();
/*  92 */     this.objectsCacheOnRead.clear();
/*     */   }
/*     */   public ClassLoader getLoader() {
/*  95 */     if (this.loader == null)
/*     */     {
/*  97 */       return Thread.currentThread().getContextClassLoader();
/*     */     }
/*     */ 
/* 101 */     return this.loader;
/*     */   }
/*     */ 
/*     */   public void setLoader(ClassLoader loader)
/*     */   {
/* 106 */     this.loader = loader;
/*     */   }
/*     */ 
/*     */   public ObjectSubstitutionInterface getSubstitution() {
/* 110 */     return this.substitution;
/*     */   }
/*     */ 
/*     */   public void setSubstitution(ObjectSubstitutionInterface substitution) {
/* 114 */     this.substitution = substitution;
/*     */   }
/*     */ 
/*     */   public StringUtilBuffer getStringBuffer()
/*     */   {
/* 122 */     return this.stringBuffer;
/*     */   }
/*     */ 
/*     */   public void setStringBuffer(StringUtilBuffer stringBuffer) {
/* 126 */     this.stringBuffer = stringBuffer;
/*     */   }
/*     */ 
/*     */   public int findIdInCacheWrite(Object obj)
/*     */   {
/* 132 */     return this.objectsCacheOnWrite.get(obj);
/*     */   }
/*     */ 
/*     */   public Object findObjectInCacheRead(int key)
/*     */   {
/* 141 */     return this.objectsCacheOnRead.get(key);
/*     */   }
/*     */ 
/*     */   public void putObjectInCacheRead(int key, Object obj)
/*     */   {
/* 146 */     this.objectsCacheOnRead.put(key, obj);
/*     */   }
/*     */ 
/*     */   public void reassignObjectInCacheRead(int key, Object value) {
/* 150 */     this.objectsCacheOnRead.remove(key);
/* 151 */     putObjectInCacheRead(key, value);
/*     */   }
/*     */ 
/*     */   public int putObjectInCacheWrite(Object obj)
/*     */   {
/* 158 */     this.objectsCacheOnWrite.put(obj, this.objectsCacheOnWrite.size() + 1);
/* 159 */     return this.objectsCacheOnWrite.size();
/*     */   }
/*     */ 
/*     */   public SafeCloningRepository getSafeToReuse()
/*     */   {
/* 217 */     return this.safeToReuse;
/*     */   }
/*     */ 
/*     */   public boolean isCheckSerializableClass() {
/* 221 */     return this.checkSerializableClass;
/*     */   }
/*     */ 
/*     */   public void setCheckSerializableClass(boolean checkSerializableClass) {
/* 225 */     this.checkSerializableClass = checkSerializableClass;
/*     */   }
/*     */ 
/*     */   public JBossSeralizationOutputInterface getOutput()
/*     */   {
/* 240 */     return this.output;
/*     */   }
/*     */ 
/*     */   public void setOutput(JBossSeralizationOutputInterface output) {
/* 244 */     this.output = output;
/*     */   }
/*     */ 
/*     */   public JBossSeralizationInputInterface getInput() {
/* 248 */     return this.input;
/*     */   }
/*     */ 
/*     */   public void setInput(JBossSeralizationInputInterface input) {
/* 252 */     this.input = input;
/*     */   }
/*     */ 
/*     */   public ClassResolver getClassResolver() {
/* 256 */     return this.resolver;
/*     */   }
/*     */ 
/*     */   public void setClassResolver(ClassResolver resolver)
/*     */   {
/* 261 */     this.resolver = resolver;
/*     */   }
/*     */ 
/*     */   public static abstract interface JBossSeralizationInputInterface extends ObjectInput
/*     */   {
/*     */     public abstract int readObjectReference()
/*     */       throws IOException;
/*     */ 
/*     */     public abstract byte readByteDirectly()
/*     */       throws IOException;
/*     */ 
/*     */     public abstract Object readImmutable(byte paramByte, ObjectsCache paramObjectsCache)
/*     */       throws IOException;
/*     */   }
/*     */ 
/*     */   public static abstract interface JBossSeralizationOutputInterface extends ObjectOutput
/*     */   {
/*     */     public abstract void addObjectReference(int paramInt)
/*     */       throws IOException;
/*     */ 
/*     */     public abstract void openObjectDefinition()
/*     */       throws IOException;
/*     */ 
/*     */     public abstract void closeObjectDefinition()
/*     */       throws IOException;
/*     */ 
/*     */     public abstract void writeByteDirectly(byte paramByte)
/*     */       throws IOException;
/*     */ 
/*     */     public abstract boolean isCheckSerializableClass();
/*     */ 
/*     */     public abstract void saveImmutable(ObjectsCache paramObjectsCache, Object paramObject)
/*     */       throws IOException;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.serial.objectmetamodel.ObjectsCache
 * JD-Core Version:    0.6.0
 */