/*    */ package org.jboss.serial.objectmetamodel.safecloning;
/*    */ 
/*    */ import gnu.trove.TObjectIntHashMap;
/*    */ import java.util.ArrayList;
/*    */ import org.apache.log4j.Logger;
/*    */ import org.jboss.serial.util.ClassMetaConsts;
/*    */ 
/*    */ public class SafeCloningRepository
/*    */   implements ClassMetaConsts
/*    */ {
/* 41 */   private static final Logger log = Logger.getLogger(SafeCloningRepository.class);
/* 42 */   private static final boolean isDebug = log.isDebugEnabled();
/*    */   private SafeClone safeClone;
/* 52 */   TObjectIntHashMap safeToReuse = new TObjectIntHashMap(identityHashStrategy);
/* 53 */   ArrayList reuse = new ArrayList();
/*    */ 
/*    */   public SafeCloningRepository(SafeClone safeClone)
/*    */   {
/* 47 */     this.safeClone = safeClone;
/*    */   }
/*    */ 
/*    */   public void clear()
/*    */   {
/* 57 */     this.reuse.clear();
/* 58 */     this.safeToReuse.clear();
/*    */   }
/*    */ 
/*    */   public int storeSafe(Object obj)
/*    */   {
/* 63 */     if (this.safeClone.isSafeToReuse(obj))
/*    */     {
/* 65 */       int description = this.safeToReuse.get(obj);
/*    */ 
/* 67 */       if (description == 0)
/*    */       {
/* 69 */         this.safeToReuse.put(obj, this.safeToReuse.size() + 1);
/* 70 */         description = this.safeToReuse.size();
/* 71 */         if (isDebug)
/*    */         {
/* 73 */           log.debug("storeSafe::Created a new storeSafe Reference=" + description + " obj=" + obj.getClass().getName());
/*    */         }
/* 75 */         this.reuse.add(obj);
/*    */       }
/* 77 */       return description;
/*    */     }
/*    */ 
/* 80 */     return 0;
/*    */   }
/*    */ 
/*    */   public Object findReference(int reference)
/*    */   {
/* 86 */     Object retobject = this.reuse.get(reference - 1);
/* 87 */     if (isDebug)
/*    */     {
/* 89 */       if (retobject != null)
/*    */       {
/* 91 */         log.debug("findReference::found reference " + reference + " on an object=" + retobject.getClass().getName());
/*    */       }
/*    */     }
/* 94 */     return retobject;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.serial.objectmetamodel.safecloning.SafeCloningRepository
 * JD-Core Version:    0.6.0
 */