/*     */ package org.jboss.serial.util;
/*     */ 
/*     */ import java.util.AbstractMap;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import java.util.WeakHashMap;
/*     */ 
/*     */ public class PartitionedWeakHashMap extends AbstractMap
/*     */ {
/*     */   boolean issynchronized;
/*     */   Map[] partitionMaps;
/*     */   private static final int PARTITION_SIZE = 10;
/*     */ 
/*     */   public PartitionedWeakHashMap()
/*     */   {
/*  14 */     this(false);
/*     */   }
/*     */ 
/*     */   public PartitionedWeakHashMap(boolean issynchronized)
/*     */   {
/*  20 */     this.issynchronized = issynchronized;
/*  21 */     this.partitionMaps = new Map[10];
/*  22 */     for (int i = 0; i < 10; i++)
/*     */     {
/*  24 */       if (issynchronized)
/*     */       {
/*  26 */         this.partitionMaps[i] = Collections.synchronizedMap(new WeakHashMap());
/*     */       }
/*     */       else
/*     */       {
/*  30 */         this.partitionMaps[i] = new WeakHashMap();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public Map getMap(Object obj)
/*     */   {
/*  38 */     int hash = obj.hashCode();
/*  39 */     if (hash < 0) hash *= -1;
/*  40 */     hash %= 10;
/*  41 */     return this.partitionMaps[hash];
/*     */   }
/*     */ 
/*     */   public Set entrySet()
/*     */   {
/*  49 */     throw new RuntimeException("method not supported");
/*     */   }
/*     */ 
/*     */   public void clear() {
/*  53 */     for (int i = 0; i < this.partitionMaps.length; i++)
/*     */     {
/*  55 */       this.partitionMaps[i].clear();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected Object clone() throws CloneNotSupportedException {
/*  60 */     throw new RuntimeException("Clone not supported");
/*     */   }
/*     */ 
/*     */   public boolean containsKey(Object key) {
/*  64 */     return getMap(key).containsKey(key);
/*     */   }
/*     */ 
/*     */   public boolean containsValue(Object value) {
/*  68 */     throw new RuntimeException("method not supported");
/*     */   }
/*     */ 
/*     */   public boolean equals(Object o) {
/*  72 */     throw new RuntimeException("method not supported");
/*     */   }
/*     */ 
/*     */   public Object get(Object key) {
/*  76 */     return getMap(key).get(key);
/*     */   }
/*     */ 
/*     */   public boolean isEmpty() {
/*  80 */     throw new RuntimeException("method not supported");
/*     */   }
/*     */ 
/*     */   public Set keySet() {
/*  84 */     HashSet hashSet = new HashSet();
/*     */ 
/*  86 */     for (int i = 0; i < 10; i++)
/*     */     {
/*  88 */       hashSet.addAll(this.partitionMaps[i].keySet());
/*     */     }
/*     */ 
/*  91 */     return hashSet;
/*     */   }
/*     */ 
/*     */   public Object put(Object key, Object value)
/*     */   {
/*  97 */     if (!this.issynchronized)
/*     */     {
/*  99 */       Map map = getMap(key);
/* 100 */       synchronized (map)
/*     */       {
/* 102 */         return map.put(key, value);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 108 */     return getMap(key).put(key, value);
/*     */   }
/*     */ 
/*     */   public void putAll(Map elementsToAdd)
/*     */   {
/* 113 */     Iterator iter = elementsToAdd.entrySet().iterator();
/* 114 */     while (iter.hasNext())
/*     */     {
/* 116 */       Map.Entry entry = (Map.Entry)iter.next();
/* 117 */       put(entry.getKey(), entry.getValue());
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object remove(Object key) {
/* 122 */     return getMap(key).remove(key);
/*     */   }
/*     */ 
/*     */   public int size() {
/* 126 */     int size = 0;
/* 127 */     for (int i = 0; i < 10; i++)
/*     */     {
/* 129 */       size += this.partitionMaps[i].size();
/*     */     }
/* 131 */     return size;
/*     */   }
/*     */ 
/*     */   public Collection values() {
/* 135 */     ArrayList values = new ArrayList();
/* 136 */     for (int i = 0; i < 10; i++)
/*     */     {
/* 138 */       values.addAll(this.partitionMaps[i].values());
/*     */     }
/* 140 */     return values;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.serial.util.PartitionedWeakHashMap
 * JD-Core Version:    0.6.0
 */