/*     */ package org.jboss.system;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.interceptor.AbstractInterceptor;
/*     */ import org.jboss.mx.interceptor.Interceptor;
/*     */ import org.jboss.mx.server.Invocation;
/*     */ 
/*     */ public abstract class InterceptorServiceMBeanSupport extends ServiceMBeanSupport
/*     */   implements InterceptorServiceMBean
/*     */ {
/*     */   private List interceptables;
/*     */   private Interceptor interceptor;
/*     */ 
/*     */   public InterceptorServiceMBeanSupport()
/*     */   {
/*     */   }
/*     */ 
/*     */   public InterceptorServiceMBeanSupport(Class type)
/*     */   {
/*  82 */     super(type);
/*     */   }
/*     */ 
/*     */   public InterceptorServiceMBeanSupport(String category)
/*     */   {
/*  94 */     super(category);
/*     */   }
/*     */ 
/*     */   public InterceptorServiceMBeanSupport(Logger log)
/*     */   {
/* 106 */     super(log);
/*     */   }
/*     */ 
/*     */   public void setInterceptables(List interceptables)
/*     */   {
/* 114 */     if (interceptables != null)
/*     */     {
/* 116 */       this.interceptables = new ArrayList(interceptables);
/*     */     }
/*     */   }
/*     */ 
/*     */   public List getInterceptables()
/*     */   {
/* 123 */     if (this.interceptables != null)
/*     */     {
/* 125 */       return new ArrayList(this.interceptables);
/*     */     }
/* 127 */     return null;
/*     */   }
/*     */ 
/*     */   protected void attach()
/*     */     throws Exception
/*     */   {
/* 141 */     if (this.interceptor == null)
/*     */     {
/* 143 */       attach(new XMBeanInterceptor());
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void attach(Interceptor interceptor)
/*     */     throws Exception
/*     */   {
/* 155 */     if (interceptor == null)
/*     */     {
/* 157 */       throw new IllegalArgumentException("Null interceptor");
/*     */     }
/*     */ 
/* 161 */     if (this.interceptor != null)
/*     */     {
/* 163 */       throw new IllegalStateException("Interceptor already attached");
/*     */     }
/*     */ 
/* 166 */     this.log.debug("Attaching interceptor: " + interceptor.getName());
/*     */ 
/* 169 */     this.interceptor = interceptor;
/*     */     Object[] params;
/*     */     String[] signature;
/*     */     Iterator i;
/* 174 */     if (this.interceptables != null)
/*     */     {
/* 176 */       params = new Object[] { interceptor };
/* 177 */       signature = new String[] { Interceptor.class.getName() };
/*     */ 
/* 179 */       for (i = this.interceptables.iterator(); i.hasNext(); )
/*     */       {
/* 181 */         ObjectName target = (ObjectName)i.next();
/* 182 */         this.server.invoke(target, "addOperationInterceptor", params, signature);
/*     */ 
/* 187 */         this.log.debug("Interceptor attached to: '" + target + "'");
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void detach()
/*     */   {
/* 197 */     if (this.interceptor != null)
/*     */     {
/* 199 */       this.log.debug("Detaching interceptor: " + this.interceptor.getName());
/*     */       Object[] params;
/*     */       String[] signature;
/*     */       Iterator i;
/* 200 */       if (this.interceptables != null)
/*     */       {
/* 202 */         params = new Object[] { this.interceptor };
/* 203 */         signature = new String[] { Interceptor.class.getName() };
/*     */ 
/* 205 */         for (i = this.interceptables.iterator(); i.hasNext(); )
/*     */         {
/* 207 */           ObjectName target = (ObjectName)i.next();
/*     */           try
/*     */           {
/* 210 */             this.server.invoke(target, "removeOperationInterceptor", params, signature);
/*     */ 
/* 215 */             this.log.debug("Interceptor detached from: '" + target + "'");
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/* 219 */             this.log.debug("Caught exception while removing interceptor from '" + target + "'", e);
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/* 224 */       this.interceptor = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected Object invokeNext(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/* 235 */     Interceptor next = invocation.nextInterceptor();
/* 236 */     if (next != null)
/*     */     {
/* 238 */       return next.invoke(invocation);
/*     */     }
/*     */ 
/* 242 */     return invocation.dispatch();
/*     */   }
/*     */ 
/*     */   protected Object invoke(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/* 253 */     return invokeNext(invocation);
/*     */   }
/*     */ 
/*     */   private class XMBeanInterceptor extends AbstractInterceptor
/*     */   {
/*     */     public XMBeanInterceptor()
/*     */     {
/* 266 */       super();
/*     */     }
/*     */ 
/*     */     public Object invoke(Invocation invocation)
/*     */       throws Throwable
/*     */     {
/* 272 */       return InterceptorServiceMBeanSupport.this.invoke(invocation);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.InterceptorServiceMBeanSupport
 * JD-Core Version:    0.6.0
 */