/*     */ package org.jboss.system.filterfactory;
/*     */ 
/*     */ import java.util.Set;
/*     */ import java.util.Vector;
/*     */ import javax.management.Notification;
/*     */ import javax.management.NotificationFilter;
/*     */ import org.jboss.deployment.DeploymentInfo;
/*     */ import org.jboss.mx.util.JBossNotificationFilterSupport;
/*     */ import org.jboss.system.NotificationFilterFactory;
/*     */ import org.jboss.util.collection.CollectionsFactory;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ 
/*     */ public class DeploymentInfoNotificationFilterFactory
/*     */   implements NotificationFilterFactory
/*     */ {
/*     */   public static final String ENABLE_ELEMENT = "enable";
/*     */   public static final String ENABLE_TYPE_ATTRIBUTE = "type";
/*     */   public static final String ENABLE_SHORTNAME_ATTRIBUTE = "short-name";
/*     */ 
/*     */   public NotificationFilter createNotificationFilter(Element filterConfig)
/*     */     throws Exception
/*     */   {
/* 103 */     DeploymentInfoNotificationFilter filter = new DeploymentInfoNotificationFilter();
/*     */ 
/* 107 */     NodeList filterChildren = filterConfig.getChildNodes();
/*     */ 
/* 109 */     for (int i = 0; i < filterChildren.getLength(); i++)
/*     */     {
/* 111 */       Node filterChildNode = filterChildren.item(i);
/*     */ 
/* 114 */       if (!filterChildNode.getNodeName().equals("enable")) {
/*     */         continue;
/*     */       }
/* 117 */       if (((Element)filterChildNode).hasAttribute("type"))
/*     */       {
/* 119 */         String type = ((Element)filterChildNode).getAttribute("type");
/*     */ 
/* 121 */         filter.enableType(type);
/*     */       }
/* 123 */       else if (((Element)filterChildNode).hasAttribute("short-name"))
/*     */       {
/* 125 */         String shortName = ((Element)filterChildNode).getAttribute("short-name");
/*     */ 
/* 127 */         filter.enableShortName(shortName);
/*     */       }
/*     */       else
/*     */       {
/* 131 */         throw new Exception("'enable' element must have a 'type' or a 'short-name' attribute");
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 137 */     return filter;
/*     */   }
/*     */ 
/*     */   public static class DeploymentInfoNotificationFilter extends JBossNotificationFilterSupport
/*     */   {
/*     */     private static final long serialVersionUID = -5067618040005609685L;
/*     */     private Set enabledShortNames;
/*     */ 
/*     */     public DeploymentInfoNotificationFilter()
/*     */     {
/* 166 */       this.enabledShortNames = CollectionsFactory.createCopyOnWriteSet();
/*     */     }
/*     */ 
/*     */     public void disableAllShortNames()
/*     */     {
/* 174 */       this.enabledShortNames.clear();
/*     */     }
/*     */ 
/*     */     public void disableShortName(String name)
/*     */     {
/* 184 */       this.enabledShortNames.remove(name);
/*     */     }
/*     */ 
/*     */     public void enableShortName(String name)
/*     */       throws IllegalArgumentException
/*     */     {
/* 195 */       if (name == null)
/*     */       {
/* 197 */         throw new IllegalArgumentException("null shortName");
/*     */       }
/* 199 */       this.enabledShortNames.add(name);
/*     */     }
/*     */ 
/*     */     public Vector getEnabledShortNames()
/*     */     {
/* 212 */       return new Vector(this.enabledShortNames);
/*     */     }
/*     */ 
/*     */     public String toString()
/*     */     {
/* 220 */       StringBuffer sb = new StringBuffer(100);
/*     */ 
/* 222 */       sb.append(getClass().getName()).append(':');
/* 223 */       sb.append(" enabledTypes=").append(getEnabledTypes());
/* 224 */       sb.append(" enabledShortNames=").append(getEnabledShortNames());
/*     */ 
/* 226 */       return sb.toString();
/*     */     }
/*     */ 
/*     */     public boolean isNotificationEnabled(Notification notification)
/*     */     {
/* 241 */       if (!super.isNotificationEnabled(notification))
/*     */       {
/* 243 */         return false;
/*     */       }
/*     */ 
/* 249 */       DeploymentInfo di = (DeploymentInfo)notification.getUserData();
/* 250 */       String shortName = di.shortName;
/*     */ 
/* 253 */       return this.enabledShortNames.contains(shortName);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.filterfactory.DeploymentInfoNotificationFilterFactory
 * JD-Core Version:    0.6.0
 */