/*     */ package org.jboss.system.metadata;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.lang.annotation.Annotation;
/*     */ import org.jboss.annotation.factory.AnnotationCreator;
/*     */ import org.jboss.annotation.factory.ast.TokenMgrError;
/*     */ import org.jboss.util.JBossObject;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ import org.jboss.util.StringPropertyReplacer;
/*     */ 
/*     */ public class ServiceAnnotationMetaData extends JBossObject
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   public String annotation;
/*     */   protected Annotation ann;
/*  48 */   protected boolean replace = true;
/*     */ 
/*     */   public ServiceAnnotationMetaData()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ServiceAnnotationMetaData(String ann)
/*     */   {
/*  64 */     setAnnotation(ann);
/*     */   }
/*     */ 
/*     */   public String getAnnotation()
/*     */   {
/*  69 */     return this.annotation;
/*     */   }
/*     */ 
/*     */   public void setAnnotation(String annotation)
/*     */   {
/*  74 */     this.annotation = annotation;
/*     */   }
/*     */ 
/*     */   public boolean isReplace()
/*     */   {
/*  79 */     return this.replace;
/*     */   }
/*     */ 
/*     */   public void setReplace(boolean replace)
/*     */   {
/*  84 */     this.replace = replace;
/*     */   }
/*     */ 
/*     */   public Annotation getAnnotationInstance()
/*     */   {
/*  89 */     return getAnnotationInstance(null);
/*     */   }
/*     */ 
/*     */   public Annotation getAnnotationInstance(ClassLoader cl)
/*     */   {
/*     */     try
/*     */     {
/*  96 */       String annString = this.annotation;
/*  97 */       if (this.replace)
/*     */       {
/*  99 */         annString = StringPropertyReplacer.replaceProperties(annString);
/*     */       }
/* 101 */       if (cl == null)
/*     */       {
/* 103 */         cl = Thread.currentThread().getContextClassLoader();
/*     */       }
/* 105 */       this.ann = ((Annotation)AnnotationCreator.createAnnotation(annString, cl));
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 109 */       throw new RuntimeException("Error creating annotation for " + this.annotation, e);
/*     */     }
/*     */     catch (TokenMgrError e)
/*     */     {
/* 113 */       throw new RuntimeException("Error creating annotation for " + this.annotation, e);
/*     */     }
/*     */ 
/* 116 */     return this.ann;
/*     */   }
/*     */ 
/*     */   public void toString(JBossStringBuilder buffer)
/*     */   {
/* 121 */     buffer.append("expr=").append(this.ann);
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/* 126 */     buffer.append(this.ann);
/*     */   }
/*     */ 
/*     */   protected int getHashCode()
/*     */   {
/* 131 */     return this.annotation.hashCode();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object object)
/*     */   {
/* 136 */     if ((object == null) || (!(object instanceof ServiceAnnotationMetaData))) {
/* 137 */       return false;
/*     */     }
/* 139 */     ServiceAnnotationMetaData amd = (ServiceAnnotationMetaData)object;
/* 140 */     return (this.replace == amd.replace) && (this.annotation.equals(amd.annotation));
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.metadata.ServiceAnnotationMetaData
 * JD-Core Version:    0.6.0
 */