/*     */ package org.jboss.system.metadata;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import javax.management.MalformedObjectNameException;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.system.microcontainer.LifecycleDependencyItem;
/*     */ import org.jboss.system.microcontainer.ServiceControllerContext;
/*     */ 
/*     */ public class ServiceDependencyMetaData extends AbstractMetaDataVisitorNode
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private String iDependOn;
/*     */   private ObjectName iDependOnObjectName;
/*     */ 
/*     */   public String getIDependOn()
/*     */   {
/*  57 */     if (this.iDependOn == null)
/*  58 */       return this.iDependOnObjectName.getCanonicalName();
/*  59 */     return this.iDependOn;
/*     */   }
/*     */ 
/*     */   public void setIDependOn(String iDependOn)
/*     */   {
/*  69 */     if (iDependOn == null)
/*  70 */       throw new IllegalArgumentException("Null iDependOn");
/*  71 */     this.iDependOn = iDependOn;
/*  72 */     this.iDependOnObjectName = null;
/*     */   }
/*     */ 
/*     */   public ObjectName getIDependOnObjectName()
/*     */     throws MalformedObjectNameException
/*     */   {
/*  83 */     if (this.iDependOnObjectName == null)
/*     */     {
/*  85 */       if (this.iDependOn.trim().length() == 0)
/*  86 */         throw new MalformedObjectNameException("Missing object name in depends");
/*  87 */       ObjectName objectName = new ObjectName(this.iDependOn);
/*  88 */       if (objectName.isPattern())
/*  89 */         throw new MalformedObjectNameException("ObjectName patterns are not allowed in depends: " + this.iDependOn);
/*  90 */       this.iDependOnObjectName = objectName;
/*  91 */       this.iDependOn = null;
/*     */     }
/*  93 */     return this.iDependOnObjectName;
/*     */   }
/*     */ 
/*     */   public void setIDependOnObjectName(ObjectName iDependOn)
/*     */   {
/* 103 */     if (iDependOn == null)
/* 104 */       throw new IllegalArgumentException("Null iDependOn");
/* 105 */     this.iDependOnObjectName = iDependOn;
/*     */   }
/*     */ 
/*     */   public void visit(ServiceMetaDataVisitor visitor)
/*     */   {
/* 110 */     ServiceControllerContext context = visitor.getControllerContext();
/* 111 */     Object name = context.getName();
/* 112 */     Object other = this.iDependOn;
/*     */     try
/*     */     {
/* 115 */       other = getIDependOnObjectName().getCanonicalName();
/*     */     }
/*     */     catch (MalformedObjectNameException ignored)
/*     */     {
/*     */     }
/* 120 */     visitor.addDependency(new LifecycleDependencyItem(name, other, ControllerState.CREATE));
/* 121 */     visitor.addDependency(new LifecycleDependencyItem(name, other, ControllerState.START));
/* 122 */     visitor.visit(this);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.metadata.ServiceDependencyMetaData
 * JD-Core Version:    0.6.0
 */