/*     */ package org.jboss.system.metadata;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.dependency.spi.ControllerMode;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.StringPropertyReplacer;
/*     */ import org.w3c.dom.Attr;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ import org.w3c.dom.Text;
/*     */ 
/*     */ public class ServiceMetaDataParser
/*     */ {
/*  56 */   private static final Logger log = Logger.getLogger(ServiceMetaDataParser.class);
/*     */   private Element config;
/*     */   private ControllerMode serverMode;
/*     */ 
/*     */   public ServiceMetaDataParser(Element config)
/*     */   {
/*  71 */     if (config == null) {
/*  72 */       throw new IllegalArgumentException("Null config");
/*     */     }
/*  74 */     this.config = config;
/*     */   }
/*     */ 
/*     */   public List<ServiceMetaData> parse()
/*     */     throws DeploymentException
/*     */   {
/*  85 */     List services = new ArrayList();
/*     */     try
/*     */     {
/*  89 */       String tagName = this.config.getTagName();
/*  90 */       if ("mbean".equals(tagName)) {
/*  91 */         internalParse(services, this.config, true);
/*     */       }
/*     */       else {
/*  94 */         if ("server".equals(tagName)) {
/*  95 */           parseServer(this.config);
/*     */         }
/*  97 */         NodeList nl = this.config.getChildNodes();
/*     */ 
/*  99 */         for (int i = 0; i < nl.getLength(); i++)
/*     */         {
/* 101 */           if (nl.item(i).getNodeType() != 1)
/*     */             continue;
/* 103 */           Element element = (Element)nl.item(i);
/* 104 */           if (!"mbean".equals(element.getTagName()))
/*     */             continue;
/* 106 */           Element mbean = (Element)nl.item(i);
/* 107 */           internalParse(services, mbean, true);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 115 */       DeploymentException.rethrowAsDeploymentException("Unable to parse service configuration", t);
/*     */     }
/*     */ 
/* 118 */     return services;
/*     */   }
/*     */ 
/*     */   private void parseServer(Element serverElement)
/*     */     throws Exception
/*     */   {
/* 129 */     String modeString = serverElement.getAttribute("mode");
/* 130 */     if (modeString != null)
/*     */     {
/* 132 */       modeString = modeString.trim();
/* 133 */       if (modeString.length() != 0)
/* 134 */         this.serverMode = new ControllerMode(modeString);
/*     */     }
/*     */   }
/*     */ 
/*     */   private ObjectName internalParse(List<ServiceMetaData> services, Element mbeanElement, boolean replace)
/*     */     throws Exception
/*     */   {
/* 149 */     ServiceMetaData service = new ServiceMetaData();
/*     */ 
/* 151 */     ObjectName mbeanName = parseObjectName(mbeanElement, replace);
/* 152 */     service.setObjectName(mbeanName);
/*     */ 
/* 154 */     String code = parseCode(mbeanName, mbeanElement);
/* 155 */     service.setCode(code);
/*     */ 
/* 157 */     ControllerMode mode = parseMode(mbeanName, mbeanElement);
/* 158 */     if (mode == null)
/* 159 */       mode = this.serverMode;
/* 160 */     service.setMode(mode);
/*     */ 
/* 162 */     ServiceConstructorMetaData constructor = parseConstructor(mbeanName, mbeanElement, replace);
/* 163 */     service.setConstructor(constructor);
/*     */ 
/* 165 */     String interfaceName = parseInterface(mbeanName, mbeanElement);
/* 166 */     service.setInterfaceName(interfaceName);
/*     */ 
/* 168 */     String xmbeandd = parseXMBeanDD(mbeanName, mbeanElement);
/* 169 */     service.setXMBeanDD(xmbeandd);
/*     */ 
/* 171 */     String xmbeanCode = parseXMBeanCode(mbeanName, mbeanElement);
/* 172 */     service.setXMBeanCode(xmbeanCode);
/*     */ 
/* 174 */     if ((xmbeandd != null) && (xmbeandd.length() == 0))
/*     */     {
/* 176 */       Element xmbeanDescriptor = parseXMBeanDescriptor(mbeanName, mbeanElement);
/* 177 */       service.setXMBeanDescriptor(xmbeanDescriptor);
/*     */     }
/* 179 */     List annotations = new ArrayList();
/* 180 */     List attributes = new ArrayList();
/* 181 */     List dependencies = new ArrayList();
/*     */ 
/* 183 */     NodeList attrs = mbeanElement.getChildNodes();
/* 184 */     for (int j = 0; j < attrs.getLength(); j++)
/*     */     {
/* 187 */       if (attrs.item(j).getNodeType() != 1) {
/*     */         continue;
/*     */       }
/* 190 */       Element element = (Element)attrs.item(j);
/*     */ 
/* 192 */       boolean replaceAttribute = true;
/*     */ 
/* 195 */       if (element.getTagName().equals("attribute"))
/*     */       {
/* 197 */         String attributeName = element.getAttribute("name");
/* 198 */         if (attributeName == null)
/* 199 */           throw new DeploymentException("No attribute name for " + mbeanName);
/* 200 */         boolean trim = true;
/* 201 */         String replaceAttr = element.getAttribute("replace");
/* 202 */         if (replaceAttr.length() > 0)
/* 203 */           replaceAttribute = Boolean.valueOf(replaceAttr).booleanValue();
/* 204 */         String trimAttr = element.getAttribute("trim");
/* 205 */         if (trimAttr.length() > 0)
/* 206 */           trim = Boolean.valueOf(trimAttr).booleanValue();
/* 207 */         String serialDataType = element.getAttribute("serialDataType");
/*     */ 
/* 209 */         if (element.hasChildNodes())
/*     */         {
/* 212 */           ServiceValueMetaData value = null;
/* 213 */           if (serialDataType.equals("javaBean"))
/*     */           {
/* 215 */             value = new ServiceJavaBeanValueMetaData(element);
/*     */           }
/* 217 */           else if (serialDataType.equals("jbxb"))
/*     */           {
/* 219 */             value = new ServiceJBXBValueMetaData(element);
/*     */           }
/*     */           else
/*     */           {
/* 223 */             NodeList nl = element.getChildNodes();
/* 224 */             for (int i = 0; i < nl.getLength(); i++)
/*     */             {
/* 226 */               Node n = nl.item(i);
/* 227 */               if (n.getNodeType() != 1)
/*     */                 continue;
/* 229 */               Element el = (Element)n;
/* 230 */               String tagName = el.getTagName();
/* 231 */               if ("inject".equals(tagName))
/*     */               {
/* 233 */                 String dependency = el.getAttribute("bean");
/* 234 */                 String property = null;
/* 235 */                 Attr attr = el.getAttributeNode("property");
/* 236 */                 if (attr != null)
/* 237 */                   property = attr.getValue();
/* 238 */                 ControllerState requiredState = ControllerState.INSTALLED;
/* 239 */                 attr = el.getAttributeNode("state");
/* 240 */                 if (attr != null)
/* 241 */                   requiredState = new ControllerState(attr.getValue());
/* 242 */                 value = new ServiceInjectionValueMetaData(dependency, property, requiredState);
/* 243 */                 break;
/*     */               }
/*     */ 
/* 246 */               value = new ServiceElementValueMetaData((Element)n);
/*     */ 
/* 248 */               break;
/*     */             }
/*     */ 
/* 251 */             if (value == null) {
/* 252 */               value = new ServiceTextValueMetaData(getElementTextContent(element, trim, replaceAttribute));
/*     */             }
/*     */           }
/* 255 */           ServiceAttributeMetaData attribute = new ServiceAttributeMetaData();
/* 256 */           attribute.setName(attributeName);
/* 257 */           attribute.setReplace(replaceAttribute);
/* 258 */           attribute.setTrim(trim);
/* 259 */           attribute.setValue(value);
/* 260 */           attributes.add(attribute);
/*     */         }
/*     */       }
/* 263 */       else if (element.getTagName().equals("depends"))
/*     */       {
/* 265 */         String mbeanRefName = element.getAttribute("optional-attribute-name");
/* 266 */         if ("".equals(mbeanRefName))
/* 267 */           mbeanRefName = null;
/*     */         else {
/* 269 */           mbeanRefName = StringPropertyReplacer.replaceProperties(mbeanRefName);
/*     */         }
/* 271 */         String proxyType = element.getAttribute("proxy-type");
/* 272 */         if ("".equals(proxyType))
/* 273 */           proxyType = null;
/*     */         else {
/* 275 */           proxyType = StringPropertyReplacer.replaceProperties(proxyType);
/*     */         }
/*     */ 
/* 278 */         String dependsObjectName = processDependency(mbeanName, mbeanRefName, element, services, replace);
/*     */ 
/* 280 */         if (mbeanRefName != null)
/*     */         {
/* 282 */           ServiceValueMetaData value = new ServiceDependencyValueMetaData(dependsObjectName, proxyType);
/* 283 */           ServiceAttributeMetaData attribute = new ServiceAttributeMetaData();
/* 284 */           attribute.setName(mbeanRefName);
/* 285 */           attribute.setValue(value);
/* 286 */           attributes.add(attribute);
/*     */         }
/*     */         else
/*     */         {
/* 290 */           ServiceDependencyMetaData dependency = new ServiceDependencyMetaData();
/* 291 */           dependency.setIDependOn(dependsObjectName);
/* 292 */           dependencies.add(dependency);
/*     */         }
/*     */       }
/* 295 */       else if (element.getTagName().equals("depends-list"))
/*     */       {
/* 297 */         String dependsListName = element.getAttribute("optional-attribute-name");
/* 298 */         if ("".equals(dependsListName)) {
/* 299 */           dependsListName = null;
/*     */         }
/* 301 */         NodeList dependsList = element.getChildNodes();
/* 302 */         ArrayList dependsListNames = new ArrayList();
/* 303 */         for (int l = 0; l < dependsList.getLength(); l++)
/*     */         {
/* 305 */           if (dependsList.item(l).getNodeType() != 1) {
/*     */             continue;
/*     */           }
/* 308 */           Element dependsElement = (Element)dependsList.item(l);
/* 309 */           if (!dependsElement.getTagName().equals("depends-list-element")) {
/*     */             continue;
/*     */           }
/* 312 */           String dependsObjectName = processDependency(mbeanName, dependsListName, dependsElement, services, replace);
/* 313 */           if (!dependsListNames.contains(dependsObjectName)) {
/* 314 */             dependsListNames.add(dependsObjectName);
/*     */           }
/* 316 */           if (dependsListName != null)
/*     */             continue;
/* 318 */           ServiceDependencyMetaData dependency = new ServiceDependencyMetaData();
/* 319 */           dependency.setIDependOn(dependsObjectName);
/* 320 */           dependencies.add(dependency);
/*     */         }
/*     */ 
/* 324 */         if (dependsListName != null)
/*     */         {
/* 326 */           ServiceValueMetaData value = new ServiceDependencyListValueMetaData(dependsListNames);
/* 327 */           ServiceAttributeMetaData attribute = new ServiceAttributeMetaData();
/* 328 */           attribute.setName(dependsListName);
/* 329 */           attribute.setValue(value);
/* 330 */           attributes.add(attribute);
/*     */         }
/*     */       }
/* 333 */       else if (element.getTagName().equals("alias"))
/*     */       {
/* 335 */         List aliases = service.getAliases();
/* 336 */         if (aliases == null)
/*     */         {
/* 338 */           aliases = new ArrayList();
/* 339 */           service.setAliases(aliases);
/*     */         }
/* 341 */         aliases.add(getElementTextContent(element, true, true));
/*     */       } else {
/* 343 */         if (!element.getTagName().equals("annotation"))
/*     */           continue;
/* 345 */         String ann = getElementTextContent(element, true, true);
/* 346 */         ServiceAnnotationMetaData amd = new ServiceAnnotationMetaData(ann);
/* 347 */         annotations.add(amd);
/*     */       }
/*     */     }
/*     */ 
/* 351 */     service.setAttributes(attributes);
/* 352 */     service.setDependencies(dependencies);
/* 353 */     service.setAnnotations(annotations);
/*     */ 
/* 355 */     services.add(service);
/*     */ 
/* 357 */     return mbeanName;
/*     */   }
/*     */ 
/*     */   private ObjectName parseObjectName(Element mbeanElement, boolean replace)
/*     */     throws Exception
/*     */   {
/* 369 */     String name = mbeanElement.getAttribute("name");
/*     */ 
/* 371 */     if ((name == null) || (name.trim().length() == 0)) {
/* 372 */       throw new DeploymentException("Missing or empty 'name' attribute for mbean.");
/*     */     }
/* 374 */     if (replace) {
/* 375 */       name = StringPropertyReplacer.replaceProperties(name);
/*     */     }
/* 377 */     return new ObjectName(name);
/*     */   }
/*     */ 
/*     */   private String parseCode(ObjectName name, Element mbeanElement)
/*     */     throws Exception
/*     */   {
/* 390 */     return mbeanElement.getAttribute("code");
/*     */   }
/*     */ 
/*     */   private ControllerMode parseMode(ObjectName name, Element mbeanElement)
/*     */     throws Exception
/*     */   {
/* 403 */     String modeString = mbeanElement.getAttribute("mode");
/* 404 */     if (modeString == null)
/* 405 */       return null;
/* 406 */     modeString = modeString.trim();
/* 407 */     if (modeString.length() == 0)
/* 408 */       return null;
/* 409 */     return new ControllerMode(modeString);
/*     */   }
/*     */ 
/*     */   private ServiceConstructorMetaData parseConstructor(ObjectName name, Element mbeanElement, boolean replace)
/*     */     throws Exception
/*     */   {
/* 423 */     ServiceConstructorMetaData result = new ServiceConstructorMetaData();
/*     */ 
/* 425 */     NodeList list = mbeanElement.getElementsByTagName("constructor");
/* 426 */     if ((list.getLength() > 1) && (list.item(0).getParentNode() == mbeanElement)) {
/* 427 */       throw new DeploymentException("only one <constructor> element may be defined for " + name);
/*     */     }
/* 429 */     if (list.getLength() == 1)
/*     */     {
/* 431 */       Element element = (Element)list.item(0);
/*     */ 
/* 434 */       list = element.getElementsByTagName("arg");
/* 435 */       int length = list.getLength();
/* 436 */       String[] params = new String[length];
/* 437 */       String[] signature = new String[length];
/*     */ 
/* 440 */       for (int j = 0; j < length; j++)
/*     */       {
/* 442 */         Element arg = (Element)list.item(j);
/* 443 */         String typeName = null;
/* 444 */         Attr attr = arg.getAttributeNode("type");
/* 445 */         if (attr != null)
/* 446 */           typeName = attr.getValue();
/* 447 */         String value = null;
/* 448 */         attr = arg.getAttributeNode("value");
/* 449 */         if (attr != null)
/* 450 */           value = attr.getValue();
/* 451 */         signature[j] = typeName;
/* 452 */         params[j] = value;
/*     */       }
/*     */ 
/* 455 */       result.setParams(params);
/* 456 */       result.setSignature(signature);
/*     */     }
/*     */ 
/* 459 */     return result;
/*     */   }
/*     */ 
/*     */   private String parseInterface(ObjectName name, Element mbeanElement)
/*     */     throws Exception
/*     */   {
/* 472 */     Attr attr = mbeanElement.getAttributeNode("interface");
/* 473 */     if (attr != null) {
/* 474 */       return attr.getValue();
/*     */     }
/* 476 */     return null;
/*     */   }
/*     */ 
/*     */   private String parseXMBeanDD(ObjectName name, Element mbeanElement)
/*     */     throws Exception
/*     */   {
/* 489 */     Attr attr = mbeanElement.getAttributeNode("xmbean-dd");
/* 490 */     if (attr != null) {
/* 491 */       return attr.getValue();
/*     */     }
/* 493 */     return null;
/*     */   }
/*     */ 
/*     */   private String parseXMBeanCode(ObjectName name, Element mbeanElement)
/*     */     throws Exception
/*     */   {
/* 506 */     Attr attr = mbeanElement.getAttributeNode("xmbean-code");
/* 507 */     if (attr != null) {
/* 508 */       return attr.getValue();
/*     */     }
/* 510 */     return "org.jboss.mx.modelmbean.XMBean";
/*     */   }
/*     */ 
/*     */   private Element parseXMBeanDescriptor(ObjectName name, Element mbeanElement)
/*     */     throws Exception
/*     */   {
/* 523 */     NodeList mbeans = mbeanElement.getElementsByTagName("xmbean");
/* 524 */     if (mbeans.getLength() == 0)
/* 525 */       throw new DeploymentException("No nested mbean element given for xmbean for " + name);
/* 526 */     return (Element)mbeans.item(0);
/*     */   }
/*     */ 
/*     */   private String processDependency(ObjectName mbeanName, String attributeName, Element element, List<ServiceMetaData> services, boolean replace)
/*     */     throws Exception
/*     */   {
/* 542 */     String dependsObjectName = null;
/*     */ 
/* 544 */     NodeList nl = element.getChildNodes();
/* 545 */     for (int i = 0; i < nl.getLength(); i++)
/*     */     {
/* 547 */       Node childNode = nl.item(i);
/* 548 */       if (childNode.getNodeType() != 1)
/*     */         continue;
/* 550 */       Element child = (Element)childNode;
/* 551 */       String tagName = child.getTagName();
/* 552 */       if ("mbean".equals(tagName))
/*     */       {
/* 554 */         dependsObjectName = internalParse(services, child, replace).getCanonicalName();
/* 555 */         break;
/*     */       }
/*     */ 
/* 559 */       if (attributeName != null)
/* 560 */         log.warn("Non mbean child <" + tagName + "/> in depends tag for " + mbeanName + " attribute: " + attributeName);
/*     */       else {
/* 562 */         log.warn("Non mbean child <" + tagName + "/> in depends tag for " + mbeanName);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 567 */     if (dependsObjectName == null) {
/* 568 */       dependsObjectName = getElementTextContent(element, true, replace);
/*     */     }
/* 570 */     return dependsObjectName;
/*     */   }
/*     */ 
/*     */   public static String getElementTextContent(Element element, boolean trim, boolean replace)
/*     */     throws Exception
/*     */   {
/* 584 */     NodeList nl = element.getChildNodes();
/* 585 */     String attributeText = "";
/* 586 */     for (int i = 0; i < nl.getLength(); i++)
/*     */     {
/* 588 */       Node n = nl.item(i);
/* 589 */       if (!(n instanceof Text))
/*     */         continue;
/* 591 */       attributeText = attributeText + ((Text)n).getData();
/*     */     }
/*     */ 
/* 594 */     if (trim)
/* 595 */       attributeText = attributeText.trim();
/* 596 */     if (replace)
/* 597 */       attributeText = StringPropertyReplacer.replaceProperties(attributeText);
/* 598 */     return attributeText;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.metadata.ServiceMetaDataParser
 * JD-Core Version:    0.6.0
 */