/*     */ package org.jboss.system.metadata;
/*     */ 
/*     */ import java.beans.PropertyEditor;
/*     */ import java.beans.PropertyEditorManager;
/*     */ import java.io.Serializable;
/*     */ import javax.management.MBeanAttributeInfo;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.util.Classes;
/*     */ import org.jboss.util.propertyeditor.PropertyEditors;
/*     */ 
/*     */ public class ServiceTextValueMetaData extends AbstractMetaDataVisitorNode
/*     */   implements ServiceValueMetaData, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private String text;
/*     */ 
/*     */   public ServiceTextValueMetaData(String text)
/*     */   {
/*  73 */     setText(text);
/*     */   }
/*     */ 
/*     */   public String getText()
/*     */   {
/*  83 */     return this.text;
/*     */   }
/*     */ 
/*     */   public void setText(String text)
/*     */   {
/*  93 */     if (text == null)
/*  94 */       throw new IllegalArgumentException("Null text");
/*  95 */     this.text = text;
/*     */   }
/*     */ 
/*     */   public Object getValue(ServiceValueContext valueContext) throws Exception
/*     */   {
/* 100 */     MBeanAttributeInfo attributeInfo = valueContext.getAttributeInfo();
/* 101 */     ClassLoader cl = valueContext.getClassloader();
/*     */ 
/* 103 */     String typeName = attributeInfo.getType();
/* 104 */     if (typeName == null) {
/* 105 */       throw new DeploymentException("AttributeInfo for " + attributeInfo.getName() + " has no type");
/*     */     }
/*     */ 
/* 108 */     Class typeClass = Classes.getPrimitiveTypeForName(typeName);
/* 109 */     if (typeClass == null)
/*     */     {
/*     */       try
/*     */       {
/* 114 */         typeClass = cl.loadClass(typeName);
/*     */       }
/*     */       catch (ClassNotFoundException e)
/*     */       {
/* 118 */         throw new DeploymentException("Class not found for attribute: " + attributeInfo.getName(), e);
/*     */       }
/*     */     }
/*     */ 
/* 122 */     PropertyEditor editor = PropertyEditorManager.findEditor(typeClass);
/* 123 */     if (editor == null) {
/* 124 */       throw new DeploymentException("No property editor for attribute: " + attributeInfo.getName() + "; type=" + typeClass.getName());
/*     */     }
/*     */ 
/* 128 */     ClassLoader tcl = Thread.currentThread().getContextClassLoader();
/* 129 */     Thread.currentThread().setContextClassLoader(cl);
/*     */     try
/*     */     {
/* 132 */       editor.setAsText(this.text);
/* 133 */       localObject1 = editor.getValue();
/*     */     }
/*     */     finally
/*     */     {
/*     */       Object localObject1;
/* 137 */       Thread.currentThread().setContextClassLoader(tcl);
/*     */     }
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  56 */       PropertyEditors.init();
/*     */     }
/*     */     catch (Exception ignored)
/*     */     {
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.metadata.ServiceTextValueMetaData
 * JD-Core Version:    0.6.0
 */