/*     */ package org.jboss.system.microcontainer;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.Iterator;
/*     */ import javax.management.Attribute;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.dependency.plugins.AbstractControllerContext;
/*     */ import org.jboss.dependency.spi.Controller;
/*     */ import org.jboss.dependency.spi.ControllerMode;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.dependency.spi.DependencyInfo;
/*     */ import org.jboss.dependency.spi.DependencyItem;
/*     */ import org.jboss.dependency.spi.dispatch.InvokeDispatchContext;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.system.Service;
/*     */ import org.jboss.system.ServiceContext;
/*     */ import org.jboss.system.ServiceController;
/*     */ import org.jboss.system.metadata.ServiceMetaData;
/*     */ import org.jboss.system.metadata.ServiceMetaDataVisitor;
/*     */ import org.jboss.system.metadata.ServiceMetaDataVisitorNode;
/*     */ 
/*     */ public class ServiceControllerContext extends AbstractControllerContext
/*     */   implements InvokeDispatchContext
/*     */ {
/*     */   private ObjectName objectName;
/*     */   private ServiceController serviceController;
/*     */   private ServiceMetaData serviceMetaData;
/*  63 */   private ServiceContext serviceContext = new ServiceContext();
/*     */ 
/*     */   public ServiceControllerContext(ServiceController serviceController, ObjectName name)
/*     */   {
/*  73 */     super(name.getCanonicalName(), ServiceControllerContextActions.getLifecycleOnly());
/*  74 */     this.objectName = name;
/*  75 */     this.serviceContext.objectName = this.objectName;
/*  76 */     this.serviceController = serviceController;
/*  77 */     setMode(ControllerMode.MANUAL);
/*     */   }
/*     */ 
/*     */   public ServiceControllerContext(ServiceController serviceController, ServiceMetaData metaData)
/*     */   {
/*  88 */     super(metaData.getObjectName().getCanonicalName(), ServiceControllerContextActions.getInstance());
/*  89 */     this.objectName = metaData.getObjectName();
/*  90 */     this.serviceContext.objectName = this.objectName;
/*  91 */     this.serviceController = serviceController;
/*  92 */     ControllerMode mode = metaData.getMode();
/*  93 */     this.serviceMetaData = metaData;
/*  94 */     if (mode == null)
/*  95 */       setMode(ControllerMode.MANUAL);
/*     */     else
/*  97 */       setMode(mode);
/*     */   }
/*     */ 
/*     */   public ServiceControllerContext(ServiceController serviceController, ObjectName name, Object target)
/*     */   {
/* 109 */     super(name.getCanonicalName(), ServiceControllerContextActions.getInstance());
/* 110 */     this.objectName = name;
/* 111 */     this.serviceContext.objectName = this.objectName;
/* 112 */     this.serviceController = serviceController;
/* 113 */     setTarget(target);
/* 114 */     setMode(ControllerMode.MANUAL);
/*     */   }
/*     */ 
/*     */   private MBeanServer getMBeanServer()
/*     */   {
/* 119 */     MBeanServer server = this.serviceController.getMBeanServer();
/* 120 */     if (server == null)
/*     */     {
/* 122 */       throw new IllegalStateException("MBeanServer not available.");
/*     */     }
/* 124 */     return server;
/*     */   }
/*     */ 
/*     */   protected static String getAttributeName(String name)
/*     */   {
/* 129 */     if ((name == null) || (name.length() == 0)) {
/* 130 */       throw new IllegalArgumentException("Illegal name: " + name);
/*     */     }
/* 132 */     char firstCharacter = name.charAt(0);
/* 133 */     if (Character.isLowerCase(firstCharacter))
/*     */     {
/* 135 */       String attributeName = String.valueOf(Character.toUpperCase(firstCharacter));
/* 136 */       if (name.length() > 1)
/* 137 */         attributeName = attributeName + name.substring(1);
/* 138 */       return attributeName;
/*     */     }
/* 140 */     return name;
/*     */   }
/*     */ 
/*     */   public Object get(String name) throws Throwable
/*     */   {
/* 145 */     return getMBeanServer().getAttribute(this.objectName, getAttributeName(name));
/*     */   }
/*     */ 
/*     */   public void set(String name, Object value) throws Throwable
/*     */   {
/* 150 */     Attribute attribute = new Attribute(getAttributeName(name), value);
/* 151 */     getMBeanServer().setAttribute(this.objectName, attribute);
/*     */   }
/*     */ 
/*     */   public Object invoke(String name, Object[] parameters, String[] signature) throws Throwable
/*     */   {
/* 156 */     return getMBeanServer().invoke(this.objectName, name, parameters, signature);
/*     */   }
/*     */ 
/*     */   public ClassLoader getClassLoader() throws Throwable
/*     */   {
/* 161 */     if (this.serviceMetaData != null)
/*     */     {
/* 163 */       return getMBeanServer().getClassLoader(this.serviceMetaData.getClassLoaderName());
/*     */     }
/*     */ 
/* 167 */     return getMBeanServer().getClassLoaderFor(this.objectName);
/*     */   }
/*     */ 
/*     */   public ObjectName getObjectName()
/*     */   {
/* 178 */     return this.objectName;
/*     */   }
/*     */ 
/*     */   public ServiceMetaData getServiceMetaData()
/*     */   {
/* 188 */     return this.serviceMetaData;
/*     */   }
/*     */ 
/*     */   public void setServiceMetaData(ServiceMetaData serviceMetaData)
/*     */   {
/* 198 */     this.serviceMetaData = serviceMetaData;
/*     */   }
/*     */ 
/*     */   public ServiceController getServiceController()
/*     */   {
/* 208 */     return this.serviceController;
/*     */   }
/*     */ 
/*     */   public Service getServiceProxy()
/*     */     throws Exception
/*     */   {
/* 219 */     if (this.serviceContext.proxy != null) {
/* 220 */       return this.serviceContext.proxy;
/*     */     }
/* 222 */     MBeanServer server = this.serviceController.getMBeanServer();
/* 223 */     if (server != null) {
/* 224 */       this.serviceContext.proxy = ServiceProxy.getServiceProxy(this.objectName, server);
/*     */     }
/* 226 */     return this.serviceContext.proxy;
/*     */   }
/*     */ 
/*     */   public ServiceContext getServiceContext()
/*     */   {
/*     */     try
/*     */     {
/* 238 */       this.serviceContext.proxy = getServiceProxy();
/*     */     }
/*     */     catch (Exception ignored)
/*     */     {
/*     */     }
/* 243 */     if (getError() != null)
/* 244 */       this.serviceContext.setProblem(getError());
/* 245 */     if (getState() == ControllerState.ERROR)
/* 246 */       this.serviceContext.state = 4;
/* 247 */     return this.serviceContext;
/*     */   }
/*     */ 
/*     */   public void install(ControllerState fromState, ControllerState toState)
/*     */     throws Throwable
/*     */   {
/*     */     try
/*     */     {
/* 255 */       super.install(fromState, toState);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 259 */       this.serviceContext.setProblem(t);
/* 260 */       this.serviceContext.state = 4;
/* 261 */       throw t;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setController(Controller controller)
/*     */   {
/* 270 */     super.setController(controller);
/* 271 */     if (controller != null)
/*     */     {
/* 273 */       preprocessMetaData();
/* 274 */       this.serviceContext.state = 0;
/*     */     }
/*     */     else {
/* 277 */       this.serviceContext.state = 7;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void preprocessMetaData()
/*     */   {
/* 285 */     if (this.serviceMetaData == null)
/* 286 */       return;
/* 287 */     PreprocessMetaDataVisitor visitor = new PreprocessMetaDataVisitor();
/* 288 */     AccessController.doPrivileged(visitor);
/*     */   }
/*     */ 
/*     */   protected class PreprocessMetaDataVisitor
/*     */     implements ServiceMetaDataVisitor, PrivilegedAction<Object>
/*     */   {
/* 297 */     private ControllerState contextState = ControllerState.INSTANTIATED;
/*     */ 
/*     */     protected PreprocessMetaDataVisitor()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object run() {
/* 304 */       ServiceControllerContext.this.serviceMetaData.visit(this);
/* 305 */       return null;
/*     */     }
/*     */ 
/*     */     public void visit(ServiceMetaDataVisitorNode node)
/*     */     {
/* 315 */       boolean trace = ServiceControllerContext.this.log.isTraceEnabled();
/* 316 */       if (trace) {
/* 317 */         ServiceControllerContext.this.log.trace("Visit node " + node);
/*     */       }
/*     */ 
/* 320 */       Iterator children = node.getChildren();
/* 321 */       if (children != null)
/*     */       {
/* 323 */         ControllerState restoreState = this.contextState;
/* 324 */         while (children.hasNext())
/*     */         {
/* 326 */           ServiceMetaDataVisitorNode child = (ServiceMetaDataVisitorNode)children.next();
/*     */           try
/*     */           {
/* 329 */             child.visit(this);
/*     */           }
/*     */           finally
/*     */           {
/* 333 */             this.contextState = restoreState;
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*     */     public ServiceControllerContext getControllerContext()
/*     */     {
/* 341 */       return ServiceControllerContext.this;
/*     */     }
/*     */ 
/*     */     public ControllerState getContextState()
/*     */     {
/* 346 */       return this.contextState;
/*     */     }
/*     */ 
/*     */     public void addDependency(DependencyItem dependency)
/*     */     {
/* 351 */       ServiceControllerContext.this.getDependencyInfo().addIDependOn(dependency);
/*     */     }
/*     */ 
/*     */     public void setContextState(ControllerState contextState)
/*     */     {
/* 356 */       this.contextState = contextState;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.microcontainer.ServiceControllerContext
 * JD-Core Version:    0.6.0
 */