/*    */ package org.jboss.system.microcontainer;
/*    */ 
/*    */ import java.util.HashMap;
/*    */ import java.util.Map;
/*    */ import org.jboss.dependency.plugins.AbstractControllerContextActions;
/*    */ import org.jboss.dependency.plugins.action.ControllerContextAction;
/*    */ import org.jboss.dependency.spi.ControllerState;
/*    */ 
/*    */ public class ServiceControllerContextActions extends AbstractControllerContextActions
/*    */ {
/*    */   private static ServiceControllerContextActions instance;
/*    */   private static ServiceControllerContextActions lifecycleOnly;
/*    */ 
/*    */   public static ServiceControllerContextActions getInstance()
/*    */   {
/* 51 */     if (instance == null)
/*    */     {
/* 53 */       Map actions = new HashMap();
/* 54 */       actions.put(ControllerState.DESCRIBED, new DescribeAction());
/* 55 */       actions.put(ControllerState.INSTANTIATED, new InstantiateAction());
/* 56 */       actions.put(ControllerState.CONFIGURED, new ConfigureAction());
/* 57 */       actions.put(ControllerState.CREATE, new CreateDestroyLifecycleAction());
/* 58 */       actions.put(ControllerState.START, new StartStopLifecycleAction());
/* 59 */       actions.put(ControllerState.INSTALLED, new InstallAction());
/* 60 */       instance = new ServiceControllerContextActions(actions);
/*    */     }
/* 62 */     return instance;
/*    */   }
/*    */ 
/*    */   public static ServiceControllerContextActions getLifecycleOnly()
/*    */   {
/* 72 */     if (lifecycleOnly == null)
/*    */     {
/* 74 */       Map actions = new HashMap();
/* 75 */       actions.put(ControllerState.INSTANTIATED, new OnlyUnregisterAction());
/* 76 */       actions.put(ControllerState.CREATE, new CreateDestroyLifecycleAction());
/* 77 */       actions.put(ControllerState.START, new StartStopLifecycleAction());
/* 78 */       lifecycleOnly = new ServiceControllerContextActions(actions);
/*    */     }
/* 80 */     return lifecycleOnly;
/*    */   }
/*    */ 
/*    */   protected ServiceControllerContextActions(Map<ControllerState, ControllerContextAction> actions)
/*    */   {
/* 91 */     super(actions);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.microcontainer.ServiceControllerContextActions
 * JD-Core Version:    0.6.0
 */