/*    */ package org.jboss.system.microcontainer;
/*    */ 
/*    */ import javax.management.ObjectName;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.system.Service;
/*    */ import org.jboss.system.ServiceController;
/*    */ 
/*    */ public class StartStopLifecycleAction extends ServiceControllerContextAction
/*    */ {
/*    */   public void installAction(ServiceControllerContext context)
/*    */     throws Throwable
/*    */   {
/* 41 */     Service service = context.getServiceProxy();
/* 42 */     service.start();
/*    */ 
/* 44 */     context.getServiceContext().state = 3;
/*    */ 
/* 46 */     ObjectName objectName = context.getObjectName();
/* 47 */     ServiceController serviceController = context.getServiceController();
/* 48 */     serviceController.sendControllerNotification("org.jboss.system.ServiceMBean.start", objectName);
/*    */   }
/*    */ 
/*    */   public void uninstallAction(ServiceControllerContext context)
/*    */   {
/*    */     try
/*    */     {
/* 55 */       Service service = context.getServiceProxy();
/* 56 */       service.stop();
/*    */ 
/* 58 */       context.getServiceContext().state = 5;
/*    */ 
/* 60 */       ObjectName objectName = context.getObjectName();
/* 61 */       ServiceController serviceController = context.getServiceController();
/* 62 */       serviceController.sendControllerNotification("org.jboss.system.ServiceMBean.stop", objectName);
/*    */     }
/*    */     catch (Throwable t)
/*    */     {
/* 66 */       this.log.debug("Error during stop for " + context.getObjectName(), t);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.microcontainer.StartStopLifecycleAction
 * JD-Core Version:    0.6.0
 */