/*     */ package org.jboss.system.pm;
/*     */ 
/*     */ import java.beans.PropertyEditor;
/*     */ import java.beans.PropertyEditorManager;
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.File;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.FileOutputStream;
/*     */ import java.io.FilenameFilter;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.ObjectStreamClass;
/*     */ import java.io.OutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.net.URL;
/*     */ import java.text.SimpleDateFormat;
/*     */ import java.util.Collections;
/*     */ import java.util.Date;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.management.Attribute;
/*     */ import javax.management.AttributeList;
/*     */ import javax.xml.parsers.DocumentBuilder;
/*     */ import javax.xml.parsers.DocumentBuilderFactory;
/*     */ import javax.xml.transform.Result;
/*     */ import javax.xml.transform.Source;
/*     */ import javax.xml.transform.Transformer;
/*     */ import javax.xml.transform.TransformerFactory;
/*     */ import javax.xml.transform.dom.DOMSource;
/*     */ import javax.xml.transform.stream.StreamResult;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.persistence.AttributePersistenceManager;
/*     */ import org.jboss.system.server.ServerConfig;
/*     */ import org.jboss.system.server.ServerConfigLocator;
/*     */ import org.jboss.util.Classes;
/*     */ import org.jboss.util.file.Files;
/*     */ import org.w3c.dom.Comment;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ import org.w3c.dom.Text;
/*     */ 
/*     */ public class XMLAttributePersistenceManager
/*     */   implements AttributePersistenceManager
/*     */ {
/*     */   public static final String DATA_DIR_ELEMENT = "data-directory";
/*     */   public static final String DEFAULT_BASE_DIR = "data/xmbean-attrs";
/*     */   public static final String AL_ROOT_ELEMENT = "attribute-list";
/*     */   public static final String AL_ID_ATTRIBUTE = "id";
/*     */   public static final String AL_DATE_ATTRIBUTE = "date";
/*     */   public static final String AL_ATTRIBUTE_ELEMENT = "attribute";
/*     */   public static final String AL_NAME_ATTRIBUTE = "name";
/*     */   public static final String AL_TYPE_ATTRIBUTE = "type";
/*     */   public static final String AL_NULL_ATTRIBUTE = "null";
/*     */   public static final String AL_SERIALIZED_ATTRIBUTE = "serialized";
/*     */   public static final String AL_TRUE_VALUE = "true";
/*     */   public static final String AL_FALSE_VALUE = "false";
/* 102 */   private static final Logger log = Logger.getLogger(XMLAttributePersistenceManager.class);
/*     */ 
/* 105 */   private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
/*     */ 
/* 108 */   private static final char[] hexDigits = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F' };
/*     */   private File dataDir;
/*     */   private boolean state;
/*     */   private Map idMap;
/*     */ 
/*     */   public XMLAttributePersistenceManager()
/*     */   {
/* 127 */     log.debug("Constructed");
/*     */   }
/*     */ 
/*     */   public void create(String version, Element config)
/*     */     throws Exception
/*     */   {
/* 160 */     if (getState()) {
/* 161 */       return;
/*     */     }
/*     */ 
/* 165 */     String baseDir = null;
/*     */ 
/* 167 */     if (config == null) {
/* 168 */       baseDir = "data/xmbean-attrs";
/*     */     }
/*     */     else {
/* 171 */       if (!config.getTagName().equals("data-directory")) {
/* 172 */         throw new Exception("expected 'data-directory' XML configuration element, got '" + config.getTagName() + "'");
/*     */       }
/*     */ 
/* 177 */       baseDir = getElementContent(config);
/*     */     }
/*     */ 
/* 182 */     this.dataDir = initDataDir(baseDir, version);
/*     */ 
/* 184 */     log.debug("Using data directory: " + this.dataDir.getCanonicalPath());
/*     */ 
/* 187 */     this.idMap = Collections.synchronizedMap(new HashMap());
/*     */ 
/* 190 */     setState(true);
/*     */   }
/*     */ 
/*     */   public boolean getState()
/*     */   {
/* 202 */     return this.state;
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/* 215 */     setState(false);
/*     */ 
/* 218 */     this.dataDir = null;
/* 219 */     this.idMap = null;
/*     */   }
/*     */ 
/*     */   public void store(String id, AttributeList attrs)
/*     */     throws Exception
/*     */   {
/* 236 */     log.debug("store(" + id + ") attrs=" + attrs);
/*     */ 
/* 239 */     checkActiveState();
/*     */ 
/* 242 */     String origId = id;
/* 243 */     id = mapId(id);
/*     */ 
/* 245 */     if (attrs == null) {
/* 246 */       throw new Exception("store() called with null AttributeList");
/*     */     }
/*     */ 
/* 249 */     File file = checkFileForWrite(id);
/*     */ 
/* 252 */     DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
/* 253 */     Document doc = builder.newDocument();
/*     */ 
/* 256 */     Comment comment = doc.createComment(" automatically produced by XMLAttributePersistenceManager ");
/* 257 */     doc.appendChild(comment);
/*     */ 
/* 260 */     Element root = doc.createElement("attribute-list");
/* 261 */     root.setAttribute("id", origId);
/* 262 */     root.setAttribute("date", dateFormat.format(new Date()));
/* 263 */     doc.appendChild(root);
/*     */ 
/* 266 */     for (int i = 0; i < attrs.size(); i++)
/*     */     {
/* 268 */       Attribute attr = (Attribute)attrs.get(i);
/*     */ 
/* 270 */       String name = attr.getName();
/* 271 */       Object value = attr.getValue();
/*     */ 
/* 274 */       Element element = doc.createElement("attribute");
/* 275 */       element.setAttribute("name", name);
/*     */ 
/* 277 */       if (value == null)
/*     */       {
/* 279 */         element.setAttribute("null", "true");
/*     */ 
/* 282 */         root.appendChild(element);
/*     */       }
/* 284 */       else if ((value instanceof Element))
/*     */       {
/* 286 */         element.setAttribute("type", "org.w3c.dom.Element");
/*     */ 
/* 288 */         Node copy = doc.importNode((Element)value, true);
/* 289 */         element.appendChild(copy);
/*     */ 
/* 292 */         root.appendChild(element);
/*     */       }
/*     */       else {
/* 295 */         Class clazz = value.getClass();
/* 296 */         String type = clazz.getName();
/* 297 */         PropertyEditor peditor = PropertyEditorManager.findEditor(clazz);
/*     */ 
/* 299 */         if (peditor != null)
/*     */         {
/* 301 */           peditor.setValue(value);
/*     */ 
/* 303 */           element.setAttribute("type", type);
/* 304 */           element.appendChild(doc.createTextNode(peditor.getAsText()));
/*     */ 
/* 307 */           root.appendChild(element);
/*     */         }
/* 309 */         else if ((value instanceof Serializable))
/*     */         {
/* 312 */           String encoded = encodeAsHexString((Serializable)value);
/*     */ 
/* 314 */           if (encoded != null) {
/* 315 */             element.setAttribute("type", type);
/* 316 */             element.setAttribute("serialized", "true");
/* 317 */             element.appendChild(doc.createTextNode(encoded));
/*     */ 
/* 320 */             root.appendChild(element);
/*     */           }
/*     */           else
/*     */           {
/* 324 */             root.appendChild(doc.createComment(" WARN <attribute name=\"" + name + "\" type=\"" + type + "\"/> could not be serialized "));
/*     */ 
/* 328 */             log.warn("Could not serialize attribute '" + name + "' of type '" + type + "' and value: " + value);
/*     */           }
/*     */ 
/*     */         }
/*     */         else
/*     */         {
/* 334 */           root.appendChild(doc.createComment(" WARN <attribute name=\"" + name + "\" type=\"" + type + "\"/> could not be persisted "));
/*     */ 
/* 338 */           log.warn("Could not find a way to persist attribute '" + name + "' of type '" + type + "' and value: " + value);
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 346 */       outputXmlFile(doc, file);
/*     */     }
/*     */     catch (Exception e) {
/* 349 */       log.warn("Cannot persist AttributeList to: \"" + id + "\"", e);
/* 350 */       throw e;
/*     */     }
/*     */   }
/*     */ 
/*     */   public AttributeList load(String id)
/*     */     throws Exception
/*     */   {
/* 367 */     log.debug("load(" + id + ")");
/*     */ 
/* 370 */     checkActiveState();
/*     */ 
/* 373 */     id = mapId(id);
/*     */ 
/* 375 */     if (!getState()) {
/* 376 */       return null;
/*     */     }
/*     */ 
/* 379 */     AttributeList attrs = null;
/*     */ 
/* 382 */     File file = checkFileForRead(id);
/*     */ 
/* 384 */     if (file != null)
/*     */     {
/* 386 */       Document doc = parseXmlFile(file);
/*     */ 
/* 389 */       NodeList docList = doc.getChildNodes();
/* 390 */       Element root = null;
/*     */ 
/* 392 */       for (int i = 0; i < docList.getLength(); i++) {
/* 393 */         Node node = docList.item(i);
/*     */ 
/* 395 */         if ((node.getNodeType() != 1) || (!node.getNodeName().equals("attribute-list"))) {
/*     */           continue;
/*     */         }
/* 398 */         root = (Element)node;
/* 399 */         break;
/*     */       }
/*     */ 
/* 404 */       if (root == null) {
/* 405 */         throw new Exception("Expected XML element: attribute-list");
/*     */       }
/*     */ 
/* 410 */       attrs = new AttributeList();
/*     */ 
/* 412 */       NodeList rootList = root.getChildNodes();
/*     */ 
/* 414 */       for (int i = 0; i < rootList.getLength(); i++) {
/* 415 */         Node node = rootList.item(i);
/*     */ 
/* 418 */         if ((node.getNodeType() != 1) || (!node.getNodeName().equals("attribute"))) {
/*     */           continue;
/*     */         }
/* 421 */         Element element = (Element)node;
/*     */ 
/* 424 */         String name = element.getAttribute("name");
/*     */ 
/* 426 */         if (name.length() <= 0) {
/* 427 */           throw new Exception("Attribute 'name' must be specified for element 'attribute'");
/*     */         }
/*     */ 
/* 433 */         if (element.getAttribute("null").toLowerCase().equals("true"))
/*     */         {
/* 436 */           attrs.add(new Attribute(name, null));
/*     */         }
/* 438 */         else if (element.getAttribute("serialized").toLowerCase().equals("true"))
/*     */         {
/* 441 */           String hexStr = getElementContent(element);
/* 442 */           Serializable obj = decodeFromHexString(hexStr);
/*     */ 
/* 444 */           if (obj == null) {
/* 445 */             throw new Exception("Failed to deserialize attribute '" + name + "'");
/*     */           }
/*     */ 
/* 448 */           attrs.add(new Attribute(name, obj));
/*     */         }
/*     */         else
/*     */         {
/* 452 */           String type = element.getAttribute("type");
/*     */ 
/* 455 */           if (type.length() <= 0) {
/* 456 */             throw new Exception("Attribute 'type' must be specified for name='" + name + "'");
/*     */           }
/*     */ 
/* 460 */           if (type.equals("org.w3c.dom.Element"))
/*     */           {
/* 464 */             NodeList nlist = element.getChildNodes();
/* 465 */             Element el = null;
/*     */ 
/* 467 */             for (int j = 0; j < nlist.getLength(); j++)
/*     */             {
/* 469 */               Node n = nlist.item(j);
/* 470 */               if (n.getNodeType() != 1)
/*     */                 continue;
/* 472 */               el = (Element)n;
/* 473 */               break;
/*     */             }
/*     */ 
/* 477 */             if (el != null) {
/* 478 */               attrs.add(new Attribute(name, el.cloneNode(true)));
/*     */             }
/*     */             else {
/* 481 */               attrs.add(new Attribute(name, null));
/*     */             }
/*     */           }
/*     */           else
/*     */           {
/* 486 */             ClassLoader cl = Thread.currentThread().getContextClassLoader();
/* 487 */             Class clazz = null;
/*     */             try
/*     */             {
/* 490 */               clazz = cl.loadClass(type);
/*     */             }
/*     */             catch (ClassNotFoundException e) {
/* 493 */               throw new Exception("Class not found for attribute '" + name + "' of type '" + type + "'");
/*     */             }
/*     */ 
/* 497 */             PropertyEditor peditor = PropertyEditorManager.findEditor(clazz);
/*     */ 
/* 499 */             if (peditor != null)
/*     */             {
/* 503 */               String value = getElementContent(element);
/* 504 */               peditor.setAsText(value);
/*     */ 
/* 506 */               attrs.add(new Attribute(name, peditor.getValue()));
/*     */             }
/*     */             else {
/* 509 */               throw new Exception("Cannot find a way to load attribute '" + name + "' of type '" + type + "'");
/*     */             }
/*     */           }
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 518 */     log.debug("load() returns with: " + attrs);
/*     */ 
/* 521 */     return attrs;
/*     */   }
/*     */ 
/*     */   public boolean exists(String id)
/*     */     throws Exception
/*     */   {
/* 538 */     checkActiveState();
/*     */ 
/* 540 */     return new File(this.dataDir, mapId(id)).isFile();
/*     */   }
/*     */ 
/*     */   public void remove(String id)
/*     */     throws Exception
/*     */   {
/* 553 */     checkActiveState();
/*     */ 
/* 555 */     new File(this.dataDir, mapId(id)).delete();
/*     */   }
/*     */ 
/*     */   public void removeAll()
/*     */     throws Exception
/*     */   {
/* 568 */     checkActiveState();
/*     */ 
/* 570 */     String[] files = this.dataDir.list(new XMLFilter(null));
/*     */ 
/* 572 */     if (files != null)
/* 573 */       for (int i = 0; i < files.length; i++)
/* 574 */         new File(this.dataDir, files[i]).delete();
/*     */   }
/*     */ 
/*     */   public String[] listAll()
/*     */     throws Exception
/*     */   {
/* 590 */     checkActiveState();
/*     */ 
/* 592 */     String[] files = this.dataDir.list(new XMLFilter(null));
/* 593 */     String[] result = null;
/*     */ 
/* 595 */     if (files != null) {
/* 596 */       result = new String[files.length];
/*     */ 
/* 598 */       for (int i = 0; i < files.length; i++) {
/* 599 */         result[i] = mapFile(files[i]);
/*     */       }
/*     */     }
/* 602 */     return result;
/*     */   }
/*     */ 
/*     */   private void setState(boolean state)
/*     */   {
/* 614 */     this.state = state;
/*     */   }
/*     */ 
/*     */   private File initDataDir(String baseDir, String versionTag)
/*     */     throws Exception
/*     */   {
/* 630 */     File dir = null;
/*     */     try
/*     */     {
/* 636 */       URL fileURL = new URL(baseDir);
/*     */ 
/* 638 */       File file = new File(fileURL.getFile());
/*     */ 
/* 640 */       if ((file.isDirectory()) && (file.canRead()) && (file.canWrite())) {
/* 641 */         dir = file;
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 647 */       File homeDir = ServerConfigLocator.locate().getServerHomeDir();
/*     */ 
/* 649 */       dir = new File(homeDir, baseDir);
/*     */ 
/* 651 */       dir.mkdirs();
/*     */ 
/* 653 */       if (!dir.isDirectory()) {
/* 654 */         throw new Exception("The base directory is not valid: " + dir.getCanonicalPath());
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 659 */     if ((versionTag != null) && (!versionTag.equals(""))) {
/* 660 */       dir = new File(dir, versionTag);
/*     */ 
/* 662 */       dir.mkdirs();
/*     */ 
/* 664 */       if (!dir.isDirectory()) {
/* 665 */         throw new Exception("The data directory is not valid: " + dir.getCanonicalPath());
/*     */       }
/*     */     }
/* 668 */     return dir;
/*     */   }
/*     */ 
/*     */   private String encodeAsHexString(Serializable obj)
/*     */   {
/* 680 */     String retn = null;
/*     */ 
/* 682 */     if (obj != null) {
/*     */       try {
/* 684 */         ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
/* 685 */         ObjectOutputStream oos = new ObjectOutputStream(baos);
/*     */ 
/* 687 */         oos.writeObject(obj);
/* 688 */         byte[] bytes = baos.toByteArray();
/*     */ 
/* 690 */         StringBuffer sbuf = new StringBuffer(1024);
/*     */ 
/* 692 */         for (int i = 0; i < bytes.length; i++) {
/* 693 */           sbuf.append(hexDigits[(bytes[i] >> 4 & 0xF)]);
/* 694 */           sbuf.append(hexDigits[(bytes[i] & 0xF)]);
/*     */         }
/*     */ 
/* 697 */         retn = sbuf.toString();
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/*     */       }
/*     */     }
/* 703 */     return retn;
/*     */   }
/*     */ 
/*     */   private Serializable decodeFromHexString(String hexStr)
/*     */   {
/* 714 */     int len = hexStr.length() / 2;
/* 715 */     byte[] bytes = new byte[len];
/*     */ 
/* 717 */     for (int i = 0; i < len; i++)
/*     */     {
/* 719 */       char h1 = hexStr.charAt(i * 2);
/* 720 */       char h2 = hexStr.charAt(i * 2 + 1);
/*     */ 
/* 723 */       int d1 = h1 >= 'A' ? '\n' + h1 - 65 : h1 >= 'a' ? '\n' + h1 - 97 : h1 - '0';
/*     */ 
/* 727 */       int d2 = h2 >= 'A' ? '\n' + h2 - 65 : h2 >= 'a' ? '\n' + h2 - 97 : h2 - '0';
/*     */ 
/* 731 */       bytes[i] = (byte)(d1 * 16 + d2);
/*     */     }
/*     */ 
/* 734 */     Serializable retn = null;
/*     */     try
/*     */     {
/* 739 */       ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
/* 740 */       ObjectInputStream ois = new ObjectInputStreamExt(bais);
/* 741 */       retn = (Serializable)ois.readObject();
/* 742 */       ois.close();
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/* 746 */       log.warn("Cannot deserialize object", e);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 750 */       log.warn("Cought IOException", e);
/*     */     }
/* 752 */     return retn;
/*     */   }
/*     */ 
/*     */   private void outputXmlFile(Document doc, File file)
/*     */     throws Exception
/*     */   {
/* 763 */     Source source = new DOMSource(doc);
/*     */ 
/* 766 */     OutputStream out = new FileOutputStream(file);
/*     */ 
/* 769 */     Result result = new StreamResult(out);
/*     */ 
/* 772 */     Transformer xformer = TransformerFactory.newInstance().newTransformer();
/*     */ 
/* 775 */     xformer.setOutputProperty("indent", "yes");
/*     */     try
/*     */     {
/* 779 */       xformer.transform(source, result);
/*     */     }
/*     */     finally
/*     */     {
/* 784 */       out.close();
/*     */     }
/*     */   }
/*     */ 
/*     */   private Document parseXmlFile(File file)
/*     */     throws Exception
/*     */   {
/* 796 */     DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
/*     */ 
/* 800 */     factory.setValidating(false);
/*     */ 
/* 803 */     DocumentBuilder builder = factory.newDocumentBuilder();
/*     */ 
/* 809 */     InputStream in = new FileInputStream(file);
/*     */     Document doc;
/*     */     try
/*     */     {
/* 813 */       doc = builder.parse(in);
/*     */     }
/*     */     finally
/*     */     {
/* 818 */       in.close();
/*     */     }
/*     */ 
/* 821 */     return doc;
/*     */   }
/*     */ 
/*     */   private File checkFileForWrite(String filename)
/*     */     throws Exception
/*     */   {
/* 830 */     File file = new File(this.dataDir, filename);
/*     */ 
/* 832 */     if (file.isFile()) {
/* 833 */       if ((file.canRead()) && (file.canWrite())) {
/* 834 */         return file;
/*     */       }
/*     */ 
/* 837 */       throw new Exception("file '" + filename + "' is not r/w");
/*     */     }
/*     */ 
/* 840 */     if (file.isDirectory()) {
/* 841 */       throw new Exception(filename + " is a directory!");
/*     */     }
/*     */ 
/* 844 */     return file;
/*     */   }
/*     */ 
/*     */   private File checkFileForRead(String filename)
/*     */     throws Exception
/*     */   {
/* 856 */     File file = new File(this.dataDir, filename);
/*     */ 
/* 858 */     if (file.isFile()) {
/* 859 */       if ((file.canRead()) && (file.canWrite())) {
/* 860 */         return file;
/*     */       }
/*     */ 
/* 863 */       throw new Exception("file '" + filename + "' is not r/w");
/*     */     }
/*     */ 
/* 866 */     if (file.isDirectory()) {
/* 867 */       throw new Exception(filename + " is a directory!");
/*     */     }
/*     */ 
/* 870 */     return null;
/*     */   }
/*     */ 
/*     */   private String getElementContent(Element element)
/*     */   {
/* 880 */     NodeList nlist = element.getChildNodes();
/*     */ 
/* 882 */     StringBuffer sbuf = new StringBuffer(1024);
/*     */ 
/* 885 */     for (int i = 0; i < nlist.getLength(); i++) {
/* 886 */       Node node = nlist.item(i);
/*     */ 
/* 888 */       if (node.getNodeType() == 3) {
/* 889 */         sbuf.append(((Text)node).getData());
/*     */       }
/*     */     }
/* 892 */     return sbuf.toString();
/*     */   }
/*     */ 
/*     */   private void checkActiveState()
/*     */   {
/* 900 */     if (!getState())
/* 901 */       throw new IllegalStateException("AttributePersistenceManager not active");
/*     */   }
/*     */ 
/*     */   private String mapId(String id)
/*     */     throws Exception
/*     */   {
/* 925 */     if (id == null) {
/* 926 */       throw new Exception("called with null id");
/*     */     }
/*     */ 
/* 930 */     String file = (String)this.idMap.get(id);
/*     */ 
/* 933 */     if (file == null) {
/* 934 */       file = Files.encodeFileName(id) + ".xml";
/* 935 */       this.idMap.put(id, file);
/*     */     }
/* 937 */     return file;
/*     */   }
/*     */ 
/*     */   private String mapFile(String file)
/*     */   {
/* 946 */     if (file == null) {
/* 947 */       return null;
/*     */     }
/*     */ 
/* 951 */     file = file.substring(0, file.length() - 4);
/*     */ 
/* 953 */     return Files.decodeFileName(file);
/*     */   }
/*     */ 
/*     */   private class ObjectInputStreamExt extends ObjectInputStream
/*     */   {
/*     */     ObjectInputStreamExt(InputStream is)
/*     */       throws IOException
/*     */     {
/* 966 */       super();
/*     */     }
/*     */ 
/*     */     protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException
/*     */     {
/* 971 */       return Classes.loadClass(v.getName());
/*     */     }
/*     */   }
/*     */ 
/*     */   private class XMLFilter
/*     */     implements FilenameFilter
/*     */   {
/*     */     private XMLFilter()
/*     */     {
/*     */     }
/*     */ 
/*     */     public boolean accept(File dir, String name)
/*     */     {
/* 913 */       return name.endsWith(".xml");
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.pm.XMLAttributePersistenceManager
 * JD-Core Version:    0.6.0
 */