/*     */ package org.jboss.system.server;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.net.URLClassLoader;
/*     */ import java.util.LinkedList;
/*     */ import java.util.List;
/*     */ import java.util.Properties;
/*     */ import java.util.StringTokenizer;
/*     */ import org.jboss.system.NoAnnotationURLClassLoader;
/*     */ 
/*     */ public class ServerLoader
/*     */ {
/*  82 */   public static final String[] DEFAULT_BOOT_LIBRARY_LIST = { "log4j-boot.jar", "jboss-logging-spi.jar", "jboss-logging-log4j.jar", "jboss-logging-jdk.jar", "jboss-common-core.jar", "jboss-xml-binding.jar", "jaxb-api.jar", "jboss-bootstrap.jar", "javassist.jar", "jboss-container.jar", "jboss-dependency.jar", "jboss-kernel.jar" };
/*     */   public static final String DEFAULT_SERVER_TYPE = "org.jboss.bootstrap.microcontainer.ServerImpl";
/*     */   protected Properties props;
/*     */   protected URL libraryURL;
/* 118 */   protected List<URL> extraClasspath = new LinkedList();
/*     */ 
/*     */   public ServerLoader(Properties props)
/*     */     throws Exception
/*     */   {
/* 129 */     if (props == null) {
/* 130 */       throw new IllegalArgumentException("props is null");
/*     */     }
/* 132 */     this.props = props;
/*     */ 
/* 135 */     URL homeURL = getURL("jboss.home.url");
/* 136 */     if (homeURL == null)
/*     */     {
/* 138 */       throw new Exception("Missing configuration value for: jboss.home.url");
/*     */     }
/*     */ 
/* 142 */     this.libraryURL = getURL("jboss.lib.url");
/* 143 */     if (this.libraryURL == null)
/*     */     {
/* 146 */       this.libraryURL = new URL(homeURL, "lib/");
/*     */     }
/*     */ 
/* 150 */     if (homeURL.getProtocol().startsWith("http") == true)
/*     */     {
/* 152 */       addLibrary("webdavlib.jar");
/* 153 */       addLibrary("commons-httpclient.jar");
/* 154 */       addLibrary("commons-logging.jar");
/*     */     }
/*     */   }
/*     */ 
/*     */   public void addLibrary(String filename)
/*     */     throws MalformedURLException
/*     */   {
/* 169 */     if (filename == null) {
/* 170 */       throw new IllegalArgumentException("filename is null");
/*     */     }
/* 172 */     URL jarURL = new URL(this.libraryURL, filename);
/* 173 */     this.extraClasspath.add(jarURL);
/*     */   }
/*     */ 
/*     */   public void addLibraries(String filenames)
/*     */     throws MalformedURLException
/*     */   {
/* 185 */     if (filenames == null) {
/* 186 */       throw new IllegalArgumentException("filenames is null");
/*     */     }
/* 188 */     StringTokenizer stok = new StringTokenizer(filenames, ",");
/* 189 */     while (stok.hasMoreElements())
/*     */     {
/* 191 */       addLibrary(stok.nextToken().trim());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void addURL(URL url)
/*     */   {
/* 202 */     if (url == null) {
/* 203 */       throw new IllegalArgumentException("url is null");
/*     */     }
/* 205 */     this.extraClasspath.add(url);
/*     */   }
/*     */ 
/*     */   public void addEndorsedJars()
/*     */     throws MalformedURLException
/*     */   {
/* 215 */     File endorsedDir = new File(this.libraryURL.getPath() + "/endorsed");
/* 216 */     if (endorsedDir.exists())
/*     */     {
/* 218 */       String[] list = endorsedDir.list();
/* 219 */       for (int i = 0; (list != null) && (i < list.length); i++)
/*     */       {
/* 221 */         String jarname = list[i];
/* 222 */         addLibrary("endorsed/" + jarname);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected URL getURL(String name)
/*     */     throws MalformedURLException
/*     */   {
/* 236 */     String value = this.props.getProperty(name, null);
/* 237 */     if (value != null)
/*     */     {
/* 239 */       if (!value.endsWith("/")) value = value + "/";
/* 240 */       return new URL(value);
/*     */     }
/* 242 */     return null;
/*     */   }
/*     */ 
/*     */   protected URL[] getBootClasspath()
/*     */     throws MalformedURLException
/*     */   {
/* 253 */     List list = new LinkedList();
/*     */ 
/* 256 */     list.addAll(this.extraClasspath);
/*     */ 
/* 258 */     String value = this.props.getProperty("jboss.boot.library.list");
/* 259 */     if (value != null)
/*     */     {
/* 261 */       StringTokenizer stok = new StringTokenizer(value, ",");
/* 262 */       while (stok.hasMoreElements())
/*     */       {
/* 264 */         URL url = new URL(this.libraryURL, stok.nextToken().trim());
/* 265 */         list.add(url);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 270 */       for (String jar : DEFAULT_BOOT_LIBRARY_LIST)
/*     */       {
/* 272 */         URL url = new URL(this.libraryURL, jar);
/* 273 */         list.add(url);
/*     */       }
/*     */     }
/*     */ 
/* 277 */     return (URL[])list.toArray(new URL[list.size()]);
/*     */   }
/*     */ 
/*     */   public Server load(ClassLoader parent) throws Exception
/*     */   {
/* 292 */     ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
/*     */     Server server;
/*     */     try
/*     */     {
/* 297 */       URL[] urls = getBootClasspath();
/* 298 */       URLClassLoader classLoader = new NoAnnotationURLClassLoader(urls, parent);
/* 299 */       Thread.currentThread().setContextClassLoader(classLoader);
/*     */ 
/* 302 */       String typename = this.props.getProperty("jboss.server.type", "org.jboss.bootstrap.microcontainer.ServerImpl");
/* 303 */       server = createServer(typename, classLoader);
/*     */     }
/*     */     finally
/*     */     {
/* 307 */       Thread.currentThread().setContextClassLoader(oldCL);
/*     */     }
/*     */ 
/* 311 */     return server;
/*     */   }
/*     */ 
/*     */   protected Server createServer(String typename, ClassLoader loader)
/*     */     throws Exception
/*     */   {
/* 326 */     Class type = loader.loadClass(typename);
/*     */ 
/* 329 */     Server server = (Server)type.newInstance();
/* 330 */     return server;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.server.ServerLoader
 * JD-Core Version:    0.6.0
 */