/*     */ package org.jboss.system.server.profileservice;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import org.jboss.bootstrap.spi.Bootstrap;
/*     */ import org.jboss.dependency.spi.ControllerContext;
/*     */ import org.jboss.deployers.client.spi.IncompleteDeploymentException;
/*     */ import org.jboss.deployers.client.spi.main.MainDeployer;
/*     */ import org.jboss.deployers.plugins.main.MainDeployerImpl;
/*     */ import org.jboss.deployers.structure.spi.DeploymentContext;
/*     */ import org.jboss.deployers.vfs.spi.client.VFSDeployment;
/*     */ import org.jboss.kernel.Kernel;
/*     */ import org.jboss.kernel.spi.dependency.KernelController;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.managed.api.ManagedDeployment.DeploymentPhase;
/*     */ import org.jboss.profileservice.spi.Profile;
/*     */ import org.jboss.profileservice.spi.ProfileKey;
/*     */ import org.jboss.profileservice.spi.ProfileService;
/*     */ import org.jboss.system.server.Server;
/*     */ 
/*     */ public class ProfileServiceBootstrap
/*     */   implements Bootstrap
/*     */ {
/*  54 */   private static final Logger log = Logger.getLogger(ProfileServiceBootstrap.class);
/*     */ 
/*  57 */   protected String profileName = "default";
/*     */   protected MainDeployer mainDeployer;
/*     */   protected ProfileService profileService;
/*     */   protected Kernel kernel;
/*     */ 
/*     */   public MainDeployer getMainDeployer()
/*     */   {
/*  82 */     return this.mainDeployer;
/*     */   }
/*     */ 
/*     */   public ProfileService getProfileService()
/*     */   {
/*  92 */     return this.profileService;
/*     */   }
/*     */ 
/*     */   public Kernel getKernel()
/*     */   {
/* 102 */     return this.kernel;
/*     */   }
/*     */ 
/*     */   public void setKernel(Kernel kernel)
/*     */   {
/* 112 */     this.kernel = kernel;
/*     */   }
/*     */ 
/*     */   public void start(Server server) throws Exception
/*     */   {
/* 117 */     KernelController controller = this.kernel.getController();
/*     */ 
/* 120 */     this.profileService = ((ProfileService)getBean(controller, "ProfileService", ProfileService.class));
/* 121 */     log.debug("Using ProfileService: " + this.profileService);
/* 122 */     this.mainDeployer = ((MainDeployer)getBean(controller, "MainDeployer", MainDeployer.class));
/* 123 */     log.debug("Using MainDeployer: " + this.mainDeployer);
/*     */ 
/* 126 */     this.mainDeployer.checkComplete();
/*     */     try
/*     */     {
/* 131 */       loadProfile(this.profileName);
/*     */     }
/*     */     catch (IncompleteDeploymentException e)
/*     */     {
/* 135 */       log.error("Failed to load profile: " + e.getMessage());
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 139 */       log.error("Failed to load profile: ", e);
/*     */     }
/*     */ 
/* 142 */     Profile profile = this.profileService.getActiveProfile();
/* 143 */     if (profile != null)
/* 144 */       profile.enableModifiedDeploymentChecks(true);
/*     */   }
/*     */ 
/*     */   public void shutdown(Server server)
/*     */   {
/*     */     try
/*     */     {
/* 151 */       this.mainDeployer.shutdown();
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 155 */       log.warn("Error shutting down the main deployer", t);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected <T> T getBean(KernelController controller, Object name, Class<T> expectedType)
/*     */   {
/* 171 */     ControllerContext context = controller.getInstalledContext(name);
/* 172 */     if (context == null)
/* 173 */       throw new IllegalStateException("Context not installed: " + name);
/* 174 */     Object result = context.getTarget();
/* 175 */     if (result == null)
/* 176 */       throw new IllegalStateException("No target for " + name);
/* 177 */     if (!expectedType.isInstance(result))
/* 178 */       throw new IllegalStateException(name + " expected " + expectedType.getName() + " was " + result.getClass().getName());
/* 179 */     return expectedType.cast(result);
/*     */   }
/*     */ 
/*     */   protected void loadProfile(String name)
/*     */     throws Exception
/*     */   {
/* 193 */     MainDeployer deployer = getMainDeployer();
/* 194 */     if (deployer == null)
/* 195 */       throw new NullPointerException("MainDeployer has not been set");
/* 196 */     ProfileService ps = getProfileService();
/* 197 */     if (ps == null) {
/* 198 */       throw new NullPointerException("ProfileService has not been set");
/*     */     }
/*     */ 
/* 201 */     ProfileKey key = new ProfileKey(name);
/* 202 */     Profile profile = ps.getProfile(key);
/*     */ 
/* 205 */     VFSDeployment first = null;
/*     */ 
/* 208 */     Collection boostraps = profile.getDeployments(ManagedDeployment.DeploymentPhase.BOOTSTRAP);
/* 209 */     for (VFSDeployment d : boostraps)
/*     */     {
/* 211 */       deployer.addDeployment(d);
/* 212 */       if (first == null)
/* 213 */         first = d;
/*     */     }
/* 215 */     deployer.process();
/* 216 */     deployer.checkComplete();
/*     */ 
/* 218 */     Thread thread = Thread.currentThread();
/* 219 */     ClassLoader old = thread.getContextClassLoader();
/*     */ 
/* 221 */     MainDeployerImpl hack = (MainDeployerImpl)deployer;
/* 222 */     ClassLoader cl = null;
/* 223 */     if (first != null)
/*     */     {
/* 225 */       DeploymentContext ctx = hack.getDeploymentContext(first.getName());
/* 226 */       if (ctx != null)
/* 227 */         cl = ctx.getClassLoader();
/*     */     }
/* 229 */     if (cl != null) {
/* 230 */       thread.setContextClassLoader(cl);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 235 */       Collection profileDeployers = profile.getDeployments(ManagedDeployment.DeploymentPhase.DEPLOYER);
/* 236 */       for (VFSDeployment d : profileDeployers)
/* 237 */         deployer.addDeployment(d);
/* 238 */       deployer.process();
/* 239 */       deployer.checkComplete();
/*     */ 
/* 242 */       Collection profileDeployments = profile.getDeployments(ManagedDeployment.DeploymentPhase.APPLICATION);
/* 243 */       for (VFSDeployment d : profileDeployments)
/* 244 */         deployer.addDeployment(d);
/* 245 */       deployer.process();
/* 246 */       deployer.checkComplete();
/*     */     }
/*     */     finally
/*     */     {
/* 250 */       thread.setContextClassLoader(old);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.server.profileservice.ProfileServiceBootstrap
 * JD-Core Version:    0.6.0
 */