/*    */ package org.jboss.system.server.profileservice.repository;
/*    */ 
/*    */ import java.io.File;
/*    */ import java.io.IOException;
/*    */ import java.io.NotSerializableException;
/*    */ import java.util.Map;
/*    */ import java.util.Map.Entry;
/*    */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.profileservice.aop.TrackingAdvice;
/*    */ import org.jboss.profileservice.spi.AttachmentsSerializer;
/*    */ 
/*    */ public abstract class AbstractFileAttachmentsSerializer
/*    */   implements AttachmentsSerializer
/*    */ {
/* 44 */   private static final Logger log = Logger.getLogger(AbstractFileAttachmentsSerializer.class);
/*    */   private File attachmentsStoreDir;
/*    */ 
/*    */   public File getAttachmentsStoreDir()
/*    */   {
/* 50 */     return this.attachmentsStoreDir;
/*    */   }
/*    */ 
/*    */   public void setAttachmentsStoreDir(File attachmentsStoreDir) {
/* 54 */     this.attachmentsStoreDir = attachmentsStoreDir;
/*    */   }
/*    */ 
/*    */   public Map<String, Object> loadAttachments(DeploymentUnit ctx, String deployerID, ClassLoader loader)
/*    */     throws Exception
/*    */   {
/* 60 */     if (this.attachmentsStoreDir == null) {
/* 61 */       throw new IllegalStateException("attachmentsStoreDir has not been set");
/*    */     }
/* 63 */     String vfsPath = ctx.getSimpleName();
/* 64 */     vfsPath = vfsPath + ".attachments";
/* 65 */     File deployerDir = new File(this.attachmentsStoreDir, deployerID);
/* 66 */     File attachmentsStore = new File(deployerDir, vfsPath);
/* 67 */     if (!attachmentsStore.exists())
/*    */     {
/* 69 */       return null;
/*    */     }
/*    */ 
/* 72 */     return loadAttachments(attachmentsStore, loader);
/*    */   }
/*    */ 
/*    */   public void saveAttachments(DeploymentUnit ctx, String deployerID, ClassLoader loader)
/*    */     throws Exception
/*    */   {
/* 78 */     if (this.attachmentsStoreDir == null) {
/* 79 */       throw new IllegalStateException("attachmentsStoreDir has not been set");
/*    */     }
/* 81 */     String vfsPath = ctx.getSimpleName();
/* 82 */     if (vfsPath.length() == 0)
/* 83 */       vfsPath = ctx.getSimpleName();
/* 84 */     vfsPath = vfsPath + ".attachments";
/* 85 */     File deployerDir = new File(this.attachmentsStoreDir, deployerID);
/* 86 */     File attachmentsStore = new File(deployerDir, vfsPath);
/* 87 */     File attachmentsParent = attachmentsStore.getParentFile();
/* 88 */     if (!attachmentsParent.exists())
/*    */     {
/* 90 */       if (!attachmentsParent.mkdirs()) {
/* 91 */         throw new IOException("Failed to create attachmentsParent: " + attachmentsParent.getAbsolutePath());
/*    */       }
/*    */     }
/* 94 */     Map attachments = TrackingAdvice.clearAttachmentsForTarget(ctx.getTransientManagedObjects());
/* 95 */     if (attachments != null)
/*    */     {
/*    */       try
/*    */       {
/* 99 */         saveAttachments(attachmentsStore, attachments, loader);
/*    */       }
/*    */       catch (NotSerializableException e)
/*    */       {
/* 104 */         StringBuilder tmp = new StringBuilder("Save failed with NSE, attachments contents: ");
/* 105 */         for (Map.Entry entry : attachments.entrySet())
/*    */         {
/* 107 */           tmp.append((String)entry.getKey());
/* 108 */           tmp.append('=');
/* 109 */           tmp.append(entry.getValue());
/*    */         }
/* 111 */         log.error(tmp.toString());
/* 112 */         throw e;
/*    */       }
/*    */     }
/*    */   }
/*    */ 
/*    */   protected abstract Map<String, Object> loadAttachments(File paramFile, ClassLoader paramClassLoader)
/*    */     throws Exception;
/*    */ 
/*    */   protected abstract void saveAttachments(File paramFile, Map<String, Object> paramMap, ClassLoader paramClassLoader)
/*    */     throws Exception;
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.server.profileservice.repository.AbstractFileAttachmentsSerializer
 * JD-Core Version:    0.6.0
 */