/*     */ package org.jboss.system.server.profileservice.repository;
/*     */ 
/*     */ import java.net.URI;
/*     */ import java.util.Collections;
/*     */ import java.util.Map;
/*     */ import org.jboss.deployers.spi.attachments.Attachments;
/*     */ import org.jboss.profileservice.spi.repository.Capability;
/*     */ import org.jboss.profileservice.spi.repository.Repository;
/*     */ import org.jboss.profileservice.spi.repository.Requirement;
/*     */ import org.jboss.profileservice.spi.repository.Resource;
/*     */ import org.jboss.profileservice.spi.repository.Version;
/*     */ 
/*     */ public class AttachmentsResource
/*     */   implements Resource
/*     */ {
/*     */   private String vfsPath;
/*     */   private Repository repository;
/*  45 */   private String[] categories = new String[0];
/*  46 */   private Capability[] capabilities = new Capability[0];
/*     */   private Map<String, Object> props;
/*     */ 
/*     */   public AttachmentsResource(String vfsPath, Attachments edits, Repository repository)
/*     */   {
/*  51 */     this.vfsPath = vfsPath;
/*  52 */     this.repository = repository;
/*  53 */     this.props = Collections.singletonMap("attachments", edits);
/*     */   }
/*     */ 
/*     */   public Capability[] getCapabilities()
/*     */   {
/*  58 */     return this.capabilities;
/*     */   }
/*     */ 
/*     */   public String[] getCategories()
/*     */   {
/*  63 */     return this.categories;
/*     */   }
/*     */ 
/*     */   public String getId()
/*     */   {
/*  68 */     return this.vfsPath;
/*     */   }
/*     */ 
/*     */   public String getPresentationName()
/*     */   {
/*  73 */     return this.vfsPath;
/*     */   }
/*     */ 
/*     */   public Map getProperties()
/*     */   {
/*  78 */     return this.props;
/*     */   }
/*     */ 
/*     */   public Repository getRepository()
/*     */   {
/*  83 */     return this.repository;
/*     */   }
/*     */ 
/*     */   public Requirement[] getRequirements()
/*     */   {
/*  89 */     return null;
/*     */   }
/*     */ 
/*     */   public String getSymbolicName()
/*     */   {
/*  94 */     return this.vfsPath;
/*     */   }
/*     */ 
/*     */   public URI getURI()
/*     */   {
/*  99 */     URI repoURI = this.repository.getURI();
/* 100 */     URI uri = null;
/*     */     try
/*     */     {
/* 104 */       uri = repoURI.resolve(this.vfsPath);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 108 */       throw new IllegalStateException(e);
/*     */     }
/* 110 */     return uri;
/*     */   }
/*     */ 
/*     */   public Version getVersion()
/*     */   {
/* 116 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.server.profileservice.repository.AttachmentsResource
 * JD-Core Version:    0.6.0
 */