/*     */ package org.jboss.test.kernel.junit;
/*     */ 
/*     */ import java.net.URL;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.kernel.spi.deployment.KernelDeployment;
/*     */ import org.jboss.kernel.spi.metadata.KernelMetaDataRepository;
/*     */ import org.jboss.test.AbstractTestCaseWithSetup;
/*     */ import org.jboss.test.AbstractTestDelegate;
/*     */ 
/*     */ public class MicrocontainerTest extends AbstractTestCaseWithSetup
/*     */ {
/*     */   public static AbstractTestDelegate getDelegate(Class clazz)
/*     */     throws Exception
/*     */   {
/*  50 */     return new MicrocontainerTestDelegate(clazz);
/*     */   }
/*     */ 
/*     */   public MicrocontainerTest(String name)
/*     */   {
/*  60 */     super(name);
/*     */   }
/*     */ 
/*     */   protected void setUp() throws Exception
/*     */   {
/*  65 */     super.setUp();
/*  66 */     afterSetUp();
/*     */   }
/*     */ 
/*     */   protected void afterSetUp()
/*     */     throws Exception
/*     */   {
/*  76 */     configureLogging();
/*     */ 
/*  78 */     getMCDelegate().validate();
/*     */   }
/*     */ 
/*     */   protected Object getBean(Object name)
/*     */   {
/*  90 */     return getBean(name, ControllerState.INSTALLED);
/*     */   }
/*     */ 
/*     */   protected Object getBean(Object name, ControllerState state)
/*     */   {
/* 103 */     return getMCDelegate().getBean(name, state);
/*     */   }
/*     */ 
/*     */   protected KernelControllerContext getControllerContext(Object name)
/*     */   {
/* 115 */     return getControllerContext(name, ControllerState.INSTALLED);
/*     */   }
/*     */ 
/*     */   protected KernelControllerContext getControllerContext(Object name, ControllerState state)
/*     */   {
/* 128 */     return getMCDelegate().getControllerContext(name, state);
/*     */   }
/*     */ 
/*     */   public ControllerState change(KernelControllerContext context, ControllerState required)
/*     */     throws Throwable
/*     */   {
/* 141 */     return getMCDelegate().change(context, required);
/*     */   }
/*     */ 
/*     */   protected KernelDeployment deploy(URL url)
/*     */     throws Exception
/*     */   {
/* 153 */     return getMCDelegate().deploy(url);
/*     */   }
/*     */ 
/*     */   protected KernelDeployment deploy(String resource)
/*     */     throws Exception
/*     */   {
/* 165 */     URL url = getClass().getResource(resource);
/* 166 */     if (url == null)
/* 167 */       throw new IllegalArgumentException("Resource not found: " + resource);
/* 168 */     return getMCDelegate().deploy(url);
/*     */   }
/*     */ 
/*     */   protected void undeploy(KernelDeployment deployment)
/*     */   {
/* 178 */     getMCDelegate().undeploy(deployment);
/*     */   }
/*     */ 
/*     */   protected void undeploy(String resource)
/*     */   {
/* 188 */     URL url = getClass().getResource(resource);
/* 189 */     if (url == null)
/* 190 */       throw new IllegalArgumentException("Resource not found: " + resource);
/* 191 */     getMCDelegate().undeploy(url);
/*     */   }
/*     */ 
/*     */   protected void validate()
/*     */     throws Exception
/*     */   {
/* 201 */     getMCDelegate().validate();
/*     */   }
/*     */ 
/*     */   protected KernelMetaDataRepository getMetaDataRepository()
/*     */   {
/* 212 */     return getMCDelegate().getMetaDataRepository();
/*     */   }
/*     */ 
/*     */   protected void shutdown()
/*     */   {
/* 220 */     getMCDelegate().shutdown();
/*     */   }
/*     */ 
/*     */   protected MicrocontainerTestDelegate getMCDelegate()
/*     */   {
/* 230 */     return (MicrocontainerTestDelegate)getDelegate();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.test.kernel.junit.MicrocontainerTest
 * JD-Core Version:    0.6.0
 */