/*     */ package org.jboss.test.kernel.junit;
/*     */ 
/*     */ import java.util.UUID;
/*     */ import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
/*     */ import org.jboss.kernel.Kernel;
/*     */ import org.jboss.kernel.spi.dependency.KernelController;
/*     */ 
/*     */ public abstract class WiredMicrocontainerTest extends MicrocontainerTest
/*     */ {
/*  38 */   private String beanName = createTestBeanName();
/*     */ 
/*     */   protected WiredMicrocontainerTest(String name)
/*     */   {
/*  47 */     super(name);
/*     */   }
/*     */ 
/*     */   protected void afterSetUp() throws Exception
/*     */   {
/*  52 */     KernelController controller = getController();
/*     */     try
/*     */     {
/*  55 */       controller.install(new AbstractBeanMetaData(this.beanName, getClass().getName()), this);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/*  59 */       throw new Exception(t);
/*     */     }
/*  61 */     super.afterSetUp();
/*     */   }
/*     */ 
/*     */   private KernelController getController()
/*     */   {
/*  71 */     MicrocontainerTestDelegate delegate = getMCDelegate();
/*  72 */     Kernel kernel = delegate.kernel;
/*  73 */     return kernel.getController();
/*     */   }
/*     */ 
/*     */   protected void tearDown() throws Exception
/*     */   {
/*  78 */     KernelController controller = getController();
/*  79 */     controller.uninstall(this.beanName);
/*  80 */     super.tearDown();
/*     */   }
/*     */ 
/*     */   protected String createTestBeanName()
/*     */   {
/*  91 */     return UUID.randomUUID().toString();
/*     */   }
/*     */ 
/*     */   protected String getTestBeanName()
/*     */   {
/* 102 */     return this.beanName;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.test.kernel.junit.WiredMicrocontainerTest
 * JD-Core Version:    0.6.0
 */