/*     */ package org.jboss.tm;
/*     */ 
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.TransactionManager;
/*     */ 
/*     */ public class TransactionLocal
/*     */ {
/*  45 */   private static final Object NULL_VALUE = new Object();
/*     */   protected final TransactionManager transactionManager;
/*     */   protected TransactionLocalDelegate delegate;
/*     */ 
/*     */   public TransactionLocal()
/*     */   {
/*  64 */     this.transactionManager = TransactionManagerLocator.locateTransactionManager();
/*  65 */     initDelegate();
/*     */   }
/*     */ 
/*     */   public TransactionLocal(TransactionManager tm)
/*     */   {
/*  75 */     if (tm == null)
/*  76 */       throw new IllegalArgumentException("Null transaction manager");
/*  77 */     this.transactionManager = tm;
/*  78 */     initDelegate();
/*     */   }
/*     */ 
/*     */   public void lock()
/*     */     throws InterruptedException
/*     */   {
/*  91 */     lock(getTransaction());
/*     */   }
/*     */ 
/*     */   public void lock(Transaction transaction)
/*     */     throws InterruptedException
/*     */   {
/* 106 */     if (transaction == null) {
/* 107 */       return;
/*     */     }
/* 109 */     this.delegate.lock(this, transaction);
/*     */   }
/*     */ 
/*     */   public void unlock()
/*     */   {
/* 117 */     unlock(getTransaction());
/*     */   }
/*     */ 
/*     */   public void unlock(Transaction transaction)
/*     */   {
/* 128 */     if (transaction == null) {
/* 129 */       return;
/*     */     }
/* 131 */     this.delegate.unlock(this, transaction);
/*     */   }
/*     */ 
/*     */   protected Object initialValue()
/*     */   {
/* 148 */     return null;
/*     */   }
/*     */ 
/*     */   protected Object getValue(Transaction tx)
/*     */   {
/* 160 */     return this.delegate.getValue(this, tx);
/*     */   }
/*     */ 
/*     */   protected void storeValue(Transaction tx, Object value)
/*     */   {
/* 171 */     this.delegate.storeValue(this, tx, value);
/*     */   }
/*     */ 
/*     */   protected boolean containsValue(Transaction tx)
/*     */   {
/* 182 */     return this.delegate.containsValue(this, tx);
/*     */   }
/*     */ 
/*     */   public Object get()
/*     */   {
/* 194 */     return get(getTransaction());
/*     */   }
/*     */ 
/*     */   public Object get(Transaction transaction)
/*     */   {
/* 211 */     if (transaction == null) return initialValue();
/*     */ 
/* 213 */     Object value = getValue(transaction);
/*     */ 
/* 216 */     if (value == null)
/*     */     {
/* 219 */       value = initialValue();
/*     */ 
/* 222 */       if (value == null)
/*     */       {
/* 224 */         value = NULL_VALUE;
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 230 */         storeValue(transaction, value);
/*     */       }
/*     */       catch (IllegalStateException e)
/*     */       {
/* 238 */         return initialValue();
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 243 */     if (value == NULL_VALUE)
/*     */     {
/* 245 */       return null;
/*     */     }
/*     */ 
/* 249 */     return value;
/*     */   }
/*     */ 
/*     */   public void set(Object value)
/*     */   {
/* 263 */     set(getTransaction(), value);
/*     */   }
/*     */ 
/*     */   public void set(Transaction transaction, Object value)
/*     */   {
/* 278 */     if (transaction == null) throw new IllegalStateException("there is no transaction");
/*     */ 
/* 282 */     if (!containsValue(transaction))
/*     */     {
/* 284 */       initialValue();
/*     */     }
/*     */ 
/* 288 */     if (value == null)
/*     */     {
/* 290 */       value = NULL_VALUE;
/*     */     }
/*     */ 
/* 294 */     storeValue(transaction, value);
/*     */   }
/*     */ 
/*     */   public Transaction getTransaction()
/*     */   {
/*     */     try
/*     */     {
/* 301 */       return this.transactionManager.getTransaction();
/*     */     }
/*     */     catch (SystemException e) {
/*     */     }
/* 305 */     throw new IllegalStateException("An error occured while getting the transaction associated with the current thread: " + e);
/*     */   }
/*     */ 
/*     */   protected void initDelegate()
/*     */   {
/* 315 */     if ((this.transactionManager instanceof TransactionLocalDelegate))
/* 316 */       this.delegate = ((TransactionLocalDelegate)this.transactionManager);
/*     */     else
/* 318 */       this.delegate = new TransactionLocalDelegateImpl(this.transactionManager);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.tm.TransactionLocal
 * JD-Core Version:    0.6.0
 */