/*     */ package org.jboss.tm;
/*     */ 
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.TransactionManager;
/*     */ import javax.transaction.UserTransaction;
/*     */ 
/*     */ public class TxUtils
/*     */ {
/*  45 */   private static final String[] TxStatusStrings = { "STATUS_ACTIVE", "STATUS_MARKED_ROLLBACK", "STATUS_PREPARED", "STATUS_COMMITTED", "STATUS_ROLLEDBACK", "STATUS_UNKNOWN", "STATUS_NO_TRANSACTION", "STATUS_PREPARING", "STATUS_COMMITTING", "STATUS_ROLLING_BACK" };
/*     */ 
/*     */   public static boolean isActive(Transaction tx)
/*     */   {
/*  69 */     if (tx == null) {
/*  70 */       return false;
/*     */     }
/*     */     try
/*     */     {
/*  74 */       int status = tx.getStatus();
/*  75 */       return isActive(status);
/*     */     }
/*     */     catch (SystemException error) {
/*     */     }
/*  79 */     throw new RuntimeException(error);
/*     */   }
/*     */ 
/*     */   public static boolean isActive(TransactionManager tm)
/*     */   {
/*     */     try
/*     */     {
/*  87 */       return isActive(tm.getTransaction());
/*     */     }
/*     */     catch (SystemException error) {
/*     */     }
/*  91 */     throw new RuntimeException(error);
/*     */   }
/*     */ 
/*     */   public static boolean isActive()
/*     */   {
/*  97 */     return isActive(TransactionManagerLocator.locateTransactionManager());
/*     */   }
/*     */ 
/*     */   public static boolean isActive(UserTransaction ut)
/*     */   {
/*     */     try
/*     */     {
/* 104 */       int status = ut.getStatus();
/* 105 */       return isActive(status);
/*     */     }
/*     */     catch (SystemException error) {
/*     */     }
/* 109 */     throw new RuntimeException(error);
/*     */   }
/*     */ 
/*     */   public static boolean isActive(int status)
/*     */   {
/* 115 */     return status == 0;
/*     */   }
/*     */ 
/*     */   public static boolean isUncommitted(Transaction tx)
/*     */   {
/* 120 */     if (tx == null) {
/* 121 */       return false;
/*     */     }
/*     */     try
/*     */     {
/* 125 */       int status = tx.getStatus();
/* 126 */       return isUncommitted(status);
/*     */     }
/*     */     catch (SystemException error) {
/*     */     }
/* 130 */     throw new RuntimeException(error);
/*     */   }
/*     */ 
/*     */   public static boolean isUncommitted(TransactionManager tm)
/*     */   {
/*     */     try
/*     */     {
/* 138 */       return isUncommitted(tm.getTransaction());
/*     */     }
/*     */     catch (SystemException error) {
/*     */     }
/* 142 */     throw new RuntimeException(error);
/*     */   }
/*     */ 
/*     */   public static boolean isUncommitted()
/*     */   {
/* 148 */     return isUncommitted(TransactionManagerLocator.locateTransactionManager());
/*     */   }
/*     */ 
/*     */   public static boolean isUncommitted(UserTransaction ut)
/*     */   {
/*     */     try
/*     */     {
/* 155 */       int status = ut.getStatus();
/* 156 */       return isUncommitted(status);
/*     */     }
/*     */     catch (SystemException error)
/*     */     {
/*     */     }
/* 161 */     throw new RuntimeException(error);
/*     */   }
/*     */ 
/*     */   public static boolean isUncommitted(int status)
/*     */   {
/* 167 */     return (status == 0) || (status == 1);
/*     */   }
/*     */ 
/*     */   public static boolean isCompleted(Transaction tx)
/*     */   {
/* 173 */     if (tx == null) {
/* 174 */       return true;
/*     */     }
/*     */     try
/*     */     {
/* 178 */       int status = tx.getStatus();
/* 179 */       return isCompleted(status);
/*     */     }
/*     */     catch (SystemException error) {
/*     */     }
/* 183 */     throw new RuntimeException(error);
/*     */   }
/*     */ 
/*     */   public static boolean isCompleted(TransactionManager tm)
/*     */   {
/*     */     try
/*     */     {
/* 191 */       return isCompleted(tm.getTransaction());
/*     */     }
/*     */     catch (SystemException error) {
/*     */     }
/* 195 */     throw new RuntimeException(error);
/*     */   }
/*     */ 
/*     */   public static boolean isCompleted()
/*     */   {
/* 201 */     return isCompleted(TransactionManagerLocator.locateTransactionManager());
/*     */   }
/*     */ 
/*     */   public static boolean isCompleted(UserTransaction ut)
/*     */   {
/*     */     try
/*     */     {
/* 208 */       int status = ut.getStatus();
/* 209 */       return isCompleted(status);
/*     */     }
/*     */     catch (SystemException error)
/*     */     {
/*     */     }
/* 214 */     throw new RuntimeException(error);
/*     */   }
/*     */ 
/*     */   public static boolean isCompleted(int status)
/*     */   {
/* 220 */     return (status == 3) || (status == 4) || (status == 6);
/*     */   }
/*     */ 
/*     */   public static boolean isRollback(Transaction tx)
/*     */   {
/* 227 */     if (tx == null) {
/* 228 */       return false;
/*     */     }
/*     */     try
/*     */     {
/* 232 */       int status = tx.getStatus();
/* 233 */       return isRollback(status);
/*     */     }
/*     */     catch (SystemException error) {
/*     */     }
/* 237 */     throw new RuntimeException(error);
/*     */   }
/*     */ 
/*     */   public static boolean isRollback(TransactionManager tm)
/*     */   {
/*     */     try
/*     */     {
/* 245 */       return isRollback(tm.getTransaction());
/*     */     }
/*     */     catch (SystemException error) {
/*     */     }
/* 249 */     throw new RuntimeException(error);
/*     */   }
/*     */ 
/*     */   public static boolean isRollback()
/*     */   {
/* 255 */     return isRollback(TransactionManagerLocator.locateTransactionManager());
/*     */   }
/*     */ 
/*     */   public static boolean isRollback(UserTransaction ut)
/*     */   {
/*     */     try
/*     */     {
/* 262 */       int status = ut.getStatus();
/* 263 */       return isRollback(status);
/*     */     }
/*     */     catch (SystemException error) {
/*     */     }
/* 267 */     throw new RuntimeException(error);
/*     */   }
/*     */ 
/*     */   public static boolean isRollback(int status)
/*     */   {
/* 273 */     return (status == 1) || (status == 9) || (status == 4);
/*     */   }
/*     */ 
/*     */   public static String getStatusAsString(int status)
/*     */   {
/* 288 */     if ((status >= 0) && (status <= 9))
/*     */     {
/* 290 */       return TxStatusStrings[status];
/*     */     }
/*     */ 
/* 294 */     return "STATUS_INVALID(" + status + ")";
/*     */   }
/*     */ 
/*     */   public static String getXAResourceFlagsAsString(int flags)
/*     */   {
/* 308 */     if (flags == 0)
/*     */     {
/* 310 */       return "|TMNOFLAGS";
/*     */     }
/*     */ 
/* 314 */     StringBuffer sbuf = new StringBuffer(64);
/*     */ 
/* 316 */     if ((flags & 0x40000000) != 0)
/*     */     {
/* 318 */       sbuf.append("|TMONEPHASE");
/*     */     }
/* 320 */     if ((flags & 0x200000) != 0)
/*     */     {
/* 322 */       sbuf.append("|TMJOIN");
/*     */     }
/* 324 */     if ((flags & 0x8000000) != 0)
/*     */     {
/* 326 */       sbuf.append("|TMRESUME");
/*     */     }
/* 328 */     if ((flags & 0x4000000) != 0)
/*     */     {
/* 330 */       sbuf.append("|TMSUCCESS");
/*     */     }
/* 332 */     if ((flags & 0x20000000) != 0)
/*     */     {
/* 334 */       sbuf.append("|TMFAIL");
/*     */     }
/* 336 */     if ((flags & 0x2000000) != 0)
/*     */     {
/* 338 */       sbuf.append("|TMSUSPEND");
/*     */     }
/* 340 */     if ((flags & 0x1000000) != 0)
/*     */     {
/* 342 */       sbuf.append("|TMSTARTRSCAN");
/*     */     }
/* 344 */     if ((flags & 0x800000) != 0)
/*     */     {
/* 346 */       sbuf.append("|TMENDRSCAN");
/*     */     }
/* 348 */     return sbuf.toString();
/*     */   }
/*     */ 
/*     */   public static String getXAErrorCodeAsString(int errorCode)
/*     */   {
/* 363 */     switch (errorCode)
/*     */     {
/*     */     case 7:
/* 366 */       return "XA_HEURCOM";
/*     */     case 8:
/* 368 */       return "XA_HEURHAZ";
/*     */     case 5:
/* 370 */       return "XA_HEURMIX";
/*     */     case 6:
/* 372 */       return "XA_HEURRB";
/*     */     case 9:
/* 374 */       return "XA_NOMIGRATE";
/*     */     case 101:
/* 376 */       return "XA_RBCOMMFAIL";
/*     */     case 102:
/* 378 */       return "XA_RBDEADLOCK";
/*     */     case 103:
/* 380 */       return "XA_RBINTEGRITY";
/*     */     case 104:
/* 382 */       return "XA_RBOTHER";
/*     */     case 105:
/* 384 */       return "XA_RBPROTO";
/*     */     case 100:
/* 386 */       return "XA_RBROLLBACK";
/*     */     case 106:
/* 388 */       return "XA_RBTIMEOUT";
/*     */     case 107:
/* 390 */       return "XA_RBTRANSIENT";
/*     */     case 3:
/* 392 */       return "XA_RDONLY";
/*     */     case 4:
/* 394 */       return "XA_RETRY";
/*     */     case -2:
/* 396 */       return "XAER_ASYNC";
/*     */     case -8:
/* 398 */       return "XAER_DUPID";
/*     */     case -5:
/* 400 */       return "XAER_INVAL";
/*     */     case -4:
/* 402 */       return "XAER_NOTA";
/*     */     case -9:
/* 404 */       return "XAER_OUTSIDE";
/*     */     case -6:
/* 406 */       return "XAER_PROTO";
/*     */     case -3:
/* 408 */       return "XAER_RMERR";
/*     */     case -7:
/* 410 */       return "XAER_RMFAIL";
/*     */     }
/* 412 */     return "XA_UNKNOWN(" + errorCode + ")";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.tm.TxUtils
 * JD-Core Version:    0.6.0
 */