/*     */ package org.jboss.tm.usertx.client;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.rmi.RemoteException;
/*     */ import java.util.Hashtable;
/*     */ import java.util.LinkedList;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import javax.naming.Reference;
/*     */ import javax.naming.Referenceable;
/*     */ import javax.transaction.HeuristicMixedException;
/*     */ import javax.transaction.HeuristicRollbackException;
/*     */ import javax.transaction.NotSupportedException;
/*     */ import javax.transaction.RollbackException;
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.UserTransaction;
/*     */ import org.jboss.naming.NamingContextFactory;
/*     */ import org.jboss.tm.TransactionPropagationContextFactory;
/*     */ import org.jboss.tm.usertx.interfaces.UserTransactionSession;
/*     */ import org.jboss.tm.usertx.interfaces.UserTransactionSessionFactory;
/*     */ 
/*     */ public class ClientUserTransaction
/*     */   implements UserTransaction, TransactionPropagationContextFactory, Referenceable, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1747989355209242872L;
/*  78 */   private static ClientUserTransaction singleton = null;
/*     */ 
/* 324 */   private UserTransactionSession session = null;
/*     */ 
/* 329 */   private transient ThreadLocal threadInfo = new ThreadLocal();
/*     */ 
/*     */   public static ClientUserTransaction getSingleton()
/*     */   {
/*  85 */     if (singleton == null)
/*  86 */       singleton = new ClientUserTransaction();
/*  87 */     return singleton;
/*     */   }
/*     */ 
/*     */   public void begin()
/*     */     throws NotSupportedException, SystemException
/*     */   {
/* 109 */     ThreadInfo info = getThreadInfo();
/*     */     try
/*     */     {
/* 113 */       Object tpc = getSession().begin(info.getTimeout());
/* 114 */       info.push(tpc);
/*     */     }
/*     */     catch (SystemException e)
/*     */     {
/* 118 */       throw e;
/*     */     }
/*     */     catch (RemoteException e)
/*     */     {
/* 123 */       destroySession();
/* 124 */       throw new SystemException(e.toString());
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 128 */       throw new SystemException(e.toString());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void commit()
/*     */     throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException
/*     */   {
/* 140 */     ThreadInfo info = getThreadInfo();
/*     */     try
/*     */     {
/* 144 */       getSession().commit(info.getTpc());
/* 145 */       info.pop();
/*     */     }
/*     */     catch (RollbackException e)
/*     */     {
/* 149 */       info.pop();
/* 150 */       throw e;
/*     */     }
/*     */     catch (HeuristicMixedException e)
/*     */     {
/* 154 */       throw e;
/*     */     }
/*     */     catch (HeuristicRollbackException e)
/*     */     {
/* 158 */       throw e;
/*     */     }
/*     */     catch (SecurityException e)
/*     */     {
/* 162 */       throw e;
/*     */     }
/*     */     catch (SystemException e)
/*     */     {
/* 166 */       throw e;
/*     */     }
/*     */     catch (IllegalStateException e)
/*     */     {
/* 170 */       throw e;
/*     */     }
/*     */     catch (RemoteException e)
/*     */     {
/* 175 */       destroySession();
/* 176 */       throw new SystemException(e.toString());
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 180 */       throw new SystemException(e.toString());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void rollback()
/*     */     throws SecurityException, IllegalStateException, SystemException
/*     */   {
/* 189 */     ThreadInfo info = getThreadInfo();
/*     */     try
/*     */     {
/* 193 */       getSession().rollback(info.getTpc());
/* 194 */       info.pop();
/*     */     }
/*     */     catch (SecurityException e)
/*     */     {
/* 198 */       throw e;
/*     */     }
/*     */     catch (SystemException e)
/*     */     {
/* 202 */       throw e;
/*     */     }
/*     */     catch (IllegalStateException e)
/*     */     {
/* 206 */       throw e;
/*     */     }
/*     */     catch (RemoteException e)
/*     */     {
/* 211 */       destroySession();
/* 212 */       throw new SystemException(e.toString());
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 216 */       throw new SystemException(e.toString());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setRollbackOnly()
/*     */     throws IllegalStateException, SystemException
/*     */   {
/* 224 */     ThreadInfo info = getThreadInfo();
/*     */     try
/*     */     {
/* 228 */       getSession().setRollbackOnly(info.getTpc());
/*     */     }
/*     */     catch (SystemException e)
/*     */     {
/* 232 */       throw e;
/*     */     }
/*     */     catch (IllegalStateException e)
/*     */     {
/* 236 */       throw e;
/*     */     }
/*     */     catch (RemoteException e)
/*     */     {
/* 241 */       destroySession();
/* 242 */       throw new SystemException(e.toString());
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 246 */       throw new SystemException(e.toString());
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getStatus()
/*     */     throws SystemException
/*     */   {
/* 253 */     ThreadInfo info = getThreadInfo();
/* 254 */     Object tpc = info.getTpc();
/*     */ 
/* 256 */     if (tpc == null)
/*     */     {
/* 258 */       return 6;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 263 */       return getSession().getStatus(tpc);
/*     */     }
/*     */     catch (SystemException e)
/*     */     {
/* 267 */       throw e;
/*     */     }
/*     */     catch (RemoteException e)
/*     */     {
/* 272 */       destroySession();
/* 273 */       throw new SystemException(e.toString());
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 277 */     throw new SystemException(e.toString());
/*     */   }
/*     */ 
/*     */   public void setTransactionTimeout(int seconds)
/*     */     throws SystemException
/*     */   {
/* 284 */     getThreadInfo().setTimeout(seconds);
/*     */   }
/*     */ 
/*     */   public Object getTransactionPropagationContext()
/*     */   {
/* 294 */     return getThreadInfo().getTpc();
/*     */   }
/*     */ 
/*     */   public Object getTransactionPropagationContext(Transaction tx)
/*     */   {
/* 300 */     throw new InternalError("Should not have been used.");
/*     */   }
/*     */ 
/*     */   public Reference getReference()
/*     */     throws NamingException
/*     */   {
/* 311 */     Reference ref = new Reference("org.jboss.tm.usertx.client.ClientUserTransaction", "org.jboss.tm.usertx.client.ClientUserTransactionObjectFactory", null);
/*     */ 
/* 315 */     return ref;
/*     */   }
/*     */ 
/*     */   private synchronized void createSession()
/*     */   {
/* 338 */     if (this.session != null) {
/* 339 */       destroySession();
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 345 */       Hashtable env = (Hashtable)NamingContextFactory.lastInitialContextEnv.get();
/* 346 */       InitialContext ctx = new InitialContext(env);
/* 347 */       UserTransactionSessionFactory factory = (UserTransactionSessionFactory)ctx.lookup("UserTransactionSessionFactory");
/*     */ 
/* 349 */       this.session = factory.newInstance();
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 353 */       throw new RuntimeException("UT factory lookup failed", ex);
/*     */     }
/*     */   }
/*     */ 
/*     */   private synchronized void destroySession()
/*     */   {
/* 362 */     if (this.session != null)
/*     */     {
/*     */       try
/*     */       {
/* 366 */         this.session.destroy();
/*     */       }
/*     */       catch (RemoteException ex)
/*     */       {
/*     */       }
/*     */ 
/* 372 */       this.session = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   private synchronized UserTransactionSession getSession()
/*     */   {
/* 382 */     if (this.session == null)
/* 383 */       createSession();
/* 384 */     return this.session;
/*     */   }
/*     */ 
/*     */   private ThreadInfo getThreadInfo()
/*     */   {
/* 393 */     ThreadInfo ret = (ThreadInfo)this.threadInfo.get();
/*     */ 
/* 395 */     if (ret == null)
/*     */     {
/* 397 */       ret = new ThreadInfo(null);
/* 398 */       this.threadInfo.set(ret);
/*     */     }
/*     */ 
/* 401 */     return ret;
/*     */   }
/*     */ 
/*     */   private class ThreadInfo
/*     */   {
/* 418 */     private LinkedList tpcStack = new LinkedList();
/*     */ 
/* 424 */     private int timeout = 0;
/*     */ 
/*     */     private ThreadInfo()
/*     */     {
/*     */     }
/*     */ 
/*     */     protected void finalize()
/*     */       throws Throwable
/*     */     {
/*     */       try
/*     */       {
/* 435 */         while (!this.tpcStack.isEmpty())
/*     */         {
/* 437 */           Object tpc = getTpc();
/* 438 */           pop();
/*     */           try
/*     */           {
/* 442 */             ClientUserTransaction.this.getSession().rollback(tpc);
/*     */           }
/*     */           catch (Exception ex)
/*     */           {
/*     */           }
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/*     */       }
/*     */ 
/* 454 */       super.finalize();
/*     */     }
/*     */ 
/*     */     void push(Object tpc)
/*     */     {
/* 462 */       this.tpcStack.addLast(tpc);
/*     */     }
/*     */ 
/*     */     void pop()
/*     */     {
/* 470 */       this.tpcStack.removeLast();
/*     */     }
/*     */ 
/*     */     Object getTpc()
/*     */     {
/* 478 */       return this.tpcStack.isEmpty() ? null : this.tpcStack.getLast();
/*     */     }
/*     */ 
/*     */     int getTimeout()
/*     */     {
/* 488 */       return this.timeout;
/*     */     }
/*     */ 
/*     */     void setTimeout(int seconds)
/*     */     {
/* 497 */       this.timeout = seconds;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.tm.usertx.client.ClientUserTransaction
 * JD-Core Version:    0.6.0
 */