/*     */ package org.jboss.tm.usertx.server;
/*     */ 
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.UndeclaredThrowableException;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.invocation.MarshalledInvocation;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ import org.jboss.tm.usertx.client.ClientUserTransaction;
/*     */ import org.jboss.tm.usertx.interfaces.UserTransactionSession;
/*     */ import org.jboss.tm.usertx.interfaces.UserTransactionSessionFactory;
/*     */ 
/*     */ public class ClientUserTransactionService extends ServiceMBeanSupport
/*     */   implements ClientUserTransactionServiceMBean
/*     */ {
/*  56 */   public static String JNDI_NAME = "UserTransaction";
/*     */ 
/*  60 */   private Map marshalledInvocationMapping = new HashMap();
/*     */   private ObjectName txProxyName;
/*     */   private Object txProxy;
/*     */ 
/*     */   public void setTxProxyName(ObjectName proxyName)
/*     */   {
/*  72 */     this.txProxyName = proxyName;
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation)
/*     */     throws Exception
/*     */   {
/*  88 */     if ((invocation instanceof MarshalledInvocation))
/*     */     {
/*  90 */       MarshalledInvocation mi = (MarshalledInvocation)invocation;
/*  91 */       mi.setMethodMap(this.marshalledInvocationMapping);
/*     */     }
/*     */ 
/*  94 */     Method method = invocation.getMethod();
/*  95 */     Object[] args = invocation.getArguments();
/*  96 */     Object value = null;
/*     */     try
/*     */     {
/*  99 */       if (UserTransactionSessionFactory.class.isAssignableFrom(method.getDeclaringClass()))
/*     */       {
/* 102 */         value = this.txProxy;
/*     */       }
/* 104 */       else if (method.getName().equals("begin"))
/*     */       {
/* 107 */         Integer timeout = (Integer)args[0];
/* 108 */         UserTransactionSession session = UserTransactionSessionImpl.getInstance();
/* 109 */         value = session.begin(timeout.intValue());
/*     */       }
/* 111 */       else if (!method.getName().equals("destroy"))
/*     */       {
/* 120 */         UserTransactionSession session = UserTransactionSessionImpl.getInstance();
/* 121 */         value = method.invoke(session, args);
/*     */       }
/*     */     }
/*     */     catch (InvocationTargetException e)
/*     */     {
/* 126 */       Throwable t = e.getTargetException();
/* 127 */       if ((t instanceof Exception)) {
/* 128 */         throw ((Exception)t);
/*     */       }
/* 130 */       throw new UndeclaredThrowableException(t, method.toString());
/*     */     }
/*     */ 
/* 133 */     return value;
/*     */   }
/*     */ 
/*     */   protected void startService()
/*     */     throws Exception
/*     */   {
/* 141 */     Context ctx = new InitialContext();
/*     */ 
/* 143 */     ctx.bind(JNDI_NAME, ClientUserTransaction.getSingleton());
/*     */ 
/* 146 */     this.txProxy = getServer().getAttribute(this.txProxyName, "Proxy");
/*     */ 
/* 149 */     HashMap tmpMap = new HashMap(13);
/* 150 */     Method[] methods = UserTransactionSession.class.getMethods();
/* 151 */     for (int m = 0; m < methods.length; m++)
/*     */     {
/* 153 */       Method method = methods[m];
/* 154 */       Long hash = new Long(MarshalledInvocation.calculateHash(method));
/* 155 */       tmpMap.put(hash, method);
/*     */     }
/*     */ 
/* 158 */     methods = UserTransactionSessionFactory.class.getMethods();
/* 159 */     for (int m = 0; m < methods.length; m++)
/*     */     {
/* 161 */       Method method = methods[m];
/* 162 */       Long hash = new Long(MarshalledInvocation.calculateHash(method));
/* 163 */       tmpMap.put(hash, method);
/*     */     }
/* 165 */     this.marshalledInvocationMapping = Collections.unmodifiableMap(tmpMap);
/*     */   }
/*     */ 
/*     */   protected void stopService()
/*     */   {
/*     */     try
/*     */     {
/* 172 */       Context ctx = new InitialContext();
/* 173 */       ctx.unbind(JNDI_NAME);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 177 */       this.log.warn("Failed to unbind " + JNDI_NAME, e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.tm.usertx.server.ClientUserTransactionService
 * JD-Core Version:    0.6.0
 */