/*     */ package org.jboss.tm.usertx.server;
/*     */ 
/*     */ import java.rmi.RemoteException;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import javax.transaction.HeuristicMixedException;
/*     */ import javax.transaction.HeuristicRollbackException;
/*     */ import javax.transaction.NotSupportedException;
/*     */ import javax.transaction.RollbackException;
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.TransactionManager;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.tm.TransactionPropagationContextFactory;
/*     */ import org.jboss.tm.TransactionPropagationContextUtil;
/*     */ import org.jboss.tm.usertx.interfaces.UserTransactionSession;
/*     */ import org.jboss.util.collection.WeakValueHashMap;
/*     */ 
/*     */ public class UserTransactionSessionImpl
/*     */   implements UserTransactionSession
/*     */ {
/*  58 */   private static TransactionManager tm = null;
/*  59 */   private static Logger log = Logger.getLogger(UserTransactionSessionImpl.class);
/*     */ 
/*  63 */   private static WeakValueHashMap activeTx = new WeakValueHashMap();
/*  64 */   private static UserTransactionSessionImpl instance = new UserTransactionSessionImpl();
/*     */ 
/*  92 */   private static TransactionPropagationContextFactory tpcFactory = null;
/*     */ 
/*     */   public static UserTransactionSession getInstance()
/*     */   {
/*  68 */     return instance;
/*     */   }
/*     */ 
/*     */   protected static TransactionManager getTransactionManager()
/*     */   {
/*  76 */     if (tm == null)
/*     */     {
/*     */       try
/*     */       {
/*  80 */         Context ctx = new InitialContext();
/*  81 */         tm = (TransactionManager)ctx.lookup("java:/TransactionManager");
/*     */       }
/*     */       catch (NamingException ex)
/*     */       {
/*  85 */         log.error("java:/TransactionManager lookup failed", ex);
/*     */       }
/*     */     }
/*  88 */     return tm;
/*     */   }
/*     */ 
/*     */   protected static TransactionPropagationContextFactory getTPCFactory()
/*     */   {
/*  99 */     if (tpcFactory == null)
/*     */     {
/* 101 */       tpcFactory = TransactionPropagationContextUtil.getTPCFactory();
/*     */     }
/* 103 */     return tpcFactory;
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */     throws RemoteException
/*     */   {
/* 116 */     unreferenced();
/*     */   }
/*     */ 
/*     */   public Object begin(int timeout)
/*     */     throws RemoteException, NotSupportedException, SystemException
/*     */   {
/* 131 */     TransactionManager tm = getTransactionManager();
/*     */ 
/* 133 */     tm.setTransactionTimeout(timeout);
/*     */ 
/* 135 */     tm.begin();
/* 136 */     Object tpc = getTPCFactory().getTransactionPropagationContext();
/*     */ 
/* 138 */     Transaction tx = tm.suspend();
/*     */ 
/* 140 */     activeTx.put(tpc, tx);
/*     */ 
/* 142 */     return tpc;
/*     */   }
/*     */ 
/*     */   public void commit(Object tpc)
/*     */     throws RemoteException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException
/*     */   {
/* 159 */     Transaction tx = (Transaction)activeTx.get(tpc);
/*     */ 
/* 161 */     if (tx == null) {
/* 162 */       throw new IllegalStateException("No transaction.");
/*     */     }
/*     */ 
/* 165 */     TransactionManager tm = getTransactionManager();
/* 166 */     tm.resume(tx);
/*     */ 
/* 168 */     boolean finished = true;
/*     */     try
/*     */     {
/* 172 */       tm.commit();
/*     */     }
/*     */     catch (SecurityException ex)
/*     */     {
/* 176 */       finished = false;
/* 177 */       throw ex;
/*     */     }
/*     */     catch (IllegalStateException ex)
/*     */     {
/* 181 */       finished = false;
/* 182 */       throw ex;
/*     */     }
/*     */     finally
/*     */     {
/* 186 */       activeTx.remove(tpc);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void rollback(Object tpc)
/*     */     throws RemoteException, SecurityException, IllegalStateException, SystemException
/*     */   {
/* 201 */     Transaction tx = (Transaction)activeTx.get(tpc);
/*     */ 
/* 203 */     if (tx == null) {
/* 204 */       throw new IllegalStateException("No transaction.");
/*     */     }
/*     */ 
/* 207 */     TransactionManager tm = getTransactionManager();
/* 208 */     tm.resume(tx);
/*     */ 
/* 210 */     tm.rollback();
/* 211 */     activeTx.remove(tpc);
/*     */   }
/*     */ 
/*     */   public void setRollbackOnly(Object tpc)
/*     */     throws RemoteException, IllegalStateException, SystemException
/*     */   {
/* 224 */     Transaction tx = (Transaction)activeTx.get(tpc);
/*     */ 
/* 226 */     if (tx == null) {
/* 227 */       throw new IllegalStateException("No transaction.");
/*     */     }
/* 229 */     tx.setRollbackOnly();
/*     */   }
/*     */ 
/*     */   public int getStatus(Object tpc)
/*     */     throws RemoteException, SystemException
/*     */   {
/* 241 */     Transaction tx = (Transaction)activeTx.get(tpc);
/*     */ 
/* 243 */     if (tx == null) {
/* 244 */       return 6;
/*     */     }
/* 246 */     return tx.getStatus();
/*     */   }
/*     */ 
/*     */   public void unreferenced()
/*     */   {
/* 260 */     log.debug("Lost connection to UserTransaction client.");
/*     */ 
/* 262 */     if (!activeTx.isEmpty())
/*     */     {
/* 264 */       log.error("Lost connection to UserTransaction clients: Rolling back " + activeTx.size() + " active transaction(s).");
/*     */ 
/* 267 */       Collection txs = activeTx.values();
/* 268 */       Iterator iter = txs.iterator();
/* 269 */       while (iter.hasNext())
/*     */       {
/* 271 */         Transaction tx = (Transaction)iter.next();
/*     */         try
/*     */         {
/* 274 */           tx.rollback();
/*     */         }
/*     */         catch (Exception ex)
/*     */         {
/* 278 */           log.error("rollback failed", ex);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.tm.usertx.server.UserTransactionSessionImpl
 * JD-Core Version:    0.6.0
 */