/*     */ package org.jboss.util;
/*     */ 
/*     */ import java.lang.reflect.Array;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Modifier;
/*     */ import java.net.URL;
/*     */ import java.security.AccessController;
/*     */ import java.security.CodeSource;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.security.ProtectionDomain;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ 
/*     */ public final class Classes
/*     */ {
/*     */   public static final String PACKAGE_SEPARATOR = ".";
/*     */   public static final char PACKAGE_SEPARATOR_CHAR = '.';
/*     */   public static final String DEFAULT_PACKAGE_NAME = "<default>";
/* 335 */   private static final Map PRIMITIVE_NAME_TYPE_MAP = new HashMap();
/*     */   private static final Class[] PRIMITIVE_WRAPPER_MAP;
/*     */ 
/*     */   public static void displayClassInfo(Class clazz, StringBuffer results)
/*     */   {
/*  64 */     ClassLoader cl = clazz.getClassLoader();
/*  65 */     results.append("\n");
/*  66 */     results.append(clazz.getName());
/*  67 */     results.append("(");
/*  68 */     results.append(Integer.toHexString(clazz.hashCode()));
/*  69 */     results.append(").ClassLoader=");
/*  70 */     results.append(cl);
/*  71 */     ClassLoader parent = cl;
/*  72 */     while (parent != null)
/*     */     {
/*  74 */       results.append("\n..");
/*  75 */       results.append(parent);
/*  76 */       URL[] urls = getClassLoaderURLs(parent);
/*  77 */       int length = urls != null ? urls.length : 0;
/*  78 */       for (int u = 0; u < length; u++)
/*     */       {
/*  80 */         results.append("\n....");
/*  81 */         results.append(urls[u]);
/*     */       }
/*  83 */       if (parent != null)
/*  84 */         parent = parent.getParent();
/*     */     }
/*  86 */     CodeSource clazzCS = clazz.getProtectionDomain().getCodeSource();
/*  87 */     if (clazzCS != null)
/*     */     {
/*  89 */       results.append("\n++++CodeSource: ");
/*  90 */       results.append(clazzCS);
/*     */     }
/*     */     else {
/*  93 */       results.append("\n++++Null CodeSource");
/*     */     }
/*  95 */     results.append("\nImplemented Interfaces:");
/*  96 */     Class[] ifaces = clazz.getInterfaces();
/*  97 */     for (int i = 0; i < ifaces.length; i++)
/*     */     {
/*  99 */       Class iface = ifaces[i];
/* 100 */       results.append("\n++");
/* 101 */       results.append(iface);
/* 102 */       results.append("(");
/* 103 */       results.append(Integer.toHexString(iface.hashCode()));
/* 104 */       results.append(")");
/* 105 */       ClassLoader loader = ifaces[i].getClassLoader();
/* 106 */       results.append("\n++++ClassLoader: ");
/* 107 */       results.append(loader);
/* 108 */       ProtectionDomain pd = ifaces[i].getProtectionDomain();
/* 109 */       CodeSource cs = pd.getCodeSource();
/* 110 */       if (cs != null)
/*     */       {
/* 112 */         results.append("\n++++CodeSource: ");
/* 113 */         results.append(cs);
/*     */       }
/*     */       else {
/* 116 */         results.append("\n++++Null CodeSource");
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static URL[] getClassLoaderURLs(ClassLoader cl)
/*     */   {
/* 126 */     URL[] urls = new URL[0];
/*     */     try
/*     */     {
/* 129 */       Class returnType = urls.getClass();
/* 130 */       Class[] parameterTypes = new Class[0];
/* 131 */       Class clClass = cl.getClass();
/* 132 */       Method getURLs = clClass.getMethod("getURLs", parameterTypes);
/* 133 */       if (returnType.isAssignableFrom(getURLs.getReturnType()))
/*     */       {
/* 135 */         Object[] args = new Object[0];
/* 136 */         urls = (URL[])(URL[])getURLs.invoke(cl, args);
/*     */       }
/* 138 */       if ((urls == null) || (urls.length == 0))
/*     */       {
/* 140 */         Method getCp = clClass.getMethod("getClasspath", parameterTypes);
/* 141 */         if (returnType.isAssignableFrom(getCp.getReturnType()))
/*     */         {
/* 143 */           Object[] args = new Object[0];
/* 144 */           urls = (URL[])(URL[])getCp.invoke(cl, args);
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Exception ignore)
/*     */     {
/*     */     }
/* 151 */     return urls;
/*     */   }
/*     */ 
/*     */   public static String getDescription(Object object)
/*     */   {
/* 162 */     StringBuffer buffer = new StringBuffer();
/* 163 */     describe(buffer, object);
/* 164 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   public static void describe(StringBuffer buffer, Object object)
/*     */   {
/* 175 */     if (object == null)
/* 176 */       buffer.append("**null**");
/*     */     else
/* 178 */       describe(buffer, object.getClass());
/*     */   }
/*     */ 
/*     */   public static void describe(StringBuffer buffer, Class clazz)
/*     */   {
/* 189 */     if (clazz == null) {
/* 190 */       buffer.append("**null**");
/*     */     }
/*     */     else {
/* 193 */       buffer.append("{class=").append(clazz.getName());
/* 194 */       Class[] intfs = clazz.getInterfaces();
/* 195 */       if (intfs.length > 0)
/*     */       {
/* 197 */         buffer.append(" intfs=");
/* 198 */         for (int i = 0; i < intfs.length; i++)
/*     */         {
/* 200 */           buffer.append(intfs[i].getName());
/* 201 */           if (i < intfs.length - 1)
/* 202 */             buffer.append(", ");
/*     */         }
/*     */       }
/* 205 */       buffer.append("}");
/*     */     }
/*     */   }
/*     */ 
/*     */   public static String stripPackageName(String classname)
/*     */   {
/* 218 */     int idx = classname.lastIndexOf(".");
/*     */ 
/* 220 */     if (idx != -1)
/* 221 */       return classname.substring(idx + 1, classname.length());
/* 222 */     return classname;
/*     */   }
/*     */ 
/*     */   public static String stripPackageName(Class type)
/*     */   {
/* 234 */     return stripPackageName(type.getName());
/*     */   }
/*     */ 
/*     */   public static String getPackageName(String classname)
/*     */   {
/* 248 */     if (classname.length() == 0) {
/* 249 */       throw new EmptyStringException();
/*     */     }
/* 251 */     int index = classname.lastIndexOf(".");
/* 252 */     if (index != -1)
/* 253 */       return classname.substring(0, index);
/* 254 */     return "";
/*     */   }
/*     */ 
/*     */   public static String getPackageName(Class type)
/*     */   {
/* 265 */     return getPackageName(type.getName());
/*     */   }
/*     */ 
/*     */   public static void forceLoad(Class type)
/*     */   {
/* 282 */     if (type == null) {
/* 283 */       throw new NullArgumentException("type");
/*     */     }
/*     */ 
/* 286 */     if (type.isPrimitive()) return;
/*     */ 
/* 289 */     String packageName = getPackageName(type);
/*     */ 
/* 292 */     if ((packageName.startsWith("java.")) || (packageName.startsWith("javax.")))
/*     */     {
/* 295 */       return;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 302 */       Method[] methods = type.getDeclaredMethods();
/* 303 */       Method method = null;
/* 304 */       for (int i = 0; i < methods.length; i++)
/*     */       {
/* 306 */         int modifiers = methods[i].getModifiers();
/* 307 */         if (!Modifier.isStatic(modifiers))
/*     */           continue;
/* 309 */         method = methods[i];
/* 310 */         break;
/*     */       }
/*     */ 
/* 314 */       if (method != null)
/*     */       {
/* 316 */         method.invoke(null, null);
/*     */       }
/*     */       else
/*     */       {
/* 320 */         type.newInstance();
/*     */       }
/*     */     }
/*     */     catch (Exception ignore)
/*     */     {
/* 325 */       ThrowableHandler.add(ignore);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static Class getPrimitiveTypeForName(String name)
/*     */   {
/* 363 */     return (Class)PRIMITIVE_NAME_TYPE_MAP.get(name);
/*     */   }
/*     */ 
/*     */   public static Class getPrimitiveWrapper(Class type)
/*     */   {
/* 388 */     if (!type.isPrimitive())
/*     */     {
/* 390 */       throw new IllegalArgumentException("type is not a primitive class");
/*     */     }
/*     */ 
/* 393 */     for (int i = 0; i < PRIMITIVE_WRAPPER_MAP.length; i += 2)
/*     */     {
/* 395 */       if (type.equals(PRIMITIVE_WRAPPER_MAP[i])) {
/* 396 */         return PRIMITIVE_WRAPPER_MAP[(i + 1)];
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 401 */     throw new UnreachableStatementException();
/*     */   }
/*     */ 
/*     */   public static void getAllInterfaces(List allIfaces, Class c)
/*     */   {
/* 413 */     while (c != null)
/*     */     {
/* 415 */       Class[] ifaces = c.getInterfaces();
/* 416 */       for (int n = 0; n < ifaces.length; n++)
/*     */       {
/* 418 */         allIfaces.add(ifaces[n]);
/*     */       }
/* 420 */       c = c.getSuperclass();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static Class[] getAllUniqueInterfaces(Class c)
/*     */   {
/* 433 */     Set uniqueIfaces = new HashSet();
/* 434 */     while (c != null)
/*     */     {
/* 436 */       Class[] ifaces = c.getInterfaces();
/* 437 */       for (int n = 0; n < ifaces.length; n++)
/*     */       {
/* 439 */         uniqueIfaces.add(ifaces[n]);
/*     */       }
/* 441 */       c = c.getSuperclass();
/*     */     }
/* 443 */     return (Class[])(Class[])uniqueIfaces.toArray(new Class[uniqueIfaces.size()]);
/*     */   }
/*     */ 
/*     */   public static boolean isPrimitiveWrapper(Class type)
/*     */   {
/* 454 */     for (int i = 0; i < PRIMITIVE_WRAPPER_MAP.length; i += 2)
/*     */     {
/* 456 */       if (type.equals(PRIMITIVE_WRAPPER_MAP[(i + 1)]))
/*     */       {
/* 458 */         return true;
/*     */       }
/*     */     }
/*     */ 
/* 462 */     return false;
/*     */   }
/*     */ 
/*     */   public static boolean isPrimitive(Class type)
/*     */   {
/* 476 */     return (type.isPrimitive()) || (isPrimitiveWrapper(type));
/*     */   }
/*     */ 
/*     */   public static boolean isPrimitive(String type)
/*     */   {
/* 487 */     return PRIMITIVE_NAME_TYPE_MAP.containsKey(type);
/*     */   }
/*     */ 
/*     */   public static Class getPrimitive(Class wrapper)
/*     */   {
/*     */     Class primitive;
/* 497 */     if (Integer.class == wrapper)
/*     */     {
/* 499 */       primitive = Integer.TYPE;
/*     */     }
/*     */     else
/*     */     {
/*     */       Class primitive;
/* 501 */       if (Long.class == wrapper)
/*     */       {
/* 503 */         primitive = Long.TYPE;
/*     */       }
/*     */       else
/*     */       {
/*     */         Class primitive;
/* 505 */         if (Double.class == wrapper)
/*     */         {
/* 507 */           primitive = Double.TYPE;
/*     */         }
/*     */         else
/*     */         {
/*     */           Class primitive;
/* 509 */           if (Boolean.class == wrapper)
/*     */           {
/* 511 */             primitive = Boolean.TYPE;
/*     */           }
/*     */           else
/*     */           {
/*     */             Class primitive;
/* 513 */             if (Short.class == wrapper)
/*     */             {
/* 515 */               primitive = Short.TYPE;
/*     */             }
/*     */             else
/*     */             {
/*     */               Class primitive;
/* 517 */               if (Float.class == wrapper)
/*     */               {
/* 519 */                 primitive = Float.TYPE;
/*     */               }
/*     */               else
/*     */               {
/*     */                 Class primitive;
/* 521 */                 if (Byte.class == wrapper)
/*     */                 {
/* 523 */                   primitive = Byte.TYPE;
/*     */                 }
/*     */                 else
/*     */                 {
/*     */                   Class primitive;
/* 525 */                   if (Character.class == wrapper)
/*     */                   {
/* 527 */                     primitive = Character.TYPE;
/*     */                   }
/*     */                   else
/*     */                   {
/* 531 */                     throw new IllegalArgumentException("The class is not a primitive wrapper type: " + wrapper);
/*     */                   }
/*     */                 }
/*     */               }
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */     Class primitive;
/* 533 */     return primitive;
/*     */   }
/*     */ 
/*     */   public static Object instantiate(Class expected, String property, String defaultClassName)
/*     */   {
/* 546 */     String className = getProperty(property, defaultClassName);
/* 547 */     Class clazz = null;
/*     */     try
/*     */     {
/* 550 */       clazz = loadClass(className);
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/* 554 */       throw new NestedRuntimeException("Cannot load class " + className, e);
/*     */     }
/* 556 */     Object result = null;
/*     */     try
/*     */     {
/* 559 */       result = clazz.newInstance();
/*     */     }
/*     */     catch (InstantiationException e)
/*     */     {
/* 563 */       throw new NestedRuntimeException("Error instantiating " + className, e);
/*     */     }
/*     */     catch (IllegalAccessException e)
/*     */     {
/* 567 */       throw new NestedRuntimeException("Error instantiating " + className, e);
/*     */     }
/* 569 */     if (!expected.isAssignableFrom(clazz)) {
/* 570 */       throw new NestedRuntimeException("Class " + className + " from classloader " + clazz.getClassLoader() + " is not of the expected class " + expected + " loaded from " + expected.getClassLoader());
/*     */     }
/* 572 */     return result;
/*     */   }
/*     */ 
/*     */   public static Class loadClass(String className)
/*     */     throws ClassNotFoundException
/*     */   {
/* 593 */     return loadClass(className, Thread.currentThread().getContextClassLoader());
/*     */   }
/*     */ 
/*     */   public static Class loadClass(String className, ClassLoader classLoader)
/*     */     throws ClassNotFoundException
/*     */   {
/* 625 */     if (className.length() == 1)
/*     */     {
/* 627 */       char type = className.charAt(0);
/* 628 */       if (type == 'B') return Byte.TYPE;
/* 629 */       if (type == 'C') return Character.TYPE;
/* 630 */       if (type == 'D') return Double.TYPE;
/* 631 */       if (type == 'F') return Float.TYPE;
/* 632 */       if (type == 'I') return Integer.TYPE;
/* 633 */       if (type == 'J') return Long.TYPE;
/* 634 */       if (type == 'S') return Short.TYPE;
/* 635 */       if (type == 'Z') return Boolean.TYPE;
/* 636 */       if (type == 'V') return Void.TYPE;
/*     */ 
/* 638 */       throw new ClassNotFoundException(className);
/*     */     }
/*     */ 
/* 642 */     if (isPrimitive(className) == true) {
/* 643 */       return (Class)PRIMITIVE_NAME_TYPE_MAP.get(className);
/*     */     }
/*     */ 
/* 646 */     if ((className.charAt(0) == 'L') && (className.charAt(className.length() - 1) == ';'))
/* 647 */       return classLoader.loadClass(className.substring(1, className.length() - 1));
/*     */     int arrayDimension;
/*     */     Class componentType;
/*     */     try
/*     */     {
/* 654 */       return classLoader.loadClass(className);
/*     */     }
/*     */     catch (ClassNotFoundException arrayDimension)
/*     */     {
/* 659 */       if (className.charAt(0) != '[') {
/* 660 */         throw e;
/*     */       }
/*     */ 
/* 666 */       arrayDimension = 0;
/* 667 */       while (className.charAt(arrayDimension) == '[') {
/* 668 */         arrayDimension++;
/*     */       }
/*     */ 
/* 671 */       componentType = loadClass(className.substring(arrayDimension), classLoader);
/*     */     }
/*     */ 
/* 674 */     return Array.newInstance(componentType, new int[arrayDimension]).getClass();
/*     */   }
/*     */ 
/*     */   public static final Class[] convertToJavaClasses(Iterator it, ClassLoader cl)
/*     */     throws ClassNotFoundException
/*     */   {
/* 693 */     ArrayList classes = new ArrayList();
/* 694 */     while (it.hasNext())
/*     */     {
/* 696 */       classes.add(convertToJavaClass((String)it.next(), cl));
/*     */     }
/* 698 */     return (Class[])(Class[])classes.toArray(new Class[classes.size()]);
/*     */   }
/*     */ 
/*     */   public static final Method getAttributeGetter(Class cls, String attr)
/*     */     throws NoSuchMethodException
/*     */   {
/* 710 */     StringBuffer buf = new StringBuffer(attr.length() + 3);
/* 711 */     buf.append("get");
/* 712 */     if (Character.isLowerCase(attr.charAt(0)))
/*     */     {
/* 714 */       buf.append(Character.toUpperCase(attr.charAt(0))).append(attr.substring(1));
/*     */     }
/*     */     else
/*     */     {
/* 719 */       buf.append(attr);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 724 */       return cls.getMethod(buf.toString(), null);
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/* 728 */       buf.replace(0, 3, "is");
/* 729 */     }return cls.getMethod(buf.toString(), null);
/*     */   }
/*     */ 
/*     */   public static final Method getAttributeSetter(Class cls, String attr, Class type)
/*     */     throws NoSuchMethodException
/*     */   {
/* 743 */     StringBuffer buf = new StringBuffer(attr.length() + 3);
/* 744 */     buf.append("set");
/* 745 */     if (Character.isLowerCase(attr.charAt(0)))
/*     */     {
/* 747 */       buf.append(Character.toUpperCase(attr.charAt(0))).append(attr.substring(1));
/*     */     }
/*     */     else
/*     */     {
/* 752 */       buf.append(attr);
/*     */     }
/*     */ 
/* 755 */     return cls.getMethod(buf.toString(), new Class[] { type });
/*     */   }
/*     */ 
/*     */   private static final Class convertToJavaClass(String name, ClassLoader cl)
/*     */     throws ClassNotFoundException
/*     */   {
/* 773 */     int arraySize = 0;
/* 774 */     while (name.endsWith("[]"))
/*     */     {
/* 776 */       name = name.substring(0, name.length() - 2);
/* 777 */       arraySize++;
/*     */     }
/*     */ 
/* 781 */     Class c = (Class)PRIMITIVE_NAME_TYPE_MAP.get(name);
/*     */ 
/* 783 */     if (c == null)
/*     */     {
/*     */       try
/*     */       {
/* 788 */         c = cl.loadClass(name);
/*     */       }
/*     */       catch (ClassNotFoundException cnfe)
/*     */       {
/* 792 */         throw new ClassNotFoundException("Parameter class not found: " + name);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 798 */     if (arraySize > 0)
/*     */     {
/* 800 */       int[] dims = new int[arraySize];
/* 801 */       for (int i = 0; i < arraySize; i++)
/*     */       {
/* 803 */         dims[i] = 1;
/*     */       }
/* 805 */       c = Array.newInstance(c, dims).getClass();
/*     */     }
/*     */ 
/* 808 */     return c;
/*     */   }
/*     */ 
/*     */   private static String getProperty(String name, String defaultValue)
/*     */   {
/* 819 */     return (String)AccessController.doPrivileged(new PrivilegedAction(name, defaultValue)
/*     */     {
/*     */       public Object run()
/*     */       {
/* 824 */         return System.getProperty(this.val$name, this.val$defaultValue);
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/* 340 */     PRIMITIVE_NAME_TYPE_MAP.put("boolean", Boolean.TYPE);
/* 341 */     PRIMITIVE_NAME_TYPE_MAP.put("byte", Byte.TYPE);
/* 342 */     PRIMITIVE_NAME_TYPE_MAP.put("char", Character.TYPE);
/* 343 */     PRIMITIVE_NAME_TYPE_MAP.put("short", Short.TYPE);
/* 344 */     PRIMITIVE_NAME_TYPE_MAP.put("int", Integer.TYPE);
/* 345 */     PRIMITIVE_NAME_TYPE_MAP.put("long", Long.TYPE);
/* 346 */     PRIMITIVE_NAME_TYPE_MAP.put("float", Float.TYPE);
/* 347 */     PRIMITIVE_NAME_TYPE_MAP.put("double", Double.TYPE);
/*     */ 
/* 367 */     PRIMITIVE_WRAPPER_MAP = new Class[] { Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Character.TYPE, Character.class, Double.TYPE, Double.class, Float.TYPE, Float.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Short.TYPE, Short.class };
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.Classes
 * JD-Core Version:    0.6.0
 */