/*     */ package org.jboss.util;
/*     */ 
/*     */ import java.util.Comparator;
/*     */ 
/*     */ public class Heap
/*     */ {
/*     */   private Comparator m_comparator;
/*     */   private int m_count;
/*     */   private Object[] m_nodes;
/*     */ 
/*     */   public Heap()
/*     */   {
/*  47 */     this(null);
/*     */   }
/*     */ 
/*     */   public Heap(Comparator comparator)
/*     */   {
/*  56 */     this.m_comparator = comparator;
/*  57 */     clear();
/*     */   }
/*     */ 
/*     */   public void insert(Object obj)
/*     */   {
/*  67 */     int length = this.m_nodes.length;
/*     */ 
/*  69 */     if (this.m_count == length)
/*     */     {
/*  71 */       Object[] newNodes = new Object[length + length];
/*  72 */       System.arraycopy(this.m_nodes, 0, newNodes, 0, length);
/*  73 */       this.m_nodes = newNodes;
/*     */     }
/*     */ 
/*  82 */     int k = this.m_count;
/*  83 */     while (k > 0)
/*     */     {
/*  85 */       int par = parent(k);
/*  86 */       if (compare(obj, this.m_nodes[par]) >= 0)
/*     */         break;
/*  88 */       this.m_nodes[k] = this.m_nodes[par];
/*  89 */       k = par;
/*     */     }
/*     */ 
/*  93 */     this.m_nodes[k] = obj;
/*  94 */     this.m_count += 1;
/*     */   }
/*     */ 
/*     */   public Object extract()
/*     */   {
/* 105 */     if (this.m_count < 1) return null;
/*     */ 
/* 108 */     int length = this.m_nodes.length >> 1;
/*     */ 
/* 110 */     if ((length > 5) && (this.m_count < length >> 1))
/*     */     {
/* 112 */       Object[] newNodes = new Object[length];
/* 113 */       System.arraycopy(this.m_nodes, 0, newNodes, 0, length);
/* 114 */       this.m_nodes = newNodes;
/*     */     }
/*     */ 
/* 117 */     int k = 0;
/* 118 */     Object ret = this.m_nodes[k];
/* 119 */     this.m_count -= 1;
/* 120 */     Object last = this.m_nodes[this.m_count];
/*     */     while (true)
/*     */     {
/* 123 */       int l = left(k);
/* 124 */       if (l >= this.m_count) {
/*     */         break;
/*     */       }
/* 127 */       int r = right(k);
/* 128 */       int child = (r >= this.m_count) || (compare(this.m_nodes[l], this.m_nodes[r]) < 0) ? l : r;
/* 129 */       if (compare(last, this.m_nodes[child]) <= 0)
/*     */         break;
/* 131 */       this.m_nodes[k] = this.m_nodes[child];
/* 132 */       k = child;
/*     */     }
/*     */ 
/* 137 */     this.m_nodes[k] = last;
/* 138 */     this.m_nodes[this.m_count] = null;
/* 139 */     return ret;
/*     */   }
/*     */ 
/*     */   public Object peek()
/*     */   {
/* 150 */     if (this.m_count < 1) return null;
/* 151 */     return this.m_nodes[0];
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/* 159 */     this.m_count = 0;
/* 160 */     this.m_nodes = new Object[10];
/*     */   }
/*     */ 
/*     */   protected int compare(Object o1, Object o2)
/*     */   {
/* 172 */     if (this.m_comparator != null)
/*     */     {
/* 174 */       return this.m_comparator.compare(o1, o2);
/*     */     }
/*     */ 
/* 178 */     if (o1 == null)
/*     */     {
/* 180 */       if (o2 == null) return 0;
/* 181 */       return -((Comparable)o2).compareTo(o1);
/*     */     }
/* 183 */     return ((Comparable)o1).compareTo(o2);
/*     */   }
/*     */ 
/*     */   protected int parent(int index)
/*     */   {
/* 192 */     return index - 1 >> 1;
/*     */   }
/*     */ 
/*     */   protected int left(int index)
/*     */   {
/* 200 */     return index + index + 1;
/*     */   }
/*     */ 
/*     */   protected int right(int index)
/*     */   {
/* 208 */     return index + index + 2;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.Heap
 * JD-Core Version:    0.6.0
 */