/*     */ package org.jboss.util;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import org.apache.avalon.framework.configuration.Configuration;
/*     */ import org.apache.avalon.framework.configuration.ConfigurationException;
/*     */ import org.apache.avalon.framework.logger.Log4JLogger;
/*     */ import org.jacorb.config.LoggerFactory;
/*     */ import org.jboss.logging.LoggerPlugin;
/*     */ import org.jboss.logging.log4j.Log4jLoggerPlugin;
/*     */ 
/*     */ public class Log4jLoggerFactory
/*     */   implements LoggerFactory
/*     */ {
/*     */   private static final String name = "log4j";
/*  48 */   private final Map namedLoggers = new HashMap();
/*     */ 
/*     */   private static org.apache.log4j.Logger getLog4jLogger(String name)
/*     */   {
/*  60 */     org.jboss.logging.Logger l = org.jboss.logging.Logger.getLogger(name);
/*  61 */     LoggerPlugin lp = l.getLoggerPlugin();
/*  62 */     if ((lp instanceof Log4jLoggerPlugin)) {
/*  63 */       return ((Log4jLoggerPlugin)lp).getLogger();
/*     */     }
/*     */ 
/*  66 */     return null;
/*     */   }
/*     */ 
/*     */   public void configure(Configuration configuration)
/*     */     throws ConfigurationException
/*     */   {
/*     */   }
/*     */ 
/*     */   public final String getLoggingBackendName()
/*     */   {
/*  87 */     return "log4j";
/*     */   }
/*     */ 
/*     */   public org.apache.avalon.framework.logger.Logger getNamedLogger(String name)
/*     */   {
/*  99 */     Object o = this.namedLoggers.get(name);
/*     */ 
/* 101 */     if (o != null) {
/* 102 */       return (org.apache.avalon.framework.logger.Logger)o;
/*     */     }
/* 104 */     org.apache.log4j.Logger log4jLogger = getLog4jLogger(name);
/* 105 */     org.apache.avalon.framework.logger.Logger logger = new Log4JLogger(log4jLogger);
/*     */ 
/* 107 */     this.namedLoggers.put(name, logger);
/* 108 */     return logger;
/*     */   }
/*     */ 
/*     */   public org.apache.avalon.framework.logger.Logger getNamedRootLogger(String name)
/*     */   {
/* 120 */     return getNamedLogger(name);
/*     */   }
/*     */ 
/*     */   public org.apache.avalon.framework.logger.Logger getNamedLogger(String name, String logFileName, long maxLogSize)
/*     */     throws IOException
/*     */   {
/* 138 */     return null;
/*     */   }
/*     */ 
/*     */   public void setDefaultLogFile(String fileName, long maxLogSize)
/*     */     throws IOException
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.Log4jLoggerFactory
 * JD-Core Version:    0.6.0
 */