/*     */ package org.jboss.util;
/*     */ 
/*     */ public final class Primitives
/*     */ {
/*     */   public static Boolean valueOf(boolean value)
/*     */   {
/*  40 */     if (value) {
/*  41 */       return Boolean.TRUE;
/*     */     }
/*  43 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public static boolean equals(double a, double b)
/*     */   {
/*  55 */     return Double.doubleToLongBits(a) == Double.doubleToLongBits(b);
/*     */   }
/*     */ 
/*     */   public static boolean equals(float a, float b)
/*     */   {
/*  67 */     return Float.floatToIntBits(a) == Float.floatToIntBits(b);
/*     */   }
/*     */ 
/*     */   public static boolean equals(byte[] a, int abegin, byte[] b, int bbegin, int length)
/*     */   {
/*     */     try
/*     */     {
/*  85 */       int i = length;
/*     */       while (true) { i--; if (i < 0) break;
/*  87 */         if (a[(abegin + i)] != b[(bbegin + i)])
/*  88 */           return false;
/*     */       }
/*     */     }
/*     */     catch (ArrayIndexOutOfBoundsException e)
/*     */     {
/*  93 */       return false;
/*     */     }
/*     */ 
/*  96 */     return true;
/*     */   }
/*     */ 
/*     */   public static boolean equals(byte[] a, byte[] b)
/*     */   {
/* 107 */     if (a == b) return true;
/* 108 */     if ((a == null) || (b == null)) return false;
/* 109 */     if (a.length != b.length) return false;
/*     */     try
/*     */     {
/* 112 */       for (int i = 0; i < a.length; i++) {
/* 113 */         if (a[i] != b[i])
/* 114 */           return false;
/*     */       }
/*     */     }
/*     */     catch (ArrayIndexOutOfBoundsException e)
/*     */     {
/* 119 */       return false;
/*     */     }
/*     */ 
/* 122 */     return true;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.Primitives
 * JD-Core Version:    0.6.0
 */