/*     */ package org.jboss.util;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ 
/*     */ public class StopWatch
/*     */   implements Serializable, Cloneable
/*     */ {
/*  36 */   protected long total = 0L;
/*     */ 
/*  39 */   protected long start = -1L;
/*     */ 
/*  42 */   protected long stop = -1L;
/*     */ 
/*  45 */   protected int count = 0;
/*     */ 
/*  48 */   protected boolean running = false;
/*     */ 
/*     */   public StopWatch()
/*     */   {
/*     */   }
/*     */ 
/*     */   public StopWatch(boolean running)
/*     */   {
/*  62 */     if (running) start();
/*     */   }
/*     */ 
/*     */   public void start(boolean reset)
/*     */   {
/*  72 */     if (!this.running) {
/*  73 */       if (reset) reset();
/*  74 */       this.start = System.currentTimeMillis();
/*  75 */       this.running = true;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void start()
/*     */   {
/*  84 */     start(false);
/*     */   }
/*     */ 
/*     */   public long stop()
/*     */   {
/*  94 */     long lap = 0L;
/*     */ 
/*  96 */     if (this.running) {
/*  97 */       this.count += 1;
/*  98 */       this.stop = System.currentTimeMillis();
/*  99 */       lap = this.stop - this.start;
/* 100 */       this.total += lap;
/* 101 */       this.running = false;
/*     */     }
/*     */ 
/* 104 */     return lap;
/*     */   }
/*     */ 
/*     */   public void reset()
/*     */   {
/* 112 */     this.start = -1L;
/* 113 */     this.stop = -1L;
/* 114 */     this.total = 0L;
/* 115 */     this.count = 0;
/* 116 */     this.running = false;
/*     */   }
/*     */ 
/*     */   public int getLapCount()
/*     */   {
/* 126 */     return this.count;
/*     */   }
/*     */ 
/*     */   public long getLapTime()
/*     */   {
/* 136 */     if (this.start == -1L) {
/* 137 */       return 0L;
/*     */     }
/* 139 */     if (this.running) {
/* 140 */       return System.currentTimeMillis() - this.start;
/*     */     }
/*     */ 
/* 143 */     return this.stop - this.start;
/*     */   }
/*     */ 
/*     */   public long getAverageLapTime()
/*     */   {
/* 154 */     return this.count == 0 ? 0L : getLapTime() / getLapCount();
/*     */   }
/*     */ 
/*     */   public long getTime()
/*     */   {
/* 164 */     if (this.start == -1L) {
/* 165 */       return 0L;
/*     */     }
/* 167 */     if (this.running) {
/* 168 */       return this.total + System.currentTimeMillis() - this.start;
/*     */     }
/*     */ 
/* 171 */     return this.total;
/*     */   }
/*     */ 
/*     */   public boolean isRunning()
/*     */   {
/* 182 */     return this.running;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 190 */     StringBuffer buff = new StringBuffer();
/*     */ 
/* 192 */     if (this.running)
/*     */     {
/* 194 */       formatElapsedTime(buff, getTime());
/*     */ 
/* 197 */       if (this.count >= 1) {
/* 198 */         buff.append(", count=").append(this.count);
/* 199 */         buff.append(", current=");
/* 200 */         formatElapsedTime(buff, getLapTime());
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 205 */       formatElapsedTime(buff, getTime());
/*     */ 
/* 208 */       if (this.count > 1) {
/* 209 */         buff.append(", count=").append(this.count);
/* 210 */         buff.append(", average=");
/* 211 */         formatElapsedTime(buff, getAverageLapTime());
/*     */       }
/*     */     }
/*     */ 
/* 215 */     return buff.toString();
/*     */   }
/*     */ 
/*     */   private void formatElapsedTime(StringBuffer buff, long lapsed)
/*     */   {
/* 220 */     long m = lapsed / 60000L;
/* 221 */     if (m != 0L) {
/* 222 */       buff.append(m).append("m:");
/*     */     }
/*     */ 
/* 225 */     long s = (lapsed - 60000L * m) / 1000L;
/* 226 */     if (s != 0L) {
/* 227 */       buff.append(s).append("s:");
/*     */     }
/*     */ 
/* 231 */     long ms = lapsed - 60000L * m - 1000L * s;
/* 232 */     buff.append(ms).append("ms");
/*     */   }
/*     */ 
/*     */   public Object clone()
/*     */   {
/*     */     try
/*     */     {
/* 243 */       return super.clone();
/*     */     } catch (CloneNotSupportedException e) {
/*     */     }
/* 246 */     throw new InternalError();
/*     */   }
/*     */ 
/*     */   public static StopWatch makeSynchronized(StopWatch watch)
/*     */   {
/* 316 */     return new Wrapper(watch)
/*     */     {
/*     */       public synchronized void start(boolean reset) {
/* 319 */         this.watch.start(reset);
/*     */       }
/*     */ 
/*     */       public synchronized void start() {
/* 323 */         this.watch.start();
/*     */       }
/*     */ 
/*     */       public synchronized long stop() {
/* 327 */         return this.watch.stop();
/*     */       }
/*     */ 
/*     */       public synchronized void reset() {
/* 331 */         this.watch.reset();
/*     */       }
/*     */ 
/*     */       public synchronized long getLapTime() {
/* 335 */         return this.watch.getLapTime();
/*     */       }
/*     */ 
/*     */       public synchronized long getAverageLapTime() {
/* 339 */         return this.watch.getAverageLapTime();
/*     */       }
/*     */ 
/*     */       public synchronized int getLapCount() {
/* 343 */         return this.watch.getLapCount();
/*     */       }
/*     */ 
/*     */       public synchronized long getTime() {
/* 347 */         return this.watch.getTime();
/*     */       }
/*     */ 
/*     */       public synchronized boolean isRunning() {
/* 351 */         return this.watch.isRunning();
/*     */       }
/*     */ 
/*     */       public synchronized String toString() {
/* 355 */         return this.watch.toString();
/*     */       }
/*     */     };
/*     */   }
/*     */ 
/*     */   private static class Wrapper extends StopWatch
/*     */   {
/*     */     protected StopWatch watch;
/*     */ 
/*     */     public Wrapper(StopWatch watch)
/*     */     {
/* 264 */       this.watch = watch;
/*     */     }
/*     */ 
/*     */     public void start(boolean reset) {
/* 268 */       this.watch.start(reset);
/*     */     }
/*     */ 
/*     */     public void start() {
/* 272 */       this.watch.start();
/*     */     }
/*     */ 
/*     */     public long stop() {
/* 276 */       return this.watch.stop();
/*     */     }
/*     */ 
/*     */     public void reset() {
/* 280 */       this.watch.reset();
/*     */     }
/*     */ 
/*     */     public long getLapTime() {
/* 284 */       return this.watch.getLapTime();
/*     */     }
/*     */ 
/*     */     public long getAverageLapTime() {
/* 288 */       return this.watch.getAverageLapTime();
/*     */     }
/*     */ 
/*     */     public int getLapCount() {
/* 292 */       return this.watch.getLapCount();
/*     */     }
/*     */ 
/*     */     public long getTime() {
/* 296 */       return this.watch.getTime();
/*     */     }
/*     */ 
/*     */     public boolean isRunning() {
/* 300 */       return this.watch.isRunning();
/*     */     }
/*     */ 
/*     */     public String toString() {
/* 304 */       return this.watch.toString();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.StopWatch
 * JD-Core Version:    0.6.0
 */