/*     */ package org.jboss.util;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.util.Properties;
/*     */ 
/*     */ public final class StringPropertyReplacer
/*     */ {
/*  40 */   public static final String NEWLINE = SysPropertyActions.getProperty("line.separator", "\n");
/*     */ 
/*  43 */   private static final String FILE_SEPARATOR = File.separator;
/*     */ 
/*  46 */   private static final String PATH_SEPARATOR = File.pathSeparator;
/*     */   private static final String FILE_SEPARATOR_ALIAS = "/";
/*     */   private static final String PATH_SEPARATOR_ALIAS = ":";
/*     */   private static final int NORMAL = 0;
/*     */   private static final int SEEN_DOLLAR = 1;
/*     */   private static final int IN_BRACKET = 2;
/*     */ 
/*     */   public static String replaceProperties(String string)
/*     */   {
/*  80 */     return replaceProperties(string, null);
/*     */   }
/*     */ 
/*     */   public static String replaceProperties(String string, Properties props)
/*     */   {
/* 106 */     char[] chars = string.toCharArray();
/* 107 */     StringBuffer buffer = new StringBuffer();
/* 108 */     boolean properties = false;
/* 109 */     int state = 0;
/* 110 */     int start = 0;
/* 111 */     for (int i = 0; i < chars.length; i++)
/*     */     {
/* 113 */       char c = chars[i];
/*     */ 
/* 116 */       if ((c == '$') && (state != 2)) {
/* 117 */         state = 1;
/*     */       }
/* 120 */       else if ((c == '{') && (state == 1))
/*     */       {
/* 122 */         buffer.append(string.substring(start, i - 1));
/* 123 */         state = 2;
/* 124 */         start = i - 1;
/*     */       }
/* 128 */       else if (state == 1) {
/* 129 */         state = 0;
/*     */       }
/*     */       else {
/* 132 */         if ((c != '}') || (state != 2)) {
/*     */           continue;
/*     */         }
/* 135 */         if (start + 2 == i)
/*     */         {
/* 137 */           buffer.append("${}");
/*     */         }
/*     */         else
/*     */         {
/* 141 */           String value = null;
/*     */ 
/* 143 */           String key = string.substring(start + 2, i);
/*     */ 
/* 146 */           if ("/".equals(key))
/*     */           {
/* 148 */             value = FILE_SEPARATOR;
/*     */           }
/* 150 */           else if (":".equals(key))
/*     */           {
/* 152 */             value = PATH_SEPARATOR;
/*     */           }
/*     */           else
/*     */           {
/* 157 */             if (props != null)
/* 158 */               value = props.getProperty(key);
/*     */             else {
/* 160 */               value = System.getProperty(key);
/*     */             }
/* 162 */             if (value == null)
/*     */             {
/* 165 */               int colon = key.indexOf(':');
/* 166 */               if (colon > 0)
/*     */               {
/* 168 */                 String realKey = key.substring(0, colon);
/* 169 */                 if (props != null)
/* 170 */                   value = props.getProperty(realKey);
/*     */                 else {
/* 172 */                   value = System.getProperty(realKey);
/*     */                 }
/* 174 */                 if (value == null)
/*     */                 {
/* 177 */                   value = resolveCompositeKey(realKey, props);
/*     */ 
/* 180 */                   if (value == null) {
/* 181 */                     value = key.substring(colon + 1);
/*     */                   }
/*     */                 }
/*     */               }
/*     */               else
/*     */               {
/* 187 */                 value = resolveCompositeKey(key, props);
/*     */               }
/*     */             }
/*     */           }
/*     */ 
/* 192 */           if (value != null)
/*     */           {
/* 194 */             properties = true;
/* 195 */             buffer.append(value);
/*     */           }
/*     */         }
/* 198 */         start = i + 1;
/* 199 */         state = 0;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 204 */     if (!properties) {
/* 205 */       return string;
/*     */     }
/*     */ 
/* 208 */     if (start != chars.length) {
/* 209 */       buffer.append(string.substring(start, chars.length));
/*     */     }
/*     */ 
/* 212 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   private static String resolveCompositeKey(String key, Properties props)
/*     */   {
/* 228 */     String value = null;
/*     */ 
/* 231 */     int comma = key.indexOf(',');
/* 232 */     if (comma > -1)
/*     */     {
/* 235 */       if (comma > 0)
/*     */       {
/* 238 */         String key1 = key.substring(0, comma);
/* 239 */         if (props != null)
/* 240 */           value = props.getProperty(key1);
/*     */         else {
/* 242 */           value = System.getProperty(key1);
/*     */         }
/*     */       }
/* 245 */       if ((value == null) && (comma < key.length() - 1))
/*     */       {
/* 247 */         String key2 = key.substring(comma + 1);
/* 248 */         if (props != null)
/* 249 */           value = props.getProperty(key2);
/*     */         else {
/* 251 */           value = System.getProperty(key2);
/*     */         }
/*     */       }
/*     */     }
/* 255 */     return value;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.StringPropertyReplacer
 * JD-Core Version:    0.6.0
 */