/*     */ package org.jboss.util;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import java.util.Timer;
/*     */ import java.util.TimerTask;
/*     */ 
/*     */ public class TimedCachePolicy extends TimerTask
/*     */   implements CachePolicy
/*     */ {
/*  80 */   protected static Timer resolutionTimer = new Timer(true);
/*     */   protected Map entryMap;
/*     */   protected int defaultLifetime;
/*     */   protected boolean threadSafe;
/*     */   protected long now;
/*     */   protected int resolution;
/*     */   protected ResolutionTimer theTimer;
/*     */ 
/*     */   public TimedCachePolicy()
/*     */   {
/* 102 */     this(1800, false, 0);
/*     */   }
/*     */ 
/*     */   public TimedCachePolicy(int defaultLifetime)
/*     */   {
/* 110 */     this(defaultLifetime, false, 0);
/*     */   }
/*     */ 
/*     */   public TimedCachePolicy(int defaultLifetime, boolean threadSafe, int resolution)
/*     */   {
/* 127 */     this.defaultLifetime = defaultLifetime;
/* 128 */     this.threadSafe = threadSafe;
/* 129 */     if (resolution <= 0)
/* 130 */       resolution = 60;
/* 131 */     this.resolution = resolution;
/*     */   }
/*     */ 
/*     */   public void create()
/*     */   {
/* 139 */     if (this.threadSafe)
/* 140 */       this.entryMap = Collections.synchronizedMap(new HashMap());
/*     */     else
/* 142 */       this.entryMap = new HashMap();
/* 143 */     this.now = System.currentTimeMillis();
/*     */   }
/*     */ 
/*     */   public void start()
/*     */   {
/* 150 */     this.theTimer = new ResolutionTimer(null);
/* 151 */     resolutionTimer.scheduleAtFixedRate(this.theTimer, 0L, 1000 * this.resolution);
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/* 157 */     this.theTimer.cancel();
/* 158 */     flush();
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/* 164 */     this.entryMap.clear();
/*     */   }
/*     */ 
/*     */   public Object get(Object key)
/*     */   {
/* 175 */     TimedEntry entry = (TimedEntry)this.entryMap.get(key);
/* 176 */     if (entry == null) {
/* 177 */       return null;
/*     */     }
/* 179 */     if (!entry.isCurrent(this.now))
/*     */     {
/* 181 */       if (!entry.refresh())
/*     */       {
/* 183 */         entry.destroy();
/* 184 */         this.entryMap.remove(key);
/* 185 */         return null;
/*     */       }
/*     */     }
/* 188 */     Object value = entry.getValue();
/* 189 */     return value;
/*     */   }
/*     */ 
/*     */   public Object peek(Object key)
/*     */   {
/* 198 */     TimedEntry entry = (TimedEntry)this.entryMap.get(key);
/* 199 */     Object value = null;
/* 200 */     if (entry != null)
/* 201 */       value = entry.getValue();
/* 202 */     return value;
/*     */   }
/*     */ 
/*     */   public void insert(Object key, Object value)
/*     */   {
/* 214 */     if (this.entryMap.containsKey(key))
/* 215 */       throw new IllegalStateException("Attempt to insert duplicate entry");
/* 216 */     TimedEntry entry = null;
/* 217 */     if (!(value instanceof TimedEntry))
/*     */     {
/* 219 */       entry = new DefaultTimedEntry(this.defaultLifetime, value);
/*     */     }
/*     */     else
/*     */     {
/* 223 */       entry = (TimedEntry)value;
/*     */     }
/* 225 */     entry.init(this.now);
/* 226 */     this.entryMap.put(key, entry);
/*     */   }
/*     */ 
/*     */   public void remove(Object key)
/*     */   {
/* 233 */     TimedEntry entry = (TimedEntry)this.entryMap.remove(key);
/* 234 */     if (entry != null)
/* 235 */       entry.destroy();
/*     */   }
/*     */ 
/*     */   public void flush()
/*     */   {
/* 241 */     Map tmpMap = null;
/* 242 */     synchronized (this)
/*     */     {
/* 244 */       tmpMap = this.entryMap;
/* 245 */       if (this.threadSafe)
/* 246 */         this.entryMap = Collections.synchronizedMap(new HashMap());
/*     */       else {
/* 248 */         this.entryMap = new HashMap();
/*     */       }
/*     */     }
/*     */ 
/* 252 */     Iterator iter = tmpMap.values().iterator();
/* 253 */     while (iter.hasNext())
/*     */     {
/* 255 */       TimedEntry entry = (TimedEntry)iter.next();
/* 256 */       entry.destroy();
/*     */     }
/* 258 */     tmpMap.clear();
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 263 */     return this.entryMap.size();
/*     */   }
/*     */ 
/*     */   public List getValidKeys()
/*     */   {
/* 273 */     ArrayList validKeys = new ArrayList();
/* 274 */     synchronized (this.entryMap)
/*     */     {
/* 276 */       Iterator iter = this.entryMap.entrySet().iterator();
/* 277 */       while (iter.hasNext())
/*     */       {
/* 279 */         Map.Entry entry = (Map.Entry)iter.next();
/* 280 */         TimedEntry value = (TimedEntry)entry.getValue();
/* 281 */         if (value.isCurrent(this.now) == true)
/* 282 */           validKeys.add(entry.getKey());
/*     */       }
/*     */     }
/* 285 */     return validKeys;
/*     */   }
/*     */ 
/*     */   public int getDefaultLifetime()
/*     */   {
/* 293 */     return this.defaultLifetime;
/*     */   }
/*     */ 
/*     */   public synchronized void setDefaultLifetime(int defaultLifetime)
/*     */   {
/* 301 */     this.defaultLifetime = defaultLifetime;
/*     */   }
/*     */ 
/*     */   public int getResolution()
/*     */   {
/* 310 */     return this.resolution;
/*     */   }
/*     */ 
/*     */   public synchronized void setResolution(int resolution)
/*     */   {
/* 320 */     if (resolution <= 0)
/* 321 */       resolution = 60;
/* 322 */     if (resolution != this.resolution)
/*     */     {
/* 324 */       this.resolution = resolution;
/* 325 */       this.theTimer.cancel();
/* 326 */       this.theTimer = new ResolutionTimer(null);
/* 327 */       resolutionTimer.scheduleAtFixedRate(this.theTimer, 0L, 1000 * resolution);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void run()
/*     */   {
/* 336 */     this.now = System.currentTimeMillis();
/*     */   }
/*     */ 
/*     */   public long currentTimeMillis()
/*     */   {
/* 344 */     return this.now;
/*     */   }
/*     */ 
/*     */   public TimedEntry peekEntry(Object key)
/*     */   {
/* 352 */     TimedEntry entry = (TimedEntry)this.entryMap.get(key);
/* 353 */     return entry;
/*     */   }
/*     */ 
/*     */   private class ResolutionTimer extends TimerTask
/*     */   {
/*     */     private ResolutionTimer()
/*     */     {
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/* 397 */       TimedCachePolicy.this.run();
/*     */     }
/*     */   }
/*     */ 
/*     */   static class DefaultTimedEntry
/*     */     implements TimedCachePolicy.TimedEntry
/*     */   {
/*     */     long expirationTime;
/*     */     Object value;
/*     */ 
/*     */     DefaultTimedEntry(long lifetime, Object value)
/*     */     {
/* 366 */       this.expirationTime = (1000L * lifetime);
/* 367 */       this.value = value;
/*     */     }
/*     */ 
/*     */     public void init(long now) {
/* 371 */       this.expirationTime += now;
/*     */     }
/*     */ 
/*     */     public boolean isCurrent(long now) {
/* 375 */       return this.expirationTime > now;
/*     */     }
/*     */ 
/*     */     public boolean refresh() {
/* 379 */       return false;
/*     */     }
/*     */ 
/*     */     public void destroy() {
/*     */     }
/*     */ 
/*     */     public Object getValue() {
/* 386 */       return this.value;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static abstract interface TimedEntry
/*     */   {
/*     */     public abstract void init(long paramLong);
/*     */ 
/*     */     public abstract boolean isCurrent(long paramLong);
/*     */ 
/*     */     public abstract boolean refresh();
/*     */ 
/*     */     public abstract void destroy();
/*     */ 
/*     */     public abstract Object getValue();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.TimedCachePolicy
 * JD-Core Version:    0.6.0
 */