/*     */ package org.jboss.util;
/*     */ 
/*     */ public abstract class TimerTask
/*     */   implements Executable, Comparable
/*     */ {
/*     */   static final int NEW = 1;
/*     */   static final int SCHEDULED = 2;
/*     */   static final int EXECUTED = 3;
/*     */   static final int CANCELLED = 4;
/*  48 */   private final Object m_lock = new Object();
/*     */   private int m_state;
/*     */   private final long m_period;
/*     */   private long m_nextExecutionTime;
/*     */ 
/*     */   protected TimerTask()
/*     */   {
/*  59 */     this.m_state = 1;
/*  60 */     this.m_period = 0L;
/*     */   }
/*     */ 
/*     */   protected TimerTask(long period)
/*     */   {
/*  70 */     this.m_state = 1;
/*  71 */     if (period < 0L) throw new IllegalArgumentException("Period can't be negative");
/*  72 */     this.m_period = period;
/*     */   }
/*     */ 
/*     */   public boolean cancel()
/*     */   {
/*  83 */     synchronized (getLock())
/*     */     {
/*  85 */       boolean ret = this.m_state == 2;
/*  86 */       this.m_state = 4;
/*  87 */       return ret;
/*     */     }
/*     */   }
/*     */ 
/*     */   public abstract void execute()
/*     */     throws Exception;
/*     */ 
/*     */   public int compareTo(Object other)
/*     */   {
/* 106 */     if (other == this) return 0;
/* 107 */     TimerTask t = (TimerTask)other;
/* 108 */     long diff = getNextExecutionTime() - t.getNextExecutionTime();
/* 109 */     return (int)diff;
/*     */   }
/*     */ 
/*     */   Object getLock()
/*     */   {
/* 115 */     return this.m_lock;
/*     */   }
/*     */ 
/*     */   void setState(int state)
/*     */   {
/* 121 */     synchronized (getLock())
/*     */     {
/* 123 */       this.m_state = state;
/*     */     }
/*     */   }
/*     */ 
/*     */   int getState()
/*     */   {
/* 130 */     synchronized (getLock())
/*     */     {
/* 132 */       return this.m_state;
/*     */     }
/*     */   }
/*     */ 
/*     */   boolean isPeriodic()
/*     */   {
/* 139 */     return this.m_period > 0L;
/*     */   }
/*     */ 
/*     */   long getNextExecutionTime()
/*     */   {
/* 145 */     synchronized (getLock())
/*     */     {
/* 147 */       return this.m_nextExecutionTime;
/*     */     }
/*     */   }
/*     */ 
/*     */   void setNextExecutionTime(long time)
/*     */   {
/* 154 */     synchronized (getLock())
/*     */     {
/* 156 */       this.m_nextExecutionTime = time;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected long getPeriod()
/*     */   {
/* 163 */     return this.m_period;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.TimerTask
 * JD-Core Version:    0.6.0
 */