/*    */ package org.jboss.util;
/*    */ 
/*    */ public class WaitSemaphore extends Semaphore
/*    */   implements WaitSync
/*    */ {
/*    */   private static final int MAX_USERS_ALLOWED = 1;
/*    */   private int m_waiters;
/*    */ 
/*    */   public WaitSemaphore()
/*    */   {
/* 45 */     super(1);
/*    */   }
/*    */ 
/*    */   public void doWait()
/*    */     throws InterruptedException
/*    */   {
/* 51 */     synchronized (this)
/*    */     {
/* 53 */       release();
/* 54 */       this.m_waiters += 1;
/* 55 */       waitImpl(this);
/* 56 */       this.m_waiters -= 1;
/* 57 */       acquire();
/*    */     }
/*    */   }
/*    */ 
/*    */   public void doNotify() throws InterruptedException
/*    */   {
/* 63 */     synchronized (this)
/*    */     {
/* 65 */       if (getWaiters() > 0)
/*    */       {
/* 67 */         acquire();
/* 68 */         notify();
/* 69 */         release();
/*    */       }
/*    */     }
/*    */   }
/*    */ 
/*    */   public int getWaiters()
/*    */   {
/* 76 */     synchronized (this)
/*    */     {
/* 78 */       return this.m_waiters;
/*    */     }
/*    */   }
/*    */ 
/*    */   public String toString()
/*    */   {
/* 85 */     return super.toString() + " - " + this.m_waiters;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.WaitSemaphore
 * JD-Core Version:    0.6.0
 */