/*     */ package org.jboss.util.collection;
/*     */ 
/*     */ import java.util.AbstractCollection;
/*     */ 
/*     */ public abstract class AbstractQueue extends AbstractCollection
/*     */   implements Queue
/*     */ {
/*  38 */   public static int DEFAULT_MAXIMUM_SIZE = -1;
/*     */ 
/*  41 */   protected int maximumSize = DEFAULT_MAXIMUM_SIZE;
/*     */ 
/*     */   protected AbstractQueue()
/*     */   {
/*     */   }
/*     */ 
/*     */   protected AbstractQueue(int maxSize)
/*     */   {
/*  56 */     setMaximumSize(maxSize);
/*     */   }
/*     */ 
/*     */   public int getMaximumSize()
/*     */   {
/*  65 */     return this.maximumSize;
/*     */   }
/*     */ 
/*     */   public void setMaximumSize(int size)
/*     */   {
/*  76 */     if ((size < 0) && (size != -1)) {
/*  77 */       throw new IllegalArgumentException("illegal size: " + size);
/*     */     }
/*  79 */     this.maximumSize = size;
/*     */   }
/*     */ 
/*     */   public boolean isFull()
/*     */   {
/*  89 */     return (this.maximumSize != -1) && (size() >= this.maximumSize);
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/* 101 */     return size() <= 0;
/*     */   }
/*     */ 
/*     */   public boolean add(Object obj)
/*     */     throws FullCollectionException
/*     */   {
/* 115 */     if (isFull()) {
/* 116 */       throw new FullCollectionException();
/*     */     }
/* 118 */     return addLast(obj);
/*     */   }
/*     */ 
/*     */   public Object remove()
/*     */     throws EmptyCollectionException
/*     */   {
/* 129 */     if (isEmpty()) {
/* 130 */       throw new EmptyCollectionException();
/*     */     }
/* 132 */     return removeFirst();
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/* 139 */     while (!isEmpty())
/* 140 */       remove();
/*     */   }
/*     */ 
/*     */   protected abstract boolean addLast(Object paramObject);
/*     */ 
/*     */   protected abstract Object removeFirst();
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.collection.AbstractQueue
 * JD-Core Version:    0.6.0
 */