/*     */ package org.jboss.util.collection;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import org.jboss.util.HashCode;
/*     */ import org.jboss.util.NullArgumentException;
/*     */ import org.jboss.util.Objects;
/*     */ import org.jboss.util.Strings;
/*     */ 
/*     */ public class CompoundKey
/*     */   implements Serializable, Cloneable
/*     */ {
/*     */   private final Object[] elements;
/*     */ 
/*     */   public CompoundKey(Object[] elements)
/*     */   {
/*  49 */     if (elements == null) {
/*  50 */       throw new NullArgumentException("elements");
/*     */     }
/*  52 */     this.elements = elements;
/*     */   }
/*     */ 
/*     */   public CompoundKey(Object a, Object b)
/*     */   {
/*  62 */     this(new Object[] { a, b });
/*     */   }
/*     */ 
/*     */   public CompoundKey(Object a, Object b, Object c)
/*     */   {
/*  73 */     this(new Object[] { a, b, c });
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/*  83 */     if (obj == this) return true;
/*     */ 
/*  85 */     if ((obj != null) && (obj.getClass() == getClass())) {
/*  86 */       CompoundKey key = (CompoundKey)obj;
/*     */ 
/*  88 */       return Objects.equals(key.elements, this.elements);
/*     */     }
/*     */ 
/*  91 */     return false;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 100 */     return HashCode.generate(this.elements);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 109 */     return super.toString() + Strings.join(this.elements, "[", ",", "]");
/*     */   }
/*     */ 
/*     */   public Object clone()
/*     */   {
/*     */     try
/*     */     {
/* 119 */       return super.clone();
/*     */     } catch (CloneNotSupportedException e) {
/*     */     }
/* 122 */     throw new InternalError();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.collection.CompoundKey
 * JD-Core Version:    0.6.0
 */