/*     */ package org.jboss.util.collection;
/*     */ 
/*     */ import java.util.Enumeration;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.NoSuchElementException;
/*     */ import java.util.Set;
/*     */ import org.jboss.util.Null;
/*     */ 
/*     */ public final class Iterators
/*     */ {
/* 224 */   public static final Iterator EMPTY_ITERATOR = new EmptyIterator(null);
/*     */ 
/*     */   public static Iterator forEnumeration(Enumeration enumeration)
/*     */   {
/*  77 */     return new Enum2Iterator(enumeration);
/*     */   }
/*     */ 
/*     */   public static Enumeration toEnumeration(Iterator iter)
/*     */   {
/* 108 */     return new Iter2Enumeration(iter);
/*     */   }
/*     */ 
/*     */   public static Iterator makeImmutable(Iterator iter)
/*     */   {
/* 149 */     return new ImmutableIterator(iter);
/*     */   }
/*     */ 
/*     */   public static Iterator makeSynchronized(Iterator iter)
/*     */   {
/* 184 */     return new SyncIterator(iter);
/*     */   }
/*     */ 
/*     */   public static Enumeration makeSynchronized(Enumeration enumeration)
/*     */   {
/* 215 */     return new SyncEnumeration(enumeration);
/*     */   }
/*     */ 
/*     */   public static Iterator union(Iterator[] iters)
/*     */   {
/* 258 */     Map map = new HashMap();
/*     */ 
/* 260 */     for (int i = 0; i < iters.length; i++) {
/* 261 */       if (iters[i] != null) {
/* 262 */         while (iters[i].hasNext()) {
/* 263 */           Object obj = iters[i].next();
/* 264 */           if (!map.containsKey(obj)) {
/* 265 */             map.put(obj, Null.VALUE);
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 271 */     return map.keySet().iterator();
/*     */   }
/*     */ 
/*     */   public static String toString(Iterator iter, String delim)
/*     */   {
/* 283 */     StringBuffer buff = new StringBuffer();
/* 284 */     while (iter.hasNext()) {
/* 285 */       buff.append(iter.next());
/*     */ 
/* 287 */       if (iter.hasNext()) {
/* 288 */         buff.append(delim);
/*     */       }
/*     */     }
/*     */ 
/* 292 */     return buff.toString();
/*     */   }
/*     */ 
/*     */   public static String toString(Iterator iter)
/*     */   {
/* 303 */     return toString(iter, ",");
/*     */   }
/*     */ 
/*     */   private static final class EmptyIterator
/*     */     implements Iterator
/*     */   {
/*     */     public boolean hasNext()
/*     */     {
/* 233 */       return false;
/*     */     }
/*     */ 
/*     */     public Object next() {
/* 237 */       throw new NoSuchElementException("no more elements");
/*     */     }
/*     */ 
/*     */     public void remove() {
/* 241 */       throw new IllegalStateException("no more elements");
/*     */     }
/*     */   }
/*     */ 
/*     */   private static final class SyncEnumeration
/*     */     implements Enumeration
/*     */   {
/*     */     private final Enumeration enumeration;
/*     */ 
/*     */     public SyncEnumeration(Enumeration enumeration)
/*     */     {
/* 196 */       this.enumeration = enumeration;
/*     */     }
/*     */ 
/*     */     public synchronized boolean hasMoreElements() {
/* 200 */       return this.enumeration.hasMoreElements();
/*     */     }
/*     */ 
/*     */     public synchronized Object nextElement() {
/* 204 */       return this.enumeration.nextElement();
/*     */     }
/*     */   }
/*     */ 
/*     */   private static final class SyncIterator
/*     */     implements Iterator
/*     */   {
/*     */     private final Iterator iter;
/*     */ 
/*     */     public SyncIterator(Iterator iter)
/*     */     {
/* 161 */       this.iter = iter;
/*     */     }
/*     */ 
/*     */     public synchronized boolean hasNext() {
/* 165 */       return this.iter.hasNext();
/*     */     }
/*     */ 
/*     */     public synchronized Object next() {
/* 169 */       return this.iter.next();
/*     */     }
/*     */ 
/*     */     public synchronized void remove() {
/* 173 */       this.iter.remove();
/*     */     }
/*     */   }
/*     */ 
/*     */   private static final class ImmutableIterator
/*     */     implements Iterator
/*     */   {
/*     */     private final Iterator iter;
/*     */ 
/*     */     public ImmutableIterator(Iterator iter)
/*     */     {
/* 126 */       this.iter = iter;
/*     */     }
/*     */ 
/*     */     public boolean hasNext() {
/* 130 */       return this.iter.hasNext();
/*     */     }
/*     */ 
/*     */     public Object next() {
/* 134 */       return this.iter.next();
/*     */     }
/*     */ 
/*     */     public void remove() {
/* 138 */       throw new UnsupportedOperationException("iterator is immutable");
/*     */     }
/*     */   }
/*     */ 
/*     */   private static final class Iter2Enumeration
/*     */     implements Enumeration
/*     */   {
/*     */     private final Iterator iter;
/*     */ 
/*     */     public Iter2Enumeration(Iterator iter)
/*     */     {
/*  89 */       this.iter = iter;
/*     */     }
/*     */ 
/*     */     public boolean hasMoreElements() {
/*  93 */       return this.iter.hasNext();
/*     */     }
/*     */ 
/*     */     public Object nextElement() {
/*  97 */       return this.iter.next();
/*     */     }
/*     */   }
/*     */ 
/*     */   private static final class Enum2Iterator
/*     */     implements Iterator
/*     */   {
/*     */     private final Enumeration enumeration;
/*     */ 
/*     */     public Enum2Iterator(Enumeration enumeration)
/*     */     {
/*  54 */       this.enumeration = enumeration;
/*     */     }
/*     */ 
/*     */     public boolean hasNext() {
/*  58 */       return this.enumeration.hasMoreElements();
/*     */     }
/*     */ 
/*     */     public Object next() {
/*  62 */       return this.enumeration.nextElement();
/*     */     }
/*     */ 
/*     */     public void remove() {
/*  66 */       throw new UnsupportedOperationException("Enumerations are immutable");
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.collection.Iterators
 * JD-Core Version:    0.6.0
 */