/*     */ package org.jboss.util.collection;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.ListIterator;
/*     */ 
/*     */ public class LazyList<T>
/*     */   implements List<T>, Serializable
/*     */ {
/*  43 */   private List<T> delegate = Collections.emptyList();
/*     */ 
/*     */   private List<T> createImplementation()
/*     */   {
/*  52 */     if (!(this.delegate instanceof ArrayList))
/*  53 */       return new ArrayList(this.delegate);
/*  54 */     return this.delegate;
/*     */   }
/*     */ 
/*     */   public void add(int index, T element)
/*     */   {
/*  59 */     this.delegate = createImplementation();
/*  60 */     this.delegate.add(index, element);
/*     */   }
/*     */ 
/*     */   public boolean add(T o)
/*     */   {
/*  65 */     if (this.delegate.isEmpty())
/*     */     {
/*  67 */       this.delegate = Collections.singletonList(o);
/*  68 */       return true;
/*     */     }
/*     */ 
/*  72 */     this.delegate = createImplementation();
/*  73 */     return this.delegate.add(o);
/*     */   }
/*     */ 
/*     */   public boolean addAll(Collection<? extends T> c)
/*     */   {
/*  79 */     this.delegate = createImplementation();
/*  80 */     return this.delegate.addAll(c);
/*     */   }
/*     */ 
/*     */   public boolean addAll(int index, Collection<? extends T> c)
/*     */   {
/*  85 */     this.delegate = createImplementation();
/*  86 */     return this.delegate.addAll(index, c);
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/*  91 */     this.delegate = Collections.emptyList();
/*     */   }
/*     */ 
/*     */   public boolean contains(Object o)
/*     */   {
/*  96 */     return this.delegate.contains(o);
/*     */   }
/*     */ 
/*     */   public boolean containsAll(Collection<?> c)
/*     */   {
/* 101 */     return this.delegate.containsAll(c);
/*     */   }
/*     */ 
/*     */   public T get(int index)
/*     */   {
/* 106 */     return this.delegate.get(index);
/*     */   }
/*     */ 
/*     */   public int indexOf(Object o)
/*     */   {
/* 111 */     return this.delegate.indexOf(o);
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/* 116 */     return this.delegate.isEmpty();
/*     */   }
/*     */ 
/*     */   public Iterator<T> iterator()
/*     */   {
/* 121 */     return this.delegate.iterator();
/*     */   }
/*     */ 
/*     */   public int lastIndexOf(Object o)
/*     */   {
/* 126 */     return this.delegate.lastIndexOf(o);
/*     */   }
/*     */ 
/*     */   public ListIterator<T> listIterator()
/*     */   {
/* 131 */     return this.delegate.listIterator();
/*     */   }
/*     */ 
/*     */   public ListIterator<T> listIterator(int index)
/*     */   {
/* 136 */     return this.delegate.listIterator(index);
/*     */   }
/*     */ 
/*     */   public T remove(int index)
/*     */   {
/* 141 */     this.delegate = createImplementation();
/* 142 */     return this.delegate.remove(index);
/*     */   }
/*     */ 
/*     */   public boolean remove(Object o)
/*     */   {
/* 147 */     this.delegate = createImplementation();
/* 148 */     return this.delegate.remove(o);
/*     */   }
/*     */ 
/*     */   public boolean removeAll(Collection<?> c)
/*     */   {
/* 153 */     this.delegate = createImplementation();
/* 154 */     return this.delegate.removeAll(c);
/*     */   }
/*     */ 
/*     */   public boolean retainAll(Collection<?> c)
/*     */   {
/* 159 */     this.delegate = createImplementation();
/* 160 */     return this.delegate.retainAll(c);
/*     */   }
/*     */ 
/*     */   public T set(int index, T element)
/*     */   {
/* 165 */     this.delegate = createImplementation();
/* 166 */     return this.delegate.set(index, element);
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 171 */     return this.delegate.size();
/*     */   }
/*     */ 
/*     */   public List<T> subList(int fromIndex, int toIndex)
/*     */   {
/* 176 */     return this.delegate.subList(fromIndex, toIndex);
/*     */   }
/*     */ 
/*     */   public Object[] toArray()
/*     */   {
/* 181 */     return this.delegate.toArray();
/*     */   }
/*     */ 
/*     */   public <U> U[] toArray(U[] a)
/*     */   {
/* 186 */     return this.delegate.toArray(a);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.collection.LazyList
 * JD-Core Version:    0.6.0
 */