/*     */ package org.jboss.util.collection;
/*     */ 
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.util.Map;
/*     */ import java.util.WeakHashMap;
/*     */ 
/*     */ public abstract class WeakClassCache
/*     */ {
/*  43 */   protected Map cache = new WeakHashMap();
/*     */ 
/*     */   public Object get(Class clazz)
/*     */   {
/*  53 */     if (clazz == null) {
/*  54 */       throw new IllegalArgumentException("Null class");
/*     */     }
/*  56 */     Map classLoaderCache = getClassLoaderCache(clazz.getClassLoader());
/*     */ 
/*  58 */     WeakReference weak = (WeakReference)classLoaderCache.get(clazz.getName());
/*  59 */     if (weak != null)
/*     */     {
/*  61 */       Object result = weak.get();
/*  62 */       if (result != null) {
/*  63 */         return result;
/*     */       }
/*     */     }
/*  66 */     Object result = instantiate(clazz);
/*     */ 
/*  68 */     weak = new WeakReference(result);
/*  69 */     classLoaderCache.put(clazz.getName(), weak);
/*     */ 
/*  71 */     generate(clazz, result);
/*     */ 
/*  73 */     return result;
/*     */   }
/*     */ 
/*     */   public Object get(String name, ClassLoader cl)
/*     */     throws ClassNotFoundException
/*     */   {
/*  86 */     if (name == null)
/*  87 */       throw new IllegalArgumentException("Null name");
/*  88 */     if (cl == null)
/*  89 */       throw new IllegalArgumentException("Null classloader");
/*  90 */     Class clazz = cl.loadClass(name);
/*  91 */     return get(clazz);
/*     */   }
/*     */ 
/*     */   protected abstract Object instantiate(Class paramClass);
/*     */ 
/*     */   protected abstract void generate(Class paramClass, Object paramObject);
/*     */ 
/*     */   protected Map getClassLoaderCache(ClassLoader cl)
/*     */   {
/* 118 */     synchronized (this.cache)
/*     */     {
/* 120 */       Map result = (Map)this.cache.get(cl);
/* 121 */       if (result == null)
/*     */       {
/* 123 */         result = CollectionsFactory.createConcurrentReaderMap();
/* 124 */         this.cache.put(cl, result);
/*     */       }
/* 126 */       return result;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.collection.WeakClassCache
 * JD-Core Version:    0.6.0
 */